// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.Communication.CallAutomation
{
    /// <summary> The RecognizeFailed. </summary>
    public partial class RecognizeFailed
    {
        /// <summary> Initializes a new instance of <see cref="RecognizeFailed"/>. </summary>
        internal RecognizeFailed()
        {
        }

        /// <summary> Initializes a new instance of <see cref="RecognizeFailed"/>. </summary>
        /// <param name="operationContext"> Used by customers when calling mid-call actions to correlate the request to the response event. </param>
        /// <param name="resultInformation"> Contains the resulting SIP code, sub-code and message. </param>
        /// <param name="failedPlaySourceIndex"> Indicates the index of the failed play source. </param>
        /// <param name="callConnectionId"> Call connection ID. </param>
        /// <param name="serverCallId"> Server call ID. </param>
        /// <param name="correlationId"> Correlation ID for event to call correlation. Also called ChainId for skype chain ID. </param>
        internal RecognizeFailed(string operationContext, ResultInformation resultInformation, int? failedPlaySourceIndex, string callConnectionId, string serverCallId, string correlationId)
        {
            OperationContext = operationContext;
            ResultInformation = resultInformation;
            FailedPlaySourceIndex = failedPlaySourceIndex;
            CallConnectionId = callConnectionId;
            ServerCallId = serverCallId;
            CorrelationId = correlationId;
        }
        /// <summary> Indicates the index of the failed play source. </summary>
        public int? FailedPlaySourceIndex { get; }
    }
}
