// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.Communication.CallAutomation
{
    /// <summary> The RecognizeCompleted. </summary>
    internal partial class RecognizeCompletedInternal
    {
        /// <summary> Initializes a new instance of <see cref="RecognizeCompletedInternal"/>. </summary>
        internal RecognizeCompletedInternal()
        {
        }

        /// <summary> Initializes a new instance of <see cref="RecognizeCompletedInternal"/>. </summary>
        /// <param name="operationContext"> Used by customers when calling mid-call actions to correlate the request to the response event. </param>
        /// <param name="resultInformation"> Result information defines the code, subcode and message. </param>
        /// <param name="recognitionType">
        /// Determines the sub-type of the recognize operation.
        /// In case of cancel operation the this field is not set and is returned empty
        /// </param>
        /// <param name="collectTonesResult">
        /// Defines the result for RecognitionType = Dtmf
        /// Would be replaced by DtmfResult after server sdk renewed
        /// </param>
        /// <param name="dtmfResult"> Defines the result for RecognitionType = Dtmf. </param>
        /// <param name="speechResult"> Defines the result for RecognitionType = Speech and SpeechOrDtmf. </param>
        /// <param name="choiceResult"> Defines the result for RecognitionType = Choices. </param>
        /// <param name="callConnectionId"> Call connection ID. </param>
        /// <param name="serverCallId"> Server call ID. </param>
        /// <param name="correlationId"> Correlation ID for event to call correlation. Also called ChainId for skype chain ID. </param>
        internal RecognizeCompletedInternal(string operationContext, ResultInformation resultInformation, CallMediaRecognitionType recognitionType, CollectTonesResult collectTonesResult, DtmfResult dtmfResult, SpeechResult speechResult, ChoiceResult choiceResult, string callConnectionId, string serverCallId, string correlationId)
        {
            OperationContext = operationContext;
            ResultInformation = resultInformation;
            RecognitionType = recognitionType;
            CollectTonesResult = collectTonesResult;
            DtmfResult = dtmfResult;
            SpeechResult = speechResult;
            ChoiceResult = choiceResult;
            CallConnectionId = callConnectionId;
            ServerCallId = serverCallId;
            CorrelationId = correlationId;
        }
        /// <summary>
        /// Defines the result for RecognitionType = Dtmf
        /// Would be replaced by DtmfResult after server sdk renewed
        /// </summary>
        public CollectTonesResult CollectTonesResult { get; }
        /// <summary> Defines the result for RecognitionType = Dtmf. </summary>
        public DtmfResult DtmfResult { get; }
        /// <summary> Defines the result for RecognitionType = Speech and SpeechOrDtmf. </summary>
        public SpeechResult SpeechResult { get; }
        /// <summary> Defines the result for RecognitionType = Choices. </summary>
        public ChoiceResult ChoiceResult { get; }
    }
}
