// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.Communication.CallAutomation
{
    /// <summary> The Choice. </summary>
    public partial class RecognitionChoice
    {
        /// <summary> Initializes a new instance of <see cref="RecognitionChoice"/>. </summary>
        /// <param name="label"> Identifier for a given choice. </param>
        /// <param name="phrases"> List of phrases to recognize. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="label"/> or <paramref name="phrases"/> is null. </exception>
        public RecognitionChoice(string label, IEnumerable<string> phrases)
        {
            Argument.AssertNotNull(label, nameof(label));
            Argument.AssertNotNull(phrases, nameof(phrases));

            Label = label;
            Phrases = phrases.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="RecognitionChoice"/>. </summary>
        /// <param name="label"> Identifier for a given choice. </param>
        /// <param name="phrases"> List of phrases to recognize. </param>
        /// <param name="tone"></param>
        internal RecognitionChoice(string label, IList<string> phrases, DtmfTone? tone)
        {
            Label = label;
            Phrases = phrases;
            Tone = tone;
        }

        /// <summary> Identifier for a given choice. </summary>
        public string Label { get; set; }
        /// <summary> List of phrases to recognize. </summary>
        public IList<string> Phrases { get; }
        /// <summary> Gets or sets the tone. </summary>
        public DtmfTone? Tone { get; set; }
    }
}
