// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Communication.CallAutomation
{
    public partial class PowerVirtualAgentsDialog : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            writer.WritePropertyName("botAppId"u8);
            writer.WriteStringValue(BotAppId);
            if (Optional.IsDefined(Language))
            {
                writer.WritePropertyName("language"u8);
                writer.WriteStringValue(Language);
            }
            writer.WritePropertyName("kind"u8);
            writer.WriteStringValue(Kind.ToString());
            writer.WritePropertyName("context"u8);
            writer.WriteStartObject();
            foreach (var item in Context)
            {
                writer.WritePropertyName(item.Key);
                if (item.Value == null)
                {
                    writer.WriteNullValue();
                    continue;
                }
                writer.WriteObjectValue<object>(item.Value);
            }
            writer.WriteEndObject();
            writer.WriteEndObject();
        }

        internal static PowerVirtualAgentsDialog DeserializePowerVirtualAgentsDialog(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string botAppId = default;
            string language = default;
            DialogInputType kind = default;
            IDictionary<string, object> context = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("botAppId"u8))
                {
                    botAppId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("language"u8))
                {
                    language = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("kind"u8))
                {
                    kind = new DialogInputType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("context"u8))
                {
                    Dictionary<string, object> dictionary = new Dictionary<string, object>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.Value.ValueKind == JsonValueKind.Null)
                        {
                            dictionary.Add(property0.Name, null);
                        }
                        else
                        {
                            dictionary.Add(property0.Name, property0.Value.GetObject());
                        }
                    }
                    context = dictionary;
                    continue;
                }
            }
            return new PowerVirtualAgentsDialog(kind, context, botAppId, language);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static new PowerVirtualAgentsDialog FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializePowerVirtualAgentsDialog(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal override RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }
    }
}
