// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Communication.CallAutomation
{
    /// <summary> Defines the type of the play source. </summary>
    internal readonly partial struct PlaySourceTypeInternal : IEquatable<PlaySourceTypeInternal>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PlaySourceTypeInternal"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PlaySourceTypeInternal(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string FileValue = "file";
        private const string TextValue = "text";
        private const string SsmlValue = "ssml";

        /// <summary> file. </summary>
        public static PlaySourceTypeInternal File { get; } = new PlaySourceTypeInternal(FileValue);
        /// <summary> text. </summary>
        public static PlaySourceTypeInternal Text { get; } = new PlaySourceTypeInternal(TextValue);
        /// <summary> ssml. </summary>
        public static PlaySourceTypeInternal Ssml { get; } = new PlaySourceTypeInternal(SsmlValue);
        /// <summary> Determines if two <see cref="PlaySourceTypeInternal"/> values are the same. </summary>
        public static bool operator ==(PlaySourceTypeInternal left, PlaySourceTypeInternal right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PlaySourceTypeInternal"/> values are not the same. </summary>
        public static bool operator !=(PlaySourceTypeInternal left, PlaySourceTypeInternal right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PlaySourceTypeInternal"/>. </summary>
        public static implicit operator PlaySourceTypeInternal(string value) => new PlaySourceTypeInternal(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PlaySourceTypeInternal other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PlaySourceTypeInternal other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
