// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Communication.CallAutomation
{
    /// <summary> The MediaStreamingStatusDetails. </summary>
    public readonly partial struct MediaStreamingStatusDetails : IEquatable<MediaStreamingStatusDetails>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MediaStreamingStatusDetails"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MediaStreamingStatusDetails(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SubscriptionStartedValue = "subscriptionStarted";
        private const string StreamConnectionReestablishedValue = "streamConnectionReestablished";
        private const string StreamConnectionUnsuccessfulValue = "streamConnectionUnsuccessful";
        private const string StreamUrlMissingValue = "streamUrlMissing";
        private const string ServiceShutdownValue = "serviceShutdown";
        private const string StreamConnectionInterruptedValue = "streamConnectionInterrupted";
        private const string SpeechServicesConnectionErrorValue = "speechServicesConnectionError";
        private const string SubscriptionStoppedValue = "subscriptionStopped";
        private const string UnspecifiedErrorValue = "unspecifiedError";
        private const string AuthenticationFailureValue = "authenticationFailure";
        private const string BadRequestValue = "badRequest";
        private const string TooManyRequestsValue = "tooManyRequests";
        private const string ForbiddenValue = "forbidden";
        private const string ServiceTimeoutValue = "serviceTimeout";
        private const string InitialWebSocketConnectionFailedValue = "initialWebSocketConnectionFailed";

        /// <summary> subscriptionStarted. </summary>
        public static MediaStreamingStatusDetails SubscriptionStarted { get; } = new MediaStreamingStatusDetails(SubscriptionStartedValue);
        /// <summary> streamConnectionReestablished. </summary>
        public static MediaStreamingStatusDetails StreamConnectionReestablished { get; } = new MediaStreamingStatusDetails(StreamConnectionReestablishedValue);
        /// <summary> streamConnectionUnsuccessful. </summary>
        public static MediaStreamingStatusDetails StreamConnectionUnsuccessful { get; } = new MediaStreamingStatusDetails(StreamConnectionUnsuccessfulValue);
        /// <summary> streamUrlMissing. </summary>
        public static MediaStreamingStatusDetails StreamUrlMissing { get; } = new MediaStreamingStatusDetails(StreamUrlMissingValue);
        /// <summary> serviceShutdown. </summary>
        public static MediaStreamingStatusDetails ServiceShutdown { get; } = new MediaStreamingStatusDetails(ServiceShutdownValue);
        /// <summary> streamConnectionInterrupted. </summary>
        public static MediaStreamingStatusDetails StreamConnectionInterrupted { get; } = new MediaStreamingStatusDetails(StreamConnectionInterruptedValue);
        /// <summary> speechServicesConnectionError. </summary>
        public static MediaStreamingStatusDetails SpeechServicesConnectionError { get; } = new MediaStreamingStatusDetails(SpeechServicesConnectionErrorValue);
        /// <summary> subscriptionStopped. </summary>
        public static MediaStreamingStatusDetails SubscriptionStopped { get; } = new MediaStreamingStatusDetails(SubscriptionStoppedValue);
        /// <summary> unspecifiedError. </summary>
        public static MediaStreamingStatusDetails UnspecifiedError { get; } = new MediaStreamingStatusDetails(UnspecifiedErrorValue);
        /// <summary> authenticationFailure. </summary>
        public static MediaStreamingStatusDetails AuthenticationFailure { get; } = new MediaStreamingStatusDetails(AuthenticationFailureValue);
        /// <summary> badRequest. </summary>
        public static MediaStreamingStatusDetails BadRequest { get; } = new MediaStreamingStatusDetails(BadRequestValue);
        /// <summary> tooManyRequests. </summary>
        public static MediaStreamingStatusDetails TooManyRequests { get; } = new MediaStreamingStatusDetails(TooManyRequestsValue);
        /// <summary> forbidden. </summary>
        public static MediaStreamingStatusDetails Forbidden { get; } = new MediaStreamingStatusDetails(ForbiddenValue);
        /// <summary> serviceTimeout. </summary>
        public static MediaStreamingStatusDetails ServiceTimeout { get; } = new MediaStreamingStatusDetails(ServiceTimeoutValue);
        /// <summary> initialWebSocketConnectionFailed. </summary>
        public static MediaStreamingStatusDetails InitialWebSocketConnectionFailed { get; } = new MediaStreamingStatusDetails(InitialWebSocketConnectionFailedValue);
        /// <summary> Determines if two <see cref="MediaStreamingStatusDetails"/> values are the same. </summary>
        public static bool operator ==(MediaStreamingStatusDetails left, MediaStreamingStatusDetails right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MediaStreamingStatusDetails"/> values are not the same. </summary>
        public static bool operator !=(MediaStreamingStatusDetails left, MediaStreamingStatusDetails right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MediaStreamingStatusDetails"/>. </summary>
        public static implicit operator MediaStreamingStatusDetails(string value) => new MediaStreamingStatusDetails(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MediaStreamingStatusDetails other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MediaStreamingStatusDetails other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
