// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Communication.CallAutomation
{
    /// <summary> The MediaStreamingStatus. </summary>
    public readonly partial struct MediaStreamingStatus : IEquatable<MediaStreamingStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MediaStreamingStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MediaStreamingStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MediaStreamingStartedValue = "mediaStreamingStarted";
        private const string MediaStreamingFailedValue = "mediaStreamingFailed";
        private const string MediaStreamingStoppedValue = "mediaStreamingStopped";
        private const string UnspecifiedErrorValue = "unspecifiedError";

        /// <summary> mediaStreamingStarted. </summary>
        public static MediaStreamingStatus MediaStreamingStarted { get; } = new MediaStreamingStatus(MediaStreamingStartedValue);
        /// <summary> mediaStreamingFailed. </summary>
        public static MediaStreamingStatus MediaStreamingFailed { get; } = new MediaStreamingStatus(MediaStreamingFailedValue);
        /// <summary> mediaStreamingStopped. </summary>
        public static MediaStreamingStatus MediaStreamingStopped { get; } = new MediaStreamingStatus(MediaStreamingStoppedValue);
        /// <summary> unspecifiedError. </summary>
        public static MediaStreamingStatus UnspecifiedError { get; } = new MediaStreamingStatus(UnspecifiedErrorValue);
        /// <summary> Determines if two <see cref="MediaStreamingStatus"/> values are the same. </summary>
        public static bool operator ==(MediaStreamingStatus left, MediaStreamingStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MediaStreamingStatus"/> values are not the same. </summary>
        public static bool operator !=(MediaStreamingStatus left, MediaStreamingStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MediaStreamingStatus"/>. </summary>
        public static implicit operator MediaStreamingStatus(string value) => new MediaStreamingStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MediaStreamingStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MediaStreamingStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
