// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.Communication.CallAutomation
{
    /// <summary> The response payload for getting participants of the call. </summary>
    internal partial class GetParticipantsResponseInternal
    {
        /// <summary> Initializes a new instance of <see cref="GetParticipantsResponseInternal"/>. </summary>
        /// <param name="value"> List of the current participants in the call. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        internal GetParticipantsResponseInternal(IEnumerable<CallParticipantInternal> value)
        {
            Argument.AssertNotNull(value, nameof(value));

            Value = value.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="GetParticipantsResponseInternal"/>. </summary>
        /// <param name="value"> List of the current participants in the call. </param>
        /// <param name="nextLink"> Continue of the list of participants. </param>
        internal GetParticipantsResponseInternal(IReadOnlyList<CallParticipantInternal> value, string nextLink)
        {
            Value = value;
            NextLink = nextLink;
        }

        /// <summary> List of the current participants in the call. </summary>
        public IReadOnlyList<CallParticipantInternal> Value { get; }
        /// <summary> Continue of the list of participants. </summary>
        public string NextLink { get; }
    }
}
