// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;

namespace Azure.Communication.CallAutomation
{
    /// <summary>
    /// The DialogUpdateBase.
    /// Please note <see cref="DialogUpdateBase"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
    /// The available derived classes include <see cref="AzureOpenAIDialogUpdate"/>.
    /// </summary>
    public abstract partial class DialogUpdateBase
    {
        /// <summary> Initializes a new instance of <see cref="DialogUpdateBase"/>. </summary>
        protected DialogUpdateBase()
        {
            Context = new ChangeTrackingDictionary<string, object>();
        }

        /// <summary> Initializes a new instance of <see cref="DialogUpdateBase"/>. </summary>
        /// <param name="kind"> Determines the type of the dialog. </param>
        /// <param name="context"> Dialog context. </param>
        internal DialogUpdateBase(DialogInputType kind, IDictionary<string, object> context)
        {
            Kind = kind;
            Context = context;
        }
    }
}
