// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.Communication.CallAutomation
{
    /// <summary> The ContinuousDtmfRecognitionToneReceived. </summary>
    public partial class ContinuousDtmfRecognitionToneReceived
    {
        /// <summary> Initializes a new instance of <see cref="ContinuousDtmfRecognitionToneReceived"/>. </summary>
        internal ContinuousDtmfRecognitionToneReceived()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ContinuousDtmfRecognitionToneReceived"/>. </summary>
        /// <param name="resultInformation"> Result information defines the code, subcode and message. </param>
        /// <param name="sequenceId"> The sequence id which can be used to determine if the same tone was played multiple times or if any tones were missed. </param>
        /// <param name="tone"></param>
        /// <param name="operationContext"></param>
        /// <param name="callConnectionId"> Call connection ID. </param>
        /// <param name="serverCallId"> Server call ID. </param>
        /// <param name="correlationId"> Correlation ID for event to call correlation. Also called ChainId for skype chain ID. </param>
        internal ContinuousDtmfRecognitionToneReceived(ResultInformation resultInformation, int? sequenceId, DtmfTone? tone, string operationContext, string callConnectionId, string serverCallId, string correlationId)
        {
            ResultInformation = resultInformation;
            SequenceId = sequenceId;
            Tone = tone;
            OperationContext = operationContext;
            CallConnectionId = callConnectionId;
            ServerCallId = serverCallId;
            CorrelationId = correlationId;
        }
        /// <summary> The sequence id which can be used to determine if the same tone was played multiple times or if any tones were missed. </summary>
        public int? SequenceId { get; }
        /// <summary> Gets the tone. </summary>
        public DtmfTone? Tone { get; }
    }
}
