// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.Communication.CallAutomation
{
    /// <summary> The ChoiceResult. </summary>
    public partial class ChoiceResult
    {
        /// <summary> Initializes a new instance of <see cref="ChoiceResult"/>. </summary>
        internal ChoiceResult()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ChoiceResult"/>. </summary>
        /// <param name="label"> Label is the primary identifier for the choice detected. </param>
        /// <param name="recognizedPhrase">
        /// Phrases are set to the value if choice is selected via phrase detection.
        /// If Dtmf input is recognized, then Label will be the identifier for the choice detected and phrases will be set to null
        /// </param>
        internal ChoiceResult(string label, string recognizedPhrase)
        {
            Label = label;
            RecognizedPhrase = recognizedPhrase;
        }

        /// <summary> Label is the primary identifier for the choice detected. </summary>
        public string Label { get; }
        /// <summary>
        /// Phrases are set to the value if choice is selected via phrase detection.
        /// If Dtmf input is recognized, then Label will be the identifier for the choice detected and phrases will be set to null
        /// </summary>
        public string RecognizedPhrase { get; }
    }
}
