// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.Communication.CallAutomation
{
    public partial class ChoiceResult
    {
        internal static ChoiceResult DeserializeChoiceResult(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string label = default;
            string recognizedPhrase = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("label"u8))
                {
                    label = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("recognizedPhrase"u8))
                {
                    recognizedPhrase = property.Value.GetString();
                    continue;
                }
            }
            return new ChoiceResult(label, recognizedPhrase);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static ChoiceResult FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeChoiceResult(document.RootElement);
        }
    }
}
