// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Communication.CallAutomation
{
    /// <summary> Request payload for cancelling add participant request. </summary>
    internal partial class CancelAddParticipantRequestInternal
    {
        /// <summary> Initializes a new instance of <see cref="CancelAddParticipantRequestInternal"/>. </summary>
        /// <param name="invitationId"> Invitation ID used to add a participant. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="invitationId"/> is null. </exception>
        public CancelAddParticipantRequestInternal(string invitationId)
        {
            Argument.AssertNotNull(invitationId, nameof(invitationId));

            InvitationId = invitationId;
        }

        /// <summary> Initializes a new instance of <see cref="CancelAddParticipantRequestInternal"/>. </summary>
        /// <param name="invitationId"> Invitation ID used to add a participant. </param>
        /// <param name="operationContext"> Used by customers when calling mid-call actions to correlate the request to the response event. </param>
        /// <param name="operationCallbackUri">
        /// Set a callback URI that overrides the default callback URI set by CreateCall/AnswerCall for this operation.
        /// This setup is per-action. If this is not set, the default callback URI set by CreateCall/AnswerCall will be used.
        /// </param>
        internal CancelAddParticipantRequestInternal(string invitationId, string operationContext, string operationCallbackUri)
        {
            InvitationId = invitationId;
            OperationContext = operationContext;
            OperationCallbackUri = operationCallbackUri;
        }

        /// <summary> Invitation ID used to add a participant. </summary>
        public string InvitationId { get; }
        /// <summary> Used by customers when calling mid-call actions to correlate the request to the response event. </summary>
        public string OperationContext { get; set; }
        /// <summary>
        /// Set a callback URI that overrides the default callback URI set by CreateCall/AnswerCall for this operation.
        /// This setup is per-action. If this is not set, the default callback URI set by CreateCall/AnswerCall will be used.
        /// </summary>
        public string OperationCallbackUri { get; set; }
    }
}
