// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Communication.CallAutomation
{
    /// <summary> The rejection reason. </summary>
    public readonly partial struct CallRejectReason : IEquatable<CallRejectReason>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CallRejectReason"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CallRejectReason(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "none";
        private const string BusyValue = "busy";
        private const string ForbiddenValue = "forbidden";

        /// <summary> none. </summary>
        public static CallRejectReason None { get; } = new CallRejectReason(NoneValue);
        /// <summary> busy. </summary>
        public static CallRejectReason Busy { get; } = new CallRejectReason(BusyValue);
        /// <summary> forbidden. </summary>
        public static CallRejectReason Forbidden { get; } = new CallRejectReason(ForbiddenValue);
        /// <summary> Determines if two <see cref="CallRejectReason"/> values are the same. </summary>
        public static bool operator ==(CallRejectReason left, CallRejectReason right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CallRejectReason"/> values are not the same. </summary>
        public static bool operator !=(CallRejectReason left, CallRejectReason right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CallRejectReason"/>. </summary>
        public static implicit operator CallRejectReason(string value) => new CallRejectReason(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CallRejectReason other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CallRejectReason other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
