// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Communication.CallAutomation
{
    /// <summary>
    /// Determines the sub-type of the recognize operation.
    /// In case of cancel operation the this field is not set and is returned empty
    /// </summary>
    public readonly partial struct CallMediaRecognitionType : IEquatable<CallMediaRecognitionType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CallMediaRecognitionType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CallMediaRecognitionType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DtmfValue = "dtmf";
        private const string SpeechValue = "speech";
        private const string ChoicesValue = "choices";

        /// <summary> dtmf. </summary>
        public static CallMediaRecognitionType Dtmf { get; } = new CallMediaRecognitionType(DtmfValue);
        /// <summary> speech. </summary>
        public static CallMediaRecognitionType Speech { get; } = new CallMediaRecognitionType(SpeechValue);
        /// <summary> choices. </summary>
        public static CallMediaRecognitionType Choices { get; } = new CallMediaRecognitionType(ChoicesValue);
        /// <summary> Determines if two <see cref="CallMediaRecognitionType"/> values are the same. </summary>
        public static bool operator ==(CallMediaRecognitionType left, CallMediaRecognitionType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CallMediaRecognitionType"/> values are not the same. </summary>
        public static bool operator !=(CallMediaRecognitionType left, CallMediaRecognitionType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CallMediaRecognitionType"/>. </summary>
        public static implicit operator CallMediaRecognitionType(string value) => new CallMediaRecognitionType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CallMediaRecognitionType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CallMediaRecognitionType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
