// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.Communication.CallAutomation
{
    /// <summary> The call disconnected event. </summary>
    public partial class CallDisconnected
    {
        /// <summary> Initializes a new instance of <see cref="CallDisconnected"/>. </summary>
        internal CallDisconnected()
        {
        }

        /// <summary> Initializes a new instance of <see cref="CallDisconnected"/>. </summary>
        /// <param name="operationContext"> Used by customers when calling mid-call actions to correlate the request to the response event. </param>
        /// <param name="callConnectionId"> Call connection ID. </param>
        /// <param name="serverCallId"> Server call ID. </param>
        /// <param name="correlationId"> Correlation ID for event to call correlation. Also called ChainId for skype chain ID. </param>
        internal CallDisconnected(string operationContext, string callConnectionId, string serverCallId, string correlationId)
        {
            OperationContext = operationContext;
            CallConnectionId = callConnectionId;
            ServerCallId = serverCallId;
            CorrelationId = correlationId;
        }
    }
}
