// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Communication.CallAutomation
{
    /// <summary> The state of the call connection. </summary>
    public readonly partial struct CallConnectionState : IEquatable<CallConnectionState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CallConnectionState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CallConnectionState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "unknown";
        private const string ConnectingValue = "connecting";
        private const string ConnectedValue = "connected";
        private const string TransferringValue = "transferring";
        private const string TransferAcceptedValue = "transferAccepted";
        private const string DisconnectingValue = "disconnecting";
        private const string DisconnectedValue = "disconnected";

        /// <summary> unknown. </summary>
        public static CallConnectionState Unknown { get; } = new CallConnectionState(UnknownValue);
        /// <summary> connecting. </summary>
        public static CallConnectionState Connecting { get; } = new CallConnectionState(ConnectingValue);
        /// <summary> connected. </summary>
        public static CallConnectionState Connected { get; } = new CallConnectionState(ConnectedValue);
        /// <summary> transferring. </summary>
        public static CallConnectionState Transferring { get; } = new CallConnectionState(TransferringValue);
        /// <summary> transferAccepted. </summary>
        public static CallConnectionState TransferAccepted { get; } = new CallConnectionState(TransferAcceptedValue);
        /// <summary> disconnecting. </summary>
        public static CallConnectionState Disconnecting { get; } = new CallConnectionState(DisconnectingValue);
        /// <summary> disconnected. </summary>
        public static CallConnectionState Disconnected { get; } = new CallConnectionState(DisconnectedValue);
        /// <summary> Determines if two <see cref="CallConnectionState"/> values are the same. </summary>
        public static bool operator ==(CallConnectionState left, CallConnectionState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CallConnectionState"/> values are not the same. </summary>
        public static bool operator !=(CallConnectionState left, CallConnectionState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CallConnectionState"/>. </summary>
        public static implicit operator CallConnectionState(string value) => new CallConnectionState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CallConnectionState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CallConnectionState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
