// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Communication.CallAutomation
{
    /// <summary>
    /// The BaseDialog.
    /// Please note <see cref="BaseDialog"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
    /// The available derived classes include <see cref="AzureOpenAIDialog"/> and <see cref="PowerVirtualAgentsDialog"/>.
    /// </summary>
    public abstract partial class BaseDialog
    {
        /// <summary> Initializes a new instance of <see cref="BaseDialog"/>. </summary>
        /// <param name="context"> Dialog context. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="context"/> is null. </exception>
        protected BaseDialog(IDictionary<string, object> context)
        {
            Argument.AssertNotNull(context, nameof(context));

            Context = context;
        }

        /// <summary> Initializes a new instance of <see cref="BaseDialog"/>. </summary>
        /// <param name="kind"> Determines the type of the dialog. </param>
        /// <param name="context"> Dialog context. </param>
        internal BaseDialog(DialogInputType kind, IDictionary<string, object> context)
        {
            Kind = kind;
            Context = context;
        }
    }
}
