// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.Communication.CallAutomation
{
    internal partial class CallMediaRestClient
    {
        private readonly HttpPipeline _pipeline;
        private readonly Uri _endpoint;
        private readonly string _apiVersion;

        /// <summary> The ClientDiagnostics is used to provide tracing support for the client library. </summary>
        internal ClientDiagnostics ClientDiagnostics { get; }

        /// <summary> Initializes a new instance of CallMediaRestClient. </summary>
        /// <param name="clientDiagnostics"> The handler for diagnostic messaging in the client. </param>
        /// <param name="pipeline"> The HTTP pipeline for sending and receiving REST requests and responses. </param>
        /// <param name="endpoint"> The endpoint of the Azure Communication resource. </param>
        /// <param name="apiVersion"> Api Version. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="clientDiagnostics"/>, <paramref name="pipeline"/>, <paramref name="endpoint"/> or <paramref name="apiVersion"/> is null. </exception>
        public CallMediaRestClient(ClientDiagnostics clientDiagnostics, HttpPipeline pipeline, Uri endpoint, string apiVersion = "2023-10-03-preview")
        {
            ClientDiagnostics = clientDiagnostics ?? throw new ArgumentNullException(nameof(clientDiagnostics));
            _pipeline = pipeline ?? throw new ArgumentNullException(nameof(pipeline));
            _endpoint = endpoint ?? throw new ArgumentNullException(nameof(endpoint));
            _apiVersion = apiVersion ?? throw new ArgumentNullException(nameof(apiVersion));
        }

        internal HttpMessage CreatePlayRequest(string callConnectionId, PlayRequestInternal playRequestInternal)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/calling/callConnections/", false);
            uri.AppendPath(callConnectionId, true);
            uri.AppendPath(":play", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(playRequestInternal);
            request.Content = content;
            return message;
        }

        /// <summary> Plays audio to participants in the call. </summary>
        /// <param name="callConnectionId"> The call connection id. </param>
        /// <param name="playRequestInternal"> play request payload. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="callConnectionId"/> or <paramref name="playRequestInternal"/> is null. </exception>
        public async Task<Response> PlayAsync(string callConnectionId, PlayRequestInternal playRequestInternal, CancellationToken cancellationToken = default)
        {
            if (callConnectionId == null)
            {
                throw new ArgumentNullException(nameof(callConnectionId));
            }
            if (playRequestInternal == null)
            {
                throw new ArgumentNullException(nameof(playRequestInternal));
            }

            using var message = CreatePlayRequest(callConnectionId, playRequestInternal);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 202:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Plays audio to participants in the call. </summary>
        /// <param name="callConnectionId"> The call connection id. </param>
        /// <param name="playRequestInternal"> play request payload. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="callConnectionId"/> or <paramref name="playRequestInternal"/> is null. </exception>
        public Response Play(string callConnectionId, PlayRequestInternal playRequestInternal, CancellationToken cancellationToken = default)
        {
            if (callConnectionId == null)
            {
                throw new ArgumentNullException(nameof(callConnectionId));
            }
            if (playRequestInternal == null)
            {
                throw new ArgumentNullException(nameof(playRequestInternal));
            }

            using var message = CreatePlayRequest(callConnectionId, playRequestInternal);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 202:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateStartTranscriptionRequest(string callConnectionId, StartTranscriptionRequestInternal startTranscriptionRequestInternal)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/calling/callConnections/", false);
            uri.AppendPath(callConnectionId, true);
            uri.AppendPath(":startTranscription", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(startTranscriptionRequestInternal);
            request.Content = content;
            return message;
        }

        /// <summary> Starts transcription in the call. </summary>
        /// <param name="callConnectionId"> The call connection id. </param>
        /// <param name="startTranscriptionRequestInternal"> The <see cref="StartTranscriptionRequestInternal"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="callConnectionId"/> or <paramref name="startTranscriptionRequestInternal"/> is null. </exception>
        public async Task<Response> StartTranscriptionAsync(string callConnectionId, StartTranscriptionRequestInternal startTranscriptionRequestInternal, CancellationToken cancellationToken = default)
        {
            if (callConnectionId == null)
            {
                throw new ArgumentNullException(nameof(callConnectionId));
            }
            if (startTranscriptionRequestInternal == null)
            {
                throw new ArgumentNullException(nameof(startTranscriptionRequestInternal));
            }

            using var message = CreateStartTranscriptionRequest(callConnectionId, startTranscriptionRequestInternal);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 202:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Starts transcription in the call. </summary>
        /// <param name="callConnectionId"> The call connection id. </param>
        /// <param name="startTranscriptionRequestInternal"> The <see cref="StartTranscriptionRequestInternal"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="callConnectionId"/> or <paramref name="startTranscriptionRequestInternal"/> is null. </exception>
        public Response StartTranscription(string callConnectionId, StartTranscriptionRequestInternal startTranscriptionRequestInternal, CancellationToken cancellationToken = default)
        {
            if (callConnectionId == null)
            {
                throw new ArgumentNullException(nameof(callConnectionId));
            }
            if (startTranscriptionRequestInternal == null)
            {
                throw new ArgumentNullException(nameof(startTranscriptionRequestInternal));
            }

            using var message = CreateStartTranscriptionRequest(callConnectionId, startTranscriptionRequestInternal);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 202:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateStopTranscriptionRequest(string callConnectionId, StopTranscriptionRequestInternal stopTranscriptionRequestInternal)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/calling/callConnections/", false);
            uri.AppendPath(callConnectionId, true);
            uri.AppendPath(":stopTranscription", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(stopTranscriptionRequestInternal);
            request.Content = content;
            return message;
        }

        /// <summary> Stops transcription in the call. </summary>
        /// <param name="callConnectionId"> The call connection id. </param>
        /// <param name="stopTranscriptionRequestInternal"> stop transcription request payload. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="callConnectionId"/> or <paramref name="stopTranscriptionRequestInternal"/> is null. </exception>
        public async Task<Response> StopTranscriptionAsync(string callConnectionId, StopTranscriptionRequestInternal stopTranscriptionRequestInternal, CancellationToken cancellationToken = default)
        {
            if (callConnectionId == null)
            {
                throw new ArgumentNullException(nameof(callConnectionId));
            }
            if (stopTranscriptionRequestInternal == null)
            {
                throw new ArgumentNullException(nameof(stopTranscriptionRequestInternal));
            }

            using var message = CreateStopTranscriptionRequest(callConnectionId, stopTranscriptionRequestInternal);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 202:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Stops transcription in the call. </summary>
        /// <param name="callConnectionId"> The call connection id. </param>
        /// <param name="stopTranscriptionRequestInternal"> stop transcription request payload. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="callConnectionId"/> or <paramref name="stopTranscriptionRequestInternal"/> is null. </exception>
        public Response StopTranscription(string callConnectionId, StopTranscriptionRequestInternal stopTranscriptionRequestInternal, CancellationToken cancellationToken = default)
        {
            if (callConnectionId == null)
            {
                throw new ArgumentNullException(nameof(callConnectionId));
            }
            if (stopTranscriptionRequestInternal == null)
            {
                throw new ArgumentNullException(nameof(stopTranscriptionRequestInternal));
            }

            using var message = CreateStopTranscriptionRequest(callConnectionId, stopTranscriptionRequestInternal);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 202:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateCancelAllMediaOperationsRequest(string callConnectionId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/calling/callConnections/", false);
            uri.AppendPath(callConnectionId, true);
            uri.AppendPath(":cancelAllMediaOperations", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Cancel all media operations in a call. </summary>
        /// <param name="callConnectionId"> The call connection id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="callConnectionId"/> is null. </exception>
        public async Task<Response> CancelAllMediaOperationsAsync(string callConnectionId, CancellationToken cancellationToken = default)
        {
            if (callConnectionId == null)
            {
                throw new ArgumentNullException(nameof(callConnectionId));
            }

            using var message = CreateCancelAllMediaOperationsRequest(callConnectionId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 202:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Cancel all media operations in a call. </summary>
        /// <param name="callConnectionId"> The call connection id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="callConnectionId"/> is null. </exception>
        public Response CancelAllMediaOperations(string callConnectionId, CancellationToken cancellationToken = default)
        {
            if (callConnectionId == null)
            {
                throw new ArgumentNullException(nameof(callConnectionId));
            }

            using var message = CreateCancelAllMediaOperationsRequest(callConnectionId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 202:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateRecognizeRequest(string callConnectionId, RecognizeRequestInternal recognizeRequestInternal)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/calling/callConnections/", false);
            uri.AppendPath(callConnectionId, true);
            uri.AppendPath(":recognize", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(recognizeRequestInternal);
            request.Content = content;
            return message;
        }

        /// <summary> Recognize media from call. </summary>
        /// <param name="callConnectionId"> The call connection id. </param>
        /// <param name="recognizeRequestInternal"> The media recognize request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="callConnectionId"/> or <paramref name="recognizeRequestInternal"/> is null. </exception>
        public async Task<Response> RecognizeAsync(string callConnectionId, RecognizeRequestInternal recognizeRequestInternal, CancellationToken cancellationToken = default)
        {
            if (callConnectionId == null)
            {
                throw new ArgumentNullException(nameof(callConnectionId));
            }
            if (recognizeRequestInternal == null)
            {
                throw new ArgumentNullException(nameof(recognizeRequestInternal));
            }

            using var message = CreateRecognizeRequest(callConnectionId, recognizeRequestInternal);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 202:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Recognize media from call. </summary>
        /// <param name="callConnectionId"> The call connection id. </param>
        /// <param name="recognizeRequestInternal"> The media recognize request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="callConnectionId"/> or <paramref name="recognizeRequestInternal"/> is null. </exception>
        public Response Recognize(string callConnectionId, RecognizeRequestInternal recognizeRequestInternal, CancellationToken cancellationToken = default)
        {
            if (callConnectionId == null)
            {
                throw new ArgumentNullException(nameof(callConnectionId));
            }
            if (recognizeRequestInternal == null)
            {
                throw new ArgumentNullException(nameof(recognizeRequestInternal));
            }

            using var message = CreateRecognizeRequest(callConnectionId, recognizeRequestInternal);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 202:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateStartContinuousDtmfRecognitionRequest(string callConnectionId, ContinuousDtmfRecognitionRequestInternal continuousDtmfRecognitionRequestInternal)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/calling/callConnections/", false);
            uri.AppendPath(callConnectionId, true);
            uri.AppendPath(":startContinuousDtmfRecognition", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(continuousDtmfRecognitionRequestInternal);
            request.Content = content;
            return message;
        }

        /// <summary> Start continuous Dtmf recognition by subscribing to tones. </summary>
        /// <param name="callConnectionId"> The call connection id. </param>
        /// <param name="continuousDtmfRecognitionRequestInternal"> The continuous recognize request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="callConnectionId"/> or <paramref name="continuousDtmfRecognitionRequestInternal"/> is null. </exception>
        public async Task<Response> StartContinuousDtmfRecognitionAsync(string callConnectionId, ContinuousDtmfRecognitionRequestInternal continuousDtmfRecognitionRequestInternal, CancellationToken cancellationToken = default)
        {
            if (callConnectionId == null)
            {
                throw new ArgumentNullException(nameof(callConnectionId));
            }
            if (continuousDtmfRecognitionRequestInternal == null)
            {
                throw new ArgumentNullException(nameof(continuousDtmfRecognitionRequestInternal));
            }

            using var message = CreateStartContinuousDtmfRecognitionRequest(callConnectionId, continuousDtmfRecognitionRequestInternal);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Start continuous Dtmf recognition by subscribing to tones. </summary>
        /// <param name="callConnectionId"> The call connection id. </param>
        /// <param name="continuousDtmfRecognitionRequestInternal"> The continuous recognize request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="callConnectionId"/> or <paramref name="continuousDtmfRecognitionRequestInternal"/> is null. </exception>
        public Response StartContinuousDtmfRecognition(string callConnectionId, ContinuousDtmfRecognitionRequestInternal continuousDtmfRecognitionRequestInternal, CancellationToken cancellationToken = default)
        {
            if (callConnectionId == null)
            {
                throw new ArgumentNullException(nameof(callConnectionId));
            }
            if (continuousDtmfRecognitionRequestInternal == null)
            {
                throw new ArgumentNullException(nameof(continuousDtmfRecognitionRequestInternal));
            }

            using var message = CreateStartContinuousDtmfRecognitionRequest(callConnectionId, continuousDtmfRecognitionRequestInternal);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateStopContinuousDtmfRecognitionRequest(string callConnectionId, ContinuousDtmfRecognitionRequestInternal continuousDtmfRecognitionRequestInternal)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/calling/callConnections/", false);
            uri.AppendPath(callConnectionId, true);
            uri.AppendPath(":stopContinuousDtmfRecognition", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(continuousDtmfRecognitionRequestInternal);
            request.Content = content;
            return message;
        }

        /// <summary> Stop continuous Dtmf recognition by unsubscribing to tones. </summary>
        /// <param name="callConnectionId"> The call connection id. </param>
        /// <param name="continuousDtmfRecognitionRequestInternal"> The continuous recognize request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="callConnectionId"/> or <paramref name="continuousDtmfRecognitionRequestInternal"/> is null. </exception>
        public async Task<Response> StopContinuousDtmfRecognitionAsync(string callConnectionId, ContinuousDtmfRecognitionRequestInternal continuousDtmfRecognitionRequestInternal, CancellationToken cancellationToken = default)
        {
            if (callConnectionId == null)
            {
                throw new ArgumentNullException(nameof(callConnectionId));
            }
            if (continuousDtmfRecognitionRequestInternal == null)
            {
                throw new ArgumentNullException(nameof(continuousDtmfRecognitionRequestInternal));
            }

            using var message = CreateStopContinuousDtmfRecognitionRequest(callConnectionId, continuousDtmfRecognitionRequestInternal);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Stop continuous Dtmf recognition by unsubscribing to tones. </summary>
        /// <param name="callConnectionId"> The call connection id. </param>
        /// <param name="continuousDtmfRecognitionRequestInternal"> The continuous recognize request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="callConnectionId"/> or <paramref name="continuousDtmfRecognitionRequestInternal"/> is null. </exception>
        public Response StopContinuousDtmfRecognition(string callConnectionId, ContinuousDtmfRecognitionRequestInternal continuousDtmfRecognitionRequestInternal, CancellationToken cancellationToken = default)
        {
            if (callConnectionId == null)
            {
                throw new ArgumentNullException(nameof(callConnectionId));
            }
            if (continuousDtmfRecognitionRequestInternal == null)
            {
                throw new ArgumentNullException(nameof(continuousDtmfRecognitionRequestInternal));
            }

            using var message = CreateStopContinuousDtmfRecognitionRequest(callConnectionId, continuousDtmfRecognitionRequestInternal);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateSendDtmfTonesRequest(string callConnectionId, SendDtmfTonesRequestInternal sendDtmfTonesRequestInternal)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/calling/callConnections/", false);
            uri.AppendPath(callConnectionId, true);
            uri.AppendPath(":sendDtmfTones", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Repeatability-Request-ID", Guid.NewGuid());
            request.Headers.Add("Repeatability-First-Sent", DateTimeOffset.Now, "R");
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(sendDtmfTonesRequestInternal);
            request.Content = content;
            return message;
        }

        /// <summary> Send dtmf tones. </summary>
        /// <param name="callConnectionId"> The call connection id. </param>
        /// <param name="sendDtmfTonesRequestInternal"> The send dtmf tones request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="callConnectionId"/> or <paramref name="sendDtmfTonesRequestInternal"/> is null. </exception>
        public async Task<Response<SendDtmfTonesResult>> SendDtmfTonesAsync(string callConnectionId, SendDtmfTonesRequestInternal sendDtmfTonesRequestInternal, CancellationToken cancellationToken = default)
        {
            if (callConnectionId == null)
            {
                throw new ArgumentNullException(nameof(callConnectionId));
            }
            if (sendDtmfTonesRequestInternal == null)
            {
                throw new ArgumentNullException(nameof(sendDtmfTonesRequestInternal));
            }

            using var message = CreateSendDtmfTonesRequest(callConnectionId, sendDtmfTonesRequestInternal);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 202:
                    {
                        SendDtmfTonesResult value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = SendDtmfTonesResult.DeserializeSendDtmfTonesResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Send dtmf tones. </summary>
        /// <param name="callConnectionId"> The call connection id. </param>
        /// <param name="sendDtmfTonesRequestInternal"> The send dtmf tones request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="callConnectionId"/> or <paramref name="sendDtmfTonesRequestInternal"/> is null. </exception>
        public Response<SendDtmfTonesResult> SendDtmfTones(string callConnectionId, SendDtmfTonesRequestInternal sendDtmfTonesRequestInternal, CancellationToken cancellationToken = default)
        {
            if (callConnectionId == null)
            {
                throw new ArgumentNullException(nameof(callConnectionId));
            }
            if (sendDtmfTonesRequestInternal == null)
            {
                throw new ArgumentNullException(nameof(sendDtmfTonesRequestInternal));
            }

            using var message = CreateSendDtmfTonesRequest(callConnectionId, sendDtmfTonesRequestInternal);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 202:
                    {
                        SendDtmfTonesResult value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = SendDtmfTonesResult.DeserializeSendDtmfTonesResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateUpdateTranscriptionRequest(string callConnectionId, UpdateTranscriptionRequestInternal updateTranscriptionRequestInternal)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/calling/callConnections/", false);
            uri.AppendPath(callConnectionId, true);
            uri.AppendPath(":updateTranscription", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(updateTranscriptionRequestInternal);
            request.Content = content;
            return message;
        }

        /// <summary> UpdateTranscription Api. </summary>
        /// <param name="callConnectionId"> The call connection id. </param>
        /// <param name="updateTranscriptionRequestInternal"> The UpdateTranscription request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="callConnectionId"/> or <paramref name="updateTranscriptionRequestInternal"/> is null. </exception>
        /// <remarks> API to change transcription language. </remarks>
        public async Task<Response> UpdateTranscriptionAsync(string callConnectionId, UpdateTranscriptionRequestInternal updateTranscriptionRequestInternal, CancellationToken cancellationToken = default)
        {
            if (callConnectionId == null)
            {
                throw new ArgumentNullException(nameof(callConnectionId));
            }
            if (updateTranscriptionRequestInternal == null)
            {
                throw new ArgumentNullException(nameof(updateTranscriptionRequestInternal));
            }

            using var message = CreateUpdateTranscriptionRequest(callConnectionId, updateTranscriptionRequestInternal);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 202:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> UpdateTranscription Api. </summary>
        /// <param name="callConnectionId"> The call connection id. </param>
        /// <param name="updateTranscriptionRequestInternal"> The UpdateTranscription request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="callConnectionId"/> or <paramref name="updateTranscriptionRequestInternal"/> is null. </exception>
        /// <remarks> API to change transcription language. </remarks>
        public Response UpdateTranscription(string callConnectionId, UpdateTranscriptionRequestInternal updateTranscriptionRequestInternal, CancellationToken cancellationToken = default)
        {
            if (callConnectionId == null)
            {
                throw new ArgumentNullException(nameof(callConnectionId));
            }
            if (updateTranscriptionRequestInternal == null)
            {
                throw new ArgumentNullException(nameof(updateTranscriptionRequestInternal));
            }

            using var message = CreateUpdateTranscriptionRequest(callConnectionId, updateTranscriptionRequestInternal);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 202:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateHoldRequest(string callConnectionId, HoldRequestInternal holdRequestInternal)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/calling/callConnections/", false);
            uri.AppendPath(callConnectionId, true);
            uri.AppendPath(":hold", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(holdRequestInternal);
            request.Content = content;
            return message;
        }

        /// <summary> Hold participant from the call using identifier. </summary>
        /// <param name="callConnectionId"> The call connection id. </param>
        /// <param name="holdRequestInternal"> The participants to be hold from the call. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="callConnectionId"/> or <paramref name="holdRequestInternal"/> is null. </exception>
        public async Task<Response> HoldAsync(string callConnectionId, HoldRequestInternal holdRequestInternal, CancellationToken cancellationToken = default)
        {
            if (callConnectionId == null)
            {
                throw new ArgumentNullException(nameof(callConnectionId));
            }
            if (holdRequestInternal == null)
            {
                throw new ArgumentNullException(nameof(holdRequestInternal));
            }

            using var message = CreateHoldRequest(callConnectionId, holdRequestInternal);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Hold participant from the call using identifier. </summary>
        /// <param name="callConnectionId"> The call connection id. </param>
        /// <param name="holdRequestInternal"> The participants to be hold from the call. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="callConnectionId"/> or <paramref name="holdRequestInternal"/> is null. </exception>
        public Response Hold(string callConnectionId, HoldRequestInternal holdRequestInternal, CancellationToken cancellationToken = default)
        {
            if (callConnectionId == null)
            {
                throw new ArgumentNullException(nameof(callConnectionId));
            }
            if (holdRequestInternal == null)
            {
                throw new ArgumentNullException(nameof(holdRequestInternal));
            }

            using var message = CreateHoldRequest(callConnectionId, holdRequestInternal);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateUnholdRequest(string callConnectionId, UnholdRequestInternal unholdRequestInternal)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/calling/callConnections/", false);
            uri.AppendPath(callConnectionId, true);
            uri.AppendPath(":unhold", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(unholdRequestInternal);
            request.Content = content;
            return message;
        }

        /// <summary> Unhold participants from the call using identifier. </summary>
        /// <param name="callConnectionId"> The call connection id. </param>
        /// <param name="unholdRequestInternal"> The participants to be hold from the call. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="callConnectionId"/> or <paramref name="unholdRequestInternal"/> is null. </exception>
        public async Task<Response> UnholdAsync(string callConnectionId, UnholdRequestInternal unholdRequestInternal, CancellationToken cancellationToken = default)
        {
            if (callConnectionId == null)
            {
                throw new ArgumentNullException(nameof(callConnectionId));
            }
            if (unholdRequestInternal == null)
            {
                throw new ArgumentNullException(nameof(unholdRequestInternal));
            }

            using var message = CreateUnholdRequest(callConnectionId, unholdRequestInternal);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Unhold participants from the call using identifier. </summary>
        /// <param name="callConnectionId"> The call connection id. </param>
        /// <param name="unholdRequestInternal"> The participants to be hold from the call. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="callConnectionId"/> or <paramref name="unholdRequestInternal"/> is null. </exception>
        public Response Unhold(string callConnectionId, UnholdRequestInternal unholdRequestInternal, CancellationToken cancellationToken = default)
        {
            if (callConnectionId == null)
            {
                throw new ArgumentNullException(nameof(callConnectionId));
            }
            if (unholdRequestInternal == null)
            {
                throw new ArgumentNullException(nameof(unholdRequestInternal));
            }

            using var message = CreateUnholdRequest(callConnectionId, unholdRequestInternal);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateStartHoldMusicRequest(string callConnectionId, StartHoldMusicRequestInternal startHoldMusicRequestInternal)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/calling/callConnections/", false);
            uri.AppendPath(callConnectionId, true);
            uri.AppendPath(":startHoldMusic", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(startHoldMusicRequestInternal);
            request.Content = content;
            return message;
        }

        /// <summary> Hold participant from the call using identifier. </summary>
        /// <param name="callConnectionId"> The call connection id. </param>
        /// <param name="startHoldMusicRequestInternal"> The participants to be hold from the call. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="callConnectionId"/> or <paramref name="startHoldMusicRequestInternal"/> is null. </exception>
        public async Task<Response> StartHoldMusicAsync(string callConnectionId, StartHoldMusicRequestInternal startHoldMusicRequestInternal, CancellationToken cancellationToken = default)
        {
            if (callConnectionId == null)
            {
                throw new ArgumentNullException(nameof(callConnectionId));
            }
            if (startHoldMusicRequestInternal == null)
            {
                throw new ArgumentNullException(nameof(startHoldMusicRequestInternal));
            }

            using var message = CreateStartHoldMusicRequest(callConnectionId, startHoldMusicRequestInternal);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Hold participant from the call using identifier. </summary>
        /// <param name="callConnectionId"> The call connection id. </param>
        /// <param name="startHoldMusicRequestInternal"> The participants to be hold from the call. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="callConnectionId"/> or <paramref name="startHoldMusicRequestInternal"/> is null. </exception>
        public Response StartHoldMusic(string callConnectionId, StartHoldMusicRequestInternal startHoldMusicRequestInternal, CancellationToken cancellationToken = default)
        {
            if (callConnectionId == null)
            {
                throw new ArgumentNullException(nameof(callConnectionId));
            }
            if (startHoldMusicRequestInternal == null)
            {
                throw new ArgumentNullException(nameof(startHoldMusicRequestInternal));
            }

            using var message = CreateStartHoldMusicRequest(callConnectionId, startHoldMusicRequestInternal);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateStopHoldMusicRequest(string callConnectionId, StopHoldMusicRequestInternal stopHoldMusicRequestInternal)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/calling/callConnections/", false);
            uri.AppendPath(callConnectionId, true);
            uri.AppendPath(":stopHoldMusic", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(stopHoldMusicRequestInternal);
            request.Content = content;
            return message;
        }

        /// <summary> Unhold participants from the call using identifier. </summary>
        /// <param name="callConnectionId"> The call connection id. </param>
        /// <param name="stopHoldMusicRequestInternal"> The participants to be hold from the call. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="callConnectionId"/> or <paramref name="stopHoldMusicRequestInternal"/> is null. </exception>
        public async Task<Response> StopHoldMusicAsync(string callConnectionId, StopHoldMusicRequestInternal stopHoldMusicRequestInternal, CancellationToken cancellationToken = default)
        {
            if (callConnectionId == null)
            {
                throw new ArgumentNullException(nameof(callConnectionId));
            }
            if (stopHoldMusicRequestInternal == null)
            {
                throw new ArgumentNullException(nameof(stopHoldMusicRequestInternal));
            }

            using var message = CreateStopHoldMusicRequest(callConnectionId, stopHoldMusicRequestInternal);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Unhold participants from the call using identifier. </summary>
        /// <param name="callConnectionId"> The call connection id. </param>
        /// <param name="stopHoldMusicRequestInternal"> The participants to be hold from the call. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="callConnectionId"/> or <paramref name="stopHoldMusicRequestInternal"/> is null. </exception>
        public Response StopHoldMusic(string callConnectionId, StopHoldMusicRequestInternal stopHoldMusicRequestInternal, CancellationToken cancellationToken = default)
        {
            if (callConnectionId == null)
            {
                throw new ArgumentNullException(nameof(callConnectionId));
            }
            if (stopHoldMusicRequestInternal == null)
            {
                throw new ArgumentNullException(nameof(stopHoldMusicRequestInternal));
            }

            using var message = CreateStopHoldMusicRequest(callConnectionId, stopHoldMusicRequestInternal);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateStartMediaStreamingRequest(string callConnectionId, StartMediaStreamingRequestInternal startMediaStreamingRequestInternal)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/calling/callConnections/", false);
            uri.AppendPath(callConnectionId, true);
            uri.AppendPath(":startMediaStreaming", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(startMediaStreamingRequestInternal);
            request.Content = content;
            return message;
        }

        /// <summary> Starts media streaming in the call. </summary>
        /// <param name="callConnectionId"> The call connection id. </param>
        /// <param name="startMediaStreamingRequestInternal"> The <see cref="StartMediaStreamingRequestInternal"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="callConnectionId"/> or <paramref name="startMediaStreamingRequestInternal"/> is null. </exception>
        /// <remarks> Starts media streaming in the call. </remarks>
        public async Task<Response> StartMediaStreamingAsync(string callConnectionId, StartMediaStreamingRequestInternal startMediaStreamingRequestInternal, CancellationToken cancellationToken = default)
        {
            if (callConnectionId == null)
            {
                throw new ArgumentNullException(nameof(callConnectionId));
            }
            if (startMediaStreamingRequestInternal == null)
            {
                throw new ArgumentNullException(nameof(startMediaStreamingRequestInternal));
            }

            using var message = CreateStartMediaStreamingRequest(callConnectionId, startMediaStreamingRequestInternal);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 202:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Starts media streaming in the call. </summary>
        /// <param name="callConnectionId"> The call connection id. </param>
        /// <param name="startMediaStreamingRequestInternal"> The <see cref="StartMediaStreamingRequestInternal"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="callConnectionId"/> or <paramref name="startMediaStreamingRequestInternal"/> is null. </exception>
        /// <remarks> Starts media streaming in the call. </remarks>
        public Response StartMediaStreaming(string callConnectionId, StartMediaStreamingRequestInternal startMediaStreamingRequestInternal, CancellationToken cancellationToken = default)
        {
            if (callConnectionId == null)
            {
                throw new ArgumentNullException(nameof(callConnectionId));
            }
            if (startMediaStreamingRequestInternal == null)
            {
                throw new ArgumentNullException(nameof(startMediaStreamingRequestInternal));
            }

            using var message = CreateStartMediaStreamingRequest(callConnectionId, startMediaStreamingRequestInternal);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 202:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateStopMediaStreamingRequest(string callConnectionId, StopMediaStreamingRequestInternal stopMediaStreamingRequestInternal)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/calling/callConnections/", false);
            uri.AppendPath(callConnectionId, true);
            uri.AppendPath(":stopMediaStreaming", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(stopMediaStreamingRequestInternal);
            request.Content = content;
            return message;
        }

        /// <summary> Stops media streaming in the call. </summary>
        /// <param name="callConnectionId"> The call connection id. </param>
        /// <param name="stopMediaStreamingRequestInternal"> stop media streaming request payload. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="callConnectionId"/> or <paramref name="stopMediaStreamingRequestInternal"/> is null. </exception>
        /// <remarks> Stops media streaming in the call. </remarks>
        public async Task<Response> StopMediaStreamingAsync(string callConnectionId, StopMediaStreamingRequestInternal stopMediaStreamingRequestInternal, CancellationToken cancellationToken = default)
        {
            if (callConnectionId == null)
            {
                throw new ArgumentNullException(nameof(callConnectionId));
            }
            if (stopMediaStreamingRequestInternal == null)
            {
                throw new ArgumentNullException(nameof(stopMediaStreamingRequestInternal));
            }

            using var message = CreateStopMediaStreamingRequest(callConnectionId, stopMediaStreamingRequestInternal);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 202:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Stops media streaming in the call. </summary>
        /// <param name="callConnectionId"> The call connection id. </param>
        /// <param name="stopMediaStreamingRequestInternal"> stop media streaming request payload. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="callConnectionId"/> or <paramref name="stopMediaStreamingRequestInternal"/> is null. </exception>
        /// <remarks> Stops media streaming in the call. </remarks>
        public Response StopMediaStreaming(string callConnectionId, StopMediaStreamingRequestInternal stopMediaStreamingRequestInternal, CancellationToken cancellationToken = default)
        {
            if (callConnectionId == null)
            {
                throw new ArgumentNullException(nameof(callConnectionId));
            }
            if (stopMediaStreamingRequestInternal == null)
            {
                throw new ArgumentNullException(nameof(stopMediaStreamingRequestInternal));
            }

            using var message = CreateStopMediaStreamingRequest(callConnectionId, stopMediaStreamingRequestInternal);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 202:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }
    }
}
