// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.Communication.CallAutomation
{
    internal partial class CallDialogRestClient
    {
        private readonly HttpPipeline _pipeline;
        private readonly Uri _endpoint;
        private readonly string _apiVersion;

        /// <summary> The ClientDiagnostics is used to provide tracing support for the client library. </summary>
        internal ClientDiagnostics ClientDiagnostics { get; }

        /// <summary> Initializes a new instance of CallDialogRestClient. </summary>
        /// <param name="clientDiagnostics"> The handler for diagnostic messaging in the client. </param>
        /// <param name="pipeline"> The HTTP pipeline for sending and receiving REST requests and responses. </param>
        /// <param name="endpoint"> The endpoint of the Azure Communication resource. </param>
        /// <param name="apiVersion"> Api Version. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="clientDiagnostics"/>, <paramref name="pipeline"/>, <paramref name="endpoint"/> or <paramref name="apiVersion"/> is null. </exception>
        public CallDialogRestClient(ClientDiagnostics clientDiagnostics, HttpPipeline pipeline, Uri endpoint, string apiVersion = "2023-10-03-preview")
        {
            ClientDiagnostics = clientDiagnostics ?? throw new ArgumentNullException(nameof(clientDiagnostics));
            _pipeline = pipeline ?? throw new ArgumentNullException(nameof(pipeline));
            _endpoint = endpoint ?? throw new ArgumentNullException(nameof(endpoint));
            _apiVersion = apiVersion ?? throw new ArgumentNullException(nameof(apiVersion));
        }

        internal HttpMessage CreateStartDialogRequest(string callConnectionId, string dialogId, StartDialogRequestInternal startDialogRequestInternal)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Put;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/calling/callConnections/", false);
            uri.AppendPath(callConnectionId, true);
            uri.AppendPath("/dialogs/", false);
            uri.AppendPath(dialogId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(startDialogRequestInternal);
            request.Content = content;
            return message;
        }

        /// <summary> Start a dialog targeting a particular participant on the call. </summary>
        /// <param name="callConnectionId"> The call connection id. </param>
        /// <param name="dialogId"> The dialog id. </param>
        /// <param name="startDialogRequestInternal"> The start dialog request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="callConnectionId"/>, <paramref name="dialogId"/> or <paramref name="startDialogRequestInternal"/> is null. </exception>
        /// <remarks> Start a dialog. </remarks>
        public async Task<Response<DialogStateResponseInternal>> StartDialogAsync(string callConnectionId, string dialogId, StartDialogRequestInternal startDialogRequestInternal, CancellationToken cancellationToken = default)
        {
            if (callConnectionId == null)
            {
                throw new ArgumentNullException(nameof(callConnectionId));
            }
            if (dialogId == null)
            {
                throw new ArgumentNullException(nameof(dialogId));
            }
            if (startDialogRequestInternal == null)
            {
                throw new ArgumentNullException(nameof(startDialogRequestInternal));
            }

            using var message = CreateStartDialogRequest(callConnectionId, dialogId, startDialogRequestInternal);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 201:
                    {
                        DialogStateResponseInternal value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = DialogStateResponseInternal.DeserializeDialogStateResponseInternal(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Start a dialog targeting a particular participant on the call. </summary>
        /// <param name="callConnectionId"> The call connection id. </param>
        /// <param name="dialogId"> The dialog id. </param>
        /// <param name="startDialogRequestInternal"> The start dialog request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="callConnectionId"/>, <paramref name="dialogId"/> or <paramref name="startDialogRequestInternal"/> is null. </exception>
        /// <remarks> Start a dialog. </remarks>
        public Response<DialogStateResponseInternal> StartDialog(string callConnectionId, string dialogId, StartDialogRequestInternal startDialogRequestInternal, CancellationToken cancellationToken = default)
        {
            if (callConnectionId == null)
            {
                throw new ArgumentNullException(nameof(callConnectionId));
            }
            if (dialogId == null)
            {
                throw new ArgumentNullException(nameof(dialogId));
            }
            if (startDialogRequestInternal == null)
            {
                throw new ArgumentNullException(nameof(startDialogRequestInternal));
            }

            using var message = CreateStartDialogRequest(callConnectionId, dialogId, startDialogRequestInternal);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 201:
                    {
                        DialogStateResponseInternal value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = DialogStateResponseInternal.DeserializeDialogStateResponseInternal(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateStopDialogRequest(string callConnectionId, string dialogId, string operationCallbackUri)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Delete;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/calling/callConnections/", false);
            uri.AppendPath(callConnectionId, true);
            uri.AppendPath("/dialogs/", false);
            uri.AppendPath(dialogId, true);
            if (operationCallbackUri != null)
            {
                uri.AppendQuery("operationCallbackUri", operationCallbackUri, true);
            }
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <param name="callConnectionId"> The <see cref="string"/> to use. </param>
        /// <param name="dialogId"> The <see cref="string"/> to use. </param>
        /// <param name="operationCallbackUri"> The <see cref="string"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="callConnectionId"/> or <paramref name="dialogId"/> is null. </exception>
        public async Task<Response> StopDialogAsync(string callConnectionId, string dialogId, string operationCallbackUri = null, CancellationToken cancellationToken = default)
        {
            if (callConnectionId == null)
            {
                throw new ArgumentNullException(nameof(callConnectionId));
            }
            if (dialogId == null)
            {
                throw new ArgumentNullException(nameof(dialogId));
            }

            using var message = CreateStopDialogRequest(callConnectionId, dialogId, operationCallbackUri);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <param name="callConnectionId"> The <see cref="string"/> to use. </param>
        /// <param name="dialogId"> The <see cref="string"/> to use. </param>
        /// <param name="operationCallbackUri"> The <see cref="string"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="callConnectionId"/> or <paramref name="dialogId"/> is null. </exception>
        public Response StopDialog(string callConnectionId, string dialogId, string operationCallbackUri = null, CancellationToken cancellationToken = default)
        {
            if (callConnectionId == null)
            {
                throw new ArgumentNullException(nameof(callConnectionId));
            }
            if (dialogId == null)
            {
                throw new ArgumentNullException(nameof(dialogId));
            }

            using var message = CreateStopDialogRequest(callConnectionId, dialogId, operationCallbackUri);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateUpdateDialogRequest(string callConnectionId, string dialogId, UpdateDialogRequestInternal updateDialogRequestInternal)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Patch;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/calling/callConnections/", false);
            uri.AppendPath(callConnectionId, true);
            uri.AppendPath("/dialogs/", false);
            uri.AppendPath(dialogId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(updateDialogRequestInternal);
            request.Content = content;
            return message;
        }

        /// <summary> Update an ongoing dialog in a call. </summary>
        /// <param name="callConnectionId"> The call connection id. </param>
        /// <param name="dialogId"> The dialog id. </param>
        /// <param name="updateDialogRequestInternal"> The update dialog request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="callConnectionId"/>, <paramref name="dialogId"/> or <paramref name="updateDialogRequestInternal"/> is null. </exception>
        /// <remarks> Update a dialog. </remarks>
        public async Task<Response> UpdateDialogAsync(string callConnectionId, string dialogId, UpdateDialogRequestInternal updateDialogRequestInternal, CancellationToken cancellationToken = default)
        {
            if (callConnectionId == null)
            {
                throw new ArgumentNullException(nameof(callConnectionId));
            }
            if (dialogId == null)
            {
                throw new ArgumentNullException(nameof(dialogId));
            }
            if (updateDialogRequestInternal == null)
            {
                throw new ArgumentNullException(nameof(updateDialogRequestInternal));
            }

            using var message = CreateUpdateDialogRequest(callConnectionId, dialogId, updateDialogRequestInternal);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Update an ongoing dialog in a call. </summary>
        /// <param name="callConnectionId"> The call connection id. </param>
        /// <param name="dialogId"> The dialog id. </param>
        /// <param name="updateDialogRequestInternal"> The update dialog request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="callConnectionId"/>, <paramref name="dialogId"/> or <paramref name="updateDialogRequestInternal"/> is null. </exception>
        /// <remarks> Update a dialog. </remarks>
        public Response UpdateDialog(string callConnectionId, string dialogId, UpdateDialogRequestInternal updateDialogRequestInternal, CancellationToken cancellationToken = default)
        {
            if (callConnectionId == null)
            {
                throw new ArgumentNullException(nameof(callConnectionId));
            }
            if (dialogId == null)
            {
                throw new ArgumentNullException(nameof(dialogId));
            }
            if (updateDialogRequestInternal == null)
            {
                throw new ArgumentNullException(nameof(updateDialogRequestInternal));
            }

            using var message = CreateUpdateDialogRequest(callConnectionId, dialogId, updateDialogRequestInternal);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }
    }
}
