// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Vision.Face
{
    using Models;
    using System.Collections;
    using System.Collections.Generic;
    using System.Threading;
    using System.Threading.Tasks;

    /// <summary>
    /// Extension methods for SnapshotOperations.
    /// </summary>
    public static partial class SnapshotOperationsExtensions
    {
            /// <summary>
            /// Submit an operation to take a snapshot of face list, large face list,
            /// person group or large person group, with user-specified snapshot type,
            /// source object id, apply scope and an optional user data.&lt;br /&gt;
            /// The snapshot interfaces are for users to backup and restore their face data
            /// from one face subscription to another, inside same region or across
            /// regions. The workflow contains two phases, user first calls Snapshot - Take
            /// to create a copy of the source object and store it as a snapshot, then
            /// calls Snapshot - Apply to paste the snapshot to target subscription. The
            /// snapshots are stored in a centralized location (per Azure instance), so
            /// that they can be applied cross accounts and regions.&lt;br /&gt;
            /// Taking snapshot is an asynchronous operation. An operation id can be
            /// obtained from the "Operation-Location" field in response header, to be used
            /// in OperationStatus - Get for tracking the progress of creating the
            /// snapshot. The snapshot id will be included in the "resourceLocation" field
            /// in OperationStatus - Get response when the operation status is
            /// "succeeded".&lt;br /&gt;
            /// Snapshot taking time depends on the number of person and face entries in
            /// the source object. It could be in seconds, or up to several hours for
            /// 1,000,000 persons with multiple faces.&lt;br /&gt;
            /// Snapshots will be automatically expired and cleaned in 48 hours after it is
            /// created by Snapshot - Take. User can delete the snapshot using Snapshot -
            /// Delete by themselves any time before expiration.&lt;br /&gt;
            /// Taking snapshot for a certain object will not block any other operations
            /// against the object. All read-only operations (Get/List and
            /// Identify/FindSimilar/Verify) can be conducted as usual. For all writable
            /// operations, including Add/Update/Delete the source object or its
            /// persons/faces and Train, they are not blocked but not recommended because
            /// writable updates may not be reflected on the snapshot during its taking.
            /// After snapshot taking is completed, all readable and writable operations
            /// can work as normal. Snapshot will also include the training results of the
            /// source object, which means target subscription the snapshot applied to does
            /// not need re-train the target object before calling
            /// Identify/FindSimilar.&lt;br /&gt;
            /// * Free-tier subscription quota: 100 take operations per month.
            /// * S0-tier subscription quota: 100 take operations per day.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='type'>
            /// User specified type for the source object to take snapshot from. Currently
            /// FaceList, PersonGroup, LargeFaceList and LargePersonGroup are supported.
            /// Possible values include: 'FaceList', 'LargeFaceList', 'LargePersonGroup',
            /// 'PersonGroup'
            /// </param>
            /// <param name='objectId'>
            /// User specified source object id to take snapshot from.
            /// </param>
            /// <param name='applyScope'>
            /// User specified array of target Face subscription ids for the snapshot. For
            /// each snapshot, only subscriptions included in the applyScope of Snapshot -
            /// Take can apply it.
            /// </param>
            /// <param name='userData'>
            /// User specified data about the snapshot for any purpose. Length should not
            /// exceed 16KB.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<SnapshotTakeHeaders> TakeAsync(this ISnapshotOperations operations, SnapshotObjectType type, string objectId, IList<System.Guid> applyScope, string userData = default(string), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.TakeWithHttpMessagesAsync(type, objectId, applyScope, userData, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Headers;
                }
            }

            /// <summary>
            /// List all accessible snapshots with related information, including snapshots
            /// that were taken by the user, or snapshots to be applied to the user
            /// (subscription id was included in the applyScope in Snapshot - Take).
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='type'>
            /// User specified object type as a search filter. Possible values include:
            /// 'FaceList', 'LargeFaceList', 'LargePersonGroup', 'PersonGroup'
            /// </param>
            /// <param name='applyScope'>
            /// User specified snapshot apply scopes as a search filter. ApplyScope is an
            /// array of the target Azure subscription ids for the snapshot, specified by
            /// the user who created the snapshot by Snapshot - Take.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IList<Snapshot>> ListAsync(this ISnapshotOperations operations, SnapshotObjectType? type = default(SnapshotObjectType?), IList<System.Guid> applyScope = default(IList<System.Guid>), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ListWithHttpMessagesAsync(type, applyScope, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Retrieve information about a snapshot. Snapshot is only accessible to the
            /// source subscription who took it, and target subscriptions included in the
            /// applyScope in Snapshot - Take.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='snapshotId'>
            /// Id referencing a particular snapshot.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<Snapshot> GetAsync(this ISnapshotOperations operations, System.Guid snapshotId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetWithHttpMessagesAsync(snapshotId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Update the information of a snapshot. Only the source subscription who took
            /// the snapshot can update the snapshot.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='snapshotId'>
            /// Id referencing a particular snapshot.
            /// </param>
            /// <param name='applyScope'>
            /// Array of the target Face subscription ids for the snapshot, specified by
            /// the user who created the snapshot when calling Snapshot - Take. For each
            /// snapshot, only subscriptions included in the applyScope of Snapshot - Take
            /// can apply it.
            /// </param>
            /// <param name='userData'>
            /// User specified data about the snapshot for any purpose. Length should not
            /// exceed 16KB.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task UpdateAsync(this ISnapshotOperations operations, System.Guid snapshotId, IList<System.Guid> applyScope = default(IList<System.Guid>), string userData = default(string), CancellationToken cancellationToken = default(CancellationToken))
            {
                (await operations.UpdateWithHttpMessagesAsync(snapshotId, applyScope, userData, null, cancellationToken).ConfigureAwait(false)).Dispose();
            }

            /// <summary>
            /// Delete an existing snapshot according to the snapshotId. All object data
            /// and information in the snapshot will also be deleted. Only the source
            /// subscription who took the snapshot can delete the snapshot. If the user
            /// does not delete a snapshot with this API, the snapshot will still be
            /// automatically deleted in 48 hours after creation.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='snapshotId'>
            /// Id referencing a particular snapshot.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task DeleteAsync(this ISnapshotOperations operations, System.Guid snapshotId, CancellationToken cancellationToken = default(CancellationToken))
            {
                (await operations.DeleteWithHttpMessagesAsync(snapshotId, null, cancellationToken).ConfigureAwait(false)).Dispose();
            }

            /// <summary>
            /// Submit an operation to apply a snapshot to current subscription. For each
            /// snapshot, only subscriptions included in the applyScope of Snapshot - Take
            /// can apply it.&lt;br /&gt;
            /// The snapshot interfaces are for users to backup and restore their face data
            /// from one face subscription to another, inside same region or across
            /// regions. The workflow contains two phases, user first calls Snapshot - Take
            /// to create a copy of the source object and store it as a snapshot, then
            /// calls Snapshot - Apply to paste the snapshot to target subscription. The
            /// snapshots are stored in a centralized location (per Azure instance), so
            /// that they can be applied cross accounts and regions.&lt;br /&gt;
            /// Applying snapshot is an asynchronous operation. An operation id can be
            /// obtained from the "Operation-Location" field in response header, to be used
            /// in OperationStatus - Get for tracking the progress of applying the
            /// snapshot. The target object id will be included in the "resourceLocation"
            /// field in OperationStatus - Get response when the operation status is
            /// "succeeded".&lt;br /&gt;
            /// Snapshot applying time depends on the number of person and face entries in
            /// the snapshot object. It could be in seconds, or up to 1 hour for 1,000,000
            /// persons with multiple faces.&lt;br /&gt;
            /// Snapshots will be automatically expired and cleaned in 48 hours after it is
            /// created by Snapshot - Take. So the target subscription is required to apply
            /// the snapshot in 48 hours since its creation.&lt;br /&gt;
            /// Applying a snapshot will not block any other operations against the target
            /// object, however it is not recommended because the correctness cannot be
            /// guaranteed during snapshot applying. After snapshot applying is completed,
            /// all operations towards the target object can work as normal. Snapshot also
            /// includes the training results of the source object, which means target
            /// subscription the snapshot applied to does not need re-train the target
            /// object before calling Identify/FindSimilar.&lt;br /&gt;
            /// One snapshot can be applied multiple times in parallel, while currently
            /// only CreateNew apply mode is supported, which means the apply operation
            /// will fail if target subscription already contains an object of same type
            /// and using the same objectId. Users can specify the "objectId" in request
            /// body to avoid such conflicts.&lt;br /&gt;
            /// * Free-tier subscription quota: 100 apply operations per month.
            /// * S0-tier subscription quota: 100 apply operations per day.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='snapshotId'>
            /// Id referencing a particular snapshot.
            /// </param>
            /// <param name='objectId'>
            /// User specified target object id to be created from the snapshot.
            /// </param>
            /// <param name='mode'>
            /// Snapshot applying mode. Currently only CreateNew is supported, which means
            /// the apply operation will fail if target subscription already contains an
            /// object of same type and using the same objectId. Users can specify the
            /// "objectId" in request body to avoid such conflicts. Possible values
            /// include: 'CreateNew'
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<SnapshotApplyHeaders> ApplyAsync(this ISnapshotOperations operations, System.Guid snapshotId, string objectId, SnapshotApplyMode mode = default(SnapshotApplyMode), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ApplyWithHttpMessagesAsync(snapshotId, objectId, mode, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Headers;
                }
            }

            /// <summary>
            /// Retrieve the status of a take/apply snapshot operation.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='operationId'>
            /// Id referencing a particular take/apply snapshot operation.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<OperationStatus> GetOperationStatusAsync(this ISnapshotOperations operations, System.Guid operationId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetOperationStatusWithHttpMessagesAsync(operationId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

    }
}
