// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Vision.Face.Models
{
    using Newtonsoft.Json;
    using System.Linq;

    /// <summary>
    /// Result of the verify operation.
    /// </summary>
    public partial class VerifyResult
    {
        /// <summary>
        /// Initializes a new instance of the VerifyResult class.
        /// </summary>
        public VerifyResult()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the VerifyResult class.
        /// </summary>
        /// <param name="isIdentical">True if the two faces belong to the same
        /// person or the face belongs to the person, otherwise false.</param>
        /// <param name="confidence">A number indicates the similarity
        /// confidence of whether two faces belong to the same person, or
        /// whether the face belongs to the person. By default, isIdentical is
        /// set to True if similarity confidence is greater than or equal to
        /// 0.5. This is useful for advanced users to override "isIdentical"
        /// and fine-tune the result on their own data.</param>
        public VerifyResult(bool isIdentical, double confidence)
        {
            IsIdentical = isIdentical;
            Confidence = confidence;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets true if the two faces belong to the same person or the
        /// face belongs to the person, otherwise false.
        /// </summary>
        [JsonProperty(PropertyName = "isIdentical")]
        public bool IsIdentical { get; set; }

        /// <summary>
        /// Gets or sets a number indicates the similarity confidence of
        /// whether two faces belong to the same person, or whether the face
        /// belongs to the person. By default, isIdentical is set to True if
        /// similarity confidence is greater than or equal to 0.5. This is
        /// useful for advanced users to override "isIdentical" and fine-tune
        /// the result on their own data.
        /// </summary>
        [JsonProperty(PropertyName = "confidence")]
        public double Confidence { get; set; }

        /// <summary>
        /// Validate the object.
        /// </summary>
        /// <exception cref="Rest.ValidationException">
        /// Thrown if validation fails
        /// </exception>
        public virtual void Validate()
        {
            //Nothing to validate
        }
    }
}
