// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Vision.Face.Models
{
    using Microsoft.Rest;
    using Newtonsoft.Json;
    using System.Linq;

    /// <summary>
    /// Request to update face data.
    /// </summary>
    public partial class UpdateFaceRequest
    {
        /// <summary>
        /// Initializes a new instance of the UpdateFaceRequest class.
        /// </summary>
        public UpdateFaceRequest()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the UpdateFaceRequest class.
        /// </summary>
        /// <param name="userData">User-provided data attached to the face. The
        /// size limit is 1KB.</param>
        public UpdateFaceRequest(string userData = default(string))
        {
            UserData = userData;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets user-provided data attached to the face. The size
        /// limit is 1KB.
        /// </summary>
        [JsonProperty(PropertyName = "userData")]
        public string UserData { get; set; }

        /// <summary>
        /// Validate the object.
        /// </summary>
        /// <exception cref="ValidationException">
        /// Thrown if validation fails
        /// </exception>
        public virtual void Validate()
        {
            if (UserData != null)
            {
                if (UserData.Length > 1024)
                {
                    throw new ValidationException(ValidationRules.MaxLength, "UserData", 1024);
                }
            }
        }
    }
}
