// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Vision.Face.Models
{
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Person object.
    /// </summary>
    public partial class Person : NameAndUserDataContract
    {
        /// <summary>
        /// Initializes a new instance of the Person class.
        /// </summary>
        public Person()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the Person class.
        /// </summary>
        /// <param name="personId">PersonId of the target face list.</param>
        /// <param name="name">User defined name, maximum length is
        /// 128.</param>
        /// <param name="userData">User specified data. Length should not
        /// exceed 16KB.</param>
        /// <param name="persistedFaceIds">PersistedFaceIds of registered faces
        /// in the person. These persistedFaceIds are returned from Person -
        /// Add a Person Face, and will not expire.</param>
        public Person(System.Guid personId, string name = default(string), string userData = default(string), IList<System.Guid> persistedFaceIds = default(IList<System.Guid>))
            : base(name, userData)
        {
            PersonId = personId;
            PersistedFaceIds = persistedFaceIds;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets personId of the target face list.
        /// </summary>
        [JsonProperty(PropertyName = "personId")]
        public System.Guid PersonId { get; set; }

        /// <summary>
        /// Gets or sets persistedFaceIds of registered faces in the person.
        /// These persistedFaceIds are returned from Person - Add a Person
        /// Face, and will not expire.
        /// </summary>
        [JsonProperty(PropertyName = "persistedFaceIds")]
        public IList<System.Guid> PersistedFaceIds { get; set; }

        /// <summary>
        /// Validate the object.
        /// </summary>
        /// <exception cref="Rest.ValidationException">
        /// Thrown if validation fails
        /// </exception>
        public override void Validate()
        {
            base.Validate();
        }
    }
}
