// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Vision.Face.Models
{
    using Newtonsoft.Json;
    using System.Linq;

    /// <summary>
    /// Operation status object. Operation refers to the asynchronous backend
    /// task including taking a snapshot and applying a snapshot.
    /// </summary>
    public partial class OperationStatus
    {
        /// <summary>
        /// Initializes a new instance of the OperationStatus class.
        /// </summary>
        public OperationStatus()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the OperationStatus class.
        /// </summary>
        /// <param name="status">Operation status: notstarted, running,
        /// succeeded, failed. If the operation is requested and waiting to
        /// perform, the status is notstarted. If the operation is ongoing in
        /// backend, the status is running. Status succeeded means the
        /// operation is completed successfully, specifically for snapshot
        /// taking operation, it illustrates the snapshot is well taken and
        /// ready to apply, and for snapshot applying operation, it presents
        /// the target object has finished creating by the snapshot and ready
        /// to be used. Status failed is often caused by editing the source
        /// object while taking the snapshot or editing the target object while
        /// applying the snapshot before completion, see the field "message" to
        /// check the failure reason. Possible values include: 'notstarted',
        /// 'running', 'succeeded', 'failed'</param>
        /// <param name="createdTime">A combined UTC date and time string that
        /// describes the time when the operation (take or apply a snapshot) is
        /// requested. E.g. 2018-12-25T11:41:02.2331413Z.</param>
        /// <param name="lastActionTime">A combined UTC date and time string
        /// that describes the last time the operation (take or apply a
        /// snapshot) is actively migrating data. The lastActionTime will keep
        /// increasing until the operation finishes. E.g.
        /// 2018-12-25T11:51:27.8705696Z.</param>
        /// <param name="resourceLocation">When the operation succeeds
        /// successfully, for snapshot taking operation the snapshot id will be
        /// included in this field, and for snapshot applying operation, the
        /// path to get the target object will be returned in this
        /// field.</param>
        /// <param name="message">Show failure message when operation fails
        /// (omitted when operation succeeds).</param>
        public OperationStatus(OperationStatusType status, System.DateTime createdTime, System.DateTime? lastActionTime = default(System.DateTime?), string resourceLocation = default(string), string message = default(string))
        {
            Status = status;
            CreatedTime = createdTime;
            LastActionTime = lastActionTime;
            ResourceLocation = resourceLocation;
            Message = message;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets operation status: notstarted, running, succeeded,
        /// failed. If the operation is requested and waiting to perform, the
        /// status is notstarted. If the operation is ongoing in backend, the
        /// status is running. Status succeeded means the operation is
        /// completed successfully, specifically for snapshot taking operation,
        /// it illustrates the snapshot is well taken and ready to apply, and
        /// for snapshot applying operation, it presents the target object has
        /// finished creating by the snapshot and ready to be used. Status
        /// failed is often caused by editing the source object while taking
        /// the snapshot or editing the target object while applying the
        /// snapshot before completion, see the field "message" to check the
        /// failure reason. Possible values include: 'notstarted', 'running',
        /// 'succeeded', 'failed'
        /// </summary>
        [JsonProperty(PropertyName = "status")]
        public OperationStatusType Status { get; set; }

        /// <summary>
        /// Gets or sets a combined UTC date and time string that describes the
        /// time when the operation (take or apply a snapshot) is requested.
        /// E.g. 2018-12-25T11:41:02.2331413Z.
        /// </summary>
        [JsonProperty(PropertyName = "createdTime")]
        public System.DateTime CreatedTime { get; set; }

        /// <summary>
        /// Gets or sets a combined UTC date and time string that describes the
        /// last time the operation (take or apply a snapshot) is actively
        /// migrating data. The lastActionTime will keep increasing until the
        /// operation finishes. E.g. 2018-12-25T11:51:27.8705696Z.
        /// </summary>
        [JsonProperty(PropertyName = "lastActionTime")]
        public System.DateTime? LastActionTime { get; set; }

        /// <summary>
        /// Gets or sets when the operation succeeds successfully, for snapshot
        /// taking operation the snapshot id will be included in this field,
        /// and for snapshot applying operation, the path to get the target
        /// object will be returned in this field.
        /// </summary>
        [JsonProperty(PropertyName = "resourceLocation")]
        public string ResourceLocation { get; set; }

        /// <summary>
        /// Gets or sets show failure message when operation fails (omitted
        /// when operation succeeds).
        /// </summary>
        [JsonProperty(PropertyName = "message")]
        public string Message { get; set; }

        /// <summary>
        /// Validate the object.
        /// </summary>
        /// <exception cref="Rest.ValidationException">
        /// Thrown if validation fails
        /// </exception>
        public virtual void Validate()
        {
        }
    }
}
