// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Vision.Face.Models
{
    using Microsoft.Rest;
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Response body for identify face operation.
    /// </summary>
    public partial class IdentifyResult
    {
        /// <summary>
        /// Initializes a new instance of the IdentifyResult class.
        /// </summary>
        public IdentifyResult()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the IdentifyResult class.
        /// </summary>
        /// <param name="faceId">FaceId of the query face</param>
        /// <param name="candidates">Identified person candidates for that face
        /// (ranked by confidence). Array size should be no larger than input
        /// maxNumOfCandidatesReturned. If no person is identified, will return
        /// an empty array.</param>
        public IdentifyResult(System.Guid faceId, IList<IdentifyCandidate> candidates)
        {
            FaceId = faceId;
            Candidates = candidates;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets faceId of the query face
        /// </summary>
        [JsonProperty(PropertyName = "faceId")]
        public System.Guid FaceId { get; set; }

        /// <summary>
        /// Gets or sets identified person candidates for that face (ranked by
        /// confidence). Array size should be no larger than input
        /// maxNumOfCandidatesReturned. If no person is identified, will return
        /// an empty array.
        /// </summary>
        [JsonProperty(PropertyName = "candidates")]
        public IList<IdentifyCandidate> Candidates { get; set; }

        /// <summary>
        /// Validate the object.
        /// </summary>
        /// <exception cref="ValidationException">
        /// Thrown if validation fails
        /// </exception>
        public virtual void Validate()
        {
            if (Candidates == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "Candidates");
            }
            if (Candidates != null)
            {
                foreach (var element in Candidates)
                {
                    if (element != null)
                    {
                        element.Validate();
                    }
                }
            }
        }
    }
}
