// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Vision.Face.Models
{
    using Microsoft.Rest;
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Request body for identify face operation.
    /// </summary>
    public partial class IdentifyRequest
    {
        /// <summary>
        /// Initializes a new instance of the IdentifyRequest class.
        /// </summary>
        public IdentifyRequest()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the IdentifyRequest class.
        /// </summary>
        /// <param name="faceIds">Array of query faces faceIds, created by the
        /// Face - Detect. Each of the faces are identified independently. The
        /// valid number of faceIds is between [1, 10].</param>
        /// <param name="personGroupId">PersonGroupId of the target person
        /// group, created by PersonGroup - Create. Parameter personGroupId and
        /// largePersonGroupId should not be provided at the same time.</param>
        /// <param name="largePersonGroupId">LargePersonGroupId of the target
        /// large person group, created by LargePersonGroup - Create. Parameter
        /// personGroupId and largePersonGroupId should not be provided at the
        /// same time.</param>
        /// <param name="maxNumOfCandidatesReturned">The range of
        /// maxNumOfCandidatesReturned is between 1 and 100 (default is
        /// 1).</param>
        /// <param name="confidenceThreshold">Confidence threshold of
        /// identification, used to judge whether one face belong to one
        /// person. The range of confidenceThreshold is [0, 1] (default
        /// specified by algorithm).</param>
        public IdentifyRequest(IList<System.Guid> faceIds, string personGroupId = default(string), string largePersonGroupId = default(string), int? maxNumOfCandidatesReturned = default(int?), double? confidenceThreshold = default(double?))
        {
            FaceIds = faceIds;
            PersonGroupId = personGroupId;
            LargePersonGroupId = largePersonGroupId;
            MaxNumOfCandidatesReturned = maxNumOfCandidatesReturned;
            ConfidenceThreshold = confidenceThreshold;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets array of query faces faceIds, created by the Face -
        /// Detect. Each of the faces are identified independently. The valid
        /// number of faceIds is between [1, 10].
        /// </summary>
        [JsonProperty(PropertyName = "faceIds")]
        public IList<System.Guid> FaceIds { get; set; }

        /// <summary>
        /// Gets or sets personGroupId of the target person group, created by
        /// PersonGroup - Create. Parameter personGroupId and
        /// largePersonGroupId should not be provided at the same time.
        /// </summary>
        [JsonProperty(PropertyName = "personGroupId")]
        public string PersonGroupId { get; set; }

        /// <summary>
        /// Gets or sets largePersonGroupId of the target large person group,
        /// created by LargePersonGroup - Create. Parameter personGroupId and
        /// largePersonGroupId should not be provided at the same time.
        /// </summary>
        [JsonProperty(PropertyName = "largePersonGroupId")]
        public string LargePersonGroupId { get; set; }

        /// <summary>
        /// Gets or sets the range of maxNumOfCandidatesReturned is between 1
        /// and 100 (default is 1).
        /// </summary>
        [JsonProperty(PropertyName = "maxNumOfCandidatesReturned")]
        public int? MaxNumOfCandidatesReturned { get; set; }

        /// <summary>
        /// Gets or sets confidence threshold of identification, used to judge
        /// whether one face belong to one person. The range of
        /// confidenceThreshold is [0, 1] (default specified by algorithm).
        /// </summary>
        [JsonProperty(PropertyName = "confidenceThreshold")]
        public double? ConfidenceThreshold { get; set; }

        /// <summary>
        /// Validate the object.
        /// </summary>
        /// <exception cref="ValidationException">
        /// Thrown if validation fails
        /// </exception>
        public virtual void Validate()
        {
            if (FaceIds == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "FaceIds");
            }
            if (FaceIds != null)
            {
                if (FaceIds.Count > 10)
                {
                    throw new ValidationException(ValidationRules.MaxItems, "FaceIds", 10);
                }
            }
            if (PersonGroupId != null)
            {
                if (PersonGroupId.Length > 64)
                {
                    throw new ValidationException(ValidationRules.MaxLength, "PersonGroupId", 64);
                }
                if (!System.Text.RegularExpressions.Regex.IsMatch(PersonGroupId, "^[a-z0-9-_]+$"))
                {
                    throw new ValidationException(ValidationRules.Pattern, "PersonGroupId", "^[a-z0-9-_]+$");
                }
            }
            if (LargePersonGroupId != null)
            {
                if (LargePersonGroupId.Length > 64)
                {
                    throw new ValidationException(ValidationRules.MaxLength, "LargePersonGroupId", 64);
                }
                if (!System.Text.RegularExpressions.Regex.IsMatch(LargePersonGroupId, "^[a-z0-9-_]+$"))
                {
                    throw new ValidationException(ValidationRules.Pattern, "LargePersonGroupId", "^[a-z0-9-_]+$");
                }
            }
            if (MaxNumOfCandidatesReturned > 100)
            {
                throw new ValidationException(ValidationRules.InclusiveMaximum, "MaxNumOfCandidatesReturned", 100);
            }
            if (MaxNumOfCandidatesReturned < 1)
            {
                throw new ValidationException(ValidationRules.InclusiveMinimum, "MaxNumOfCandidatesReturned", 1);
            }
        }
    }
}
