// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Vision.Face.Models
{
    using Microsoft.Rest;
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Request body for find similar operation.
    /// </summary>
    public partial class FindSimilarRequest
    {
        /// <summary>
        /// Initializes a new instance of the FindSimilarRequest class.
        /// </summary>
        public FindSimilarRequest()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the FindSimilarRequest class.
        /// </summary>
        /// <param name="faceId">FaceId of the query face. User needs to call
        /// Face - Detect first to get a valid faceId. Note that this faceId is
        /// not persisted and will expire at the time specified by
        /// faceIdTimeToLive after the detection call</param>
        /// <param name="faceListId">An existing user-specified unique
        /// candidate face list, created in Face List - Create a Face List.
        /// Face list contains a set of persistedFaceIds which are persisted
        /// and will never expire. Parameter faceListId, largeFaceListId and
        /// faceIds should not be provided at the same time.</param>
        /// <param name="largeFaceListId">An existing user-specified unique
        /// candidate large face list, created in LargeFaceList - Create. Large
        /// face list contains a set of persistedFaceIds which are persisted
        /// and will never expire. Parameter faceListId, largeFaceListId and
        /// faceIds should not be provided at the same time.</param>
        /// <param name="faceIds">An array of candidate faceIds. All of them
        /// are created by Face - Detect and the faceIds will expire at the
        /// time specified by faceIdTimeToLive after the detection call. The
        /// number of faceIds is limited to 1000. Parameter faceListId,
        /// largeFaceListId and faceIds should not be provided at the same
        /// time.</param>
        /// <param name="maxNumOfCandidatesReturned">The number of top similar
        /// faces returned. The valid range is [1, 1000].</param>
        /// <param name="mode">Similar face searching mode. It can be
        /// "matchPerson" or "matchFace". Possible values include:
        /// 'matchPerson', 'matchFace'</param>
        public FindSimilarRequest(System.Guid faceId, string faceListId = default(string), string largeFaceListId = default(string), IList<System.Guid?> faceIds = default(IList<System.Guid?>), int? maxNumOfCandidatesReturned = default(int?), FindSimilarMatchMode mode = default(FindSimilarMatchMode))
        {
            FaceId = faceId;
            FaceListId = faceListId;
            LargeFaceListId = largeFaceListId;
            FaceIds = faceIds;
            MaxNumOfCandidatesReturned = maxNumOfCandidatesReturned;
            Mode = mode;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets faceId of the query face. User needs to call Face -
        /// Detect first to get a valid faceId. Note that this faceId is not
        /// persisted and will expire at the time specified by faceIdTimeToLive
        /// after the detection call
        /// </summary>
        [JsonProperty(PropertyName = "faceId")]
        public System.Guid FaceId { get; set; }

        /// <summary>
        /// Gets or sets an existing user-specified unique candidate face list,
        /// created in Face List - Create a Face List. Face list contains a set
        /// of persistedFaceIds which are persisted and will never expire.
        /// Parameter faceListId, largeFaceListId and faceIds should not be
        /// provided at the same time.
        /// </summary>
        [JsonProperty(PropertyName = "faceListId")]
        public string FaceListId { get; set; }

        /// <summary>
        /// Gets or sets an existing user-specified unique candidate large face
        /// list, created in LargeFaceList - Create. Large face list contains a
        /// set of persistedFaceIds which are persisted and will never expire.
        /// Parameter faceListId, largeFaceListId and faceIds should not be
        /// provided at the same time.
        /// </summary>
        [JsonProperty(PropertyName = "largeFaceListId")]
        public string LargeFaceListId { get; set; }

        /// <summary>
        /// Gets or sets an array of candidate faceIds. All of them are created
        /// by Face - Detect and the faceIds will expire at the time specified
        /// by faceIdTimeToLive after the detection call. The number of faceIds
        /// is limited to 1000. Parameter faceListId, largeFaceListId and
        /// faceIds should not be provided at the same time.
        /// </summary>
        [JsonProperty(PropertyName = "faceIds")]
        public IList<System.Guid?> FaceIds { get; set; }

        /// <summary>
        /// Gets or sets the number of top similar faces returned. The valid
        /// range is [1, 1000].
        /// </summary>
        [JsonProperty(PropertyName = "maxNumOfCandidatesReturned")]
        public int? MaxNumOfCandidatesReturned { get; set; }

        /// <summary>
        /// Gets or sets similar face searching mode. It can be "matchPerson"
        /// or "matchFace". Possible values include: 'matchPerson', 'matchFace'
        /// </summary>
        [JsonProperty(PropertyName = "mode")]
        public FindSimilarMatchMode Mode { get; set; }

        /// <summary>
        /// Validate the object.
        /// </summary>
        /// <exception cref="ValidationException">
        /// Thrown if validation fails
        /// </exception>
        public virtual void Validate()
        {
            if (FaceListId != null)
            {
                if (FaceListId.Length > 64)
                {
                    throw new ValidationException(ValidationRules.MaxLength, "FaceListId", 64);
                }
                if (!System.Text.RegularExpressions.Regex.IsMatch(FaceListId, "^[a-z0-9-_]+$"))
                {
                    throw new ValidationException(ValidationRules.Pattern, "FaceListId", "^[a-z0-9-_]+$");
                }
            }
            if (LargeFaceListId != null)
            {
                if (LargeFaceListId.Length > 64)
                {
                    throw new ValidationException(ValidationRules.MaxLength, "LargeFaceListId", 64);
                }
                if (!System.Text.RegularExpressions.Regex.IsMatch(LargeFaceListId, "^[a-z0-9-_]+$"))
                {
                    throw new ValidationException(ValidationRules.Pattern, "LargeFaceListId", "^[a-z0-9-_]+$");
                }
            }
            if (FaceIds != null)
            {
                if (FaceIds.Count > 1000)
                {
                    throw new ValidationException(ValidationRules.MaxItems, "FaceIds", 1000);
                }
            }
            if (MaxNumOfCandidatesReturned > 1000)
            {
                throw new ValidationException(ValidationRules.InclusiveMaximum, "MaxNumOfCandidatesReturned", 1000);
            }
            if (MaxNumOfCandidatesReturned < 1)
            {
                throw new ValidationException(ValidationRules.InclusiveMinimum, "MaxNumOfCandidatesReturned", 1);
            }
        }
    }
}
