// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Vision.Face.Models
{
    using Newtonsoft.Json;
    using System.Linq;

    /// <summary>
    /// Properties describing exposure level of the image.
    /// </summary>
    public partial class Exposure
    {
        /// <summary>
        /// Initializes a new instance of the Exposure class.
        /// </summary>
        public Exposure()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the Exposure class.
        /// </summary>
        /// <param name="exposureLevel">An enum value indicating level of
        /// exposure. Possible values include: 'UnderExposure', 'GoodExposure',
        /// 'OverExposure'</param>
        /// <param name="value">A number indicating level of exposure level
        /// ranging from 0 to 1. [0, 0.25) is under exposure. [0.25, 0.75) is
        /// good exposure. [0.75, 1] is over exposure.</param>
        public Exposure(ExposureLevel exposureLevel = default(ExposureLevel), double value = default(double))
        {
            ExposureLevel = exposureLevel;
            Value = value;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets an enum value indicating level of exposure. Possible
        /// values include: 'UnderExposure', 'GoodExposure', 'OverExposure'
        /// </summary>
        [JsonProperty(PropertyName = "exposureLevel")]
        public ExposureLevel ExposureLevel { get; set; }

        /// <summary>
        /// Gets or sets a number indicating level of exposure level ranging
        /// from 0 to 1. [0, 0.25) is under exposure. [0.25, 0.75) is good
        /// exposure. [0.75, 1] is over exposure.
        /// </summary>
        [JsonProperty(PropertyName = "value")]
        public double Value { get; set; }

    }
}
