// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Vision.Face.Models
{
    using Microsoft.Rest;
    using Newtonsoft.Json;
    using System.Linq;

    /// <summary>
    /// Request body for applying snapshot operation.
    /// </summary>
    public partial class ApplySnapshotRequest
    {
        /// <summary>
        /// Initializes a new instance of the ApplySnapshotRequest class.
        /// </summary>
        public ApplySnapshotRequest()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the ApplySnapshotRequest class.
        /// </summary>
        /// <param name="objectId">User specified target object id to be
        /// created from the snapshot.</param>
        /// <param name="mode">Snapshot applying mode. Currently only CreateNew
        /// is supported, which means the apply operation will fail if target
        /// subscription already contains an object of same type and using the
        /// same objectId. Users can specify the "objectId" in request body to
        /// avoid such conflicts. Possible values include: 'CreateNew'</param>
        public ApplySnapshotRequest(string objectId, SnapshotApplyMode mode = default(SnapshotApplyMode))
        {
            ObjectId = objectId;
            Mode = mode;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets user specified target object id to be created from the
        /// snapshot.
        /// </summary>
        [JsonProperty(PropertyName = "objectId")]
        public string ObjectId { get; set; }

        /// <summary>
        /// Gets or sets snapshot applying mode. Currently only CreateNew is
        /// supported, which means the apply operation will fail if target
        /// subscription already contains an object of same type and using the
        /// same objectId. Users can specify the "objectId" in request body to
        /// avoid such conflicts. Possible values include: 'CreateNew'
        /// </summary>
        [JsonProperty(PropertyName = "mode")]
        public SnapshotApplyMode Mode { get; set; }

        /// <summary>
        /// Validate the object.
        /// </summary>
        /// <exception cref="ValidationException">
        /// Thrown if validation fails
        /// </exception>
        public virtual void Validate()
        {
            if (ObjectId == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "ObjectId");
            }
            if (ObjectId != null)
            {
                if (ObjectId.Length > 64)
                {
                    throw new ValidationException(ValidationRules.MaxLength, "ObjectId", 64);
                }
                if (!System.Text.RegularExpressions.Regex.IsMatch(ObjectId, "^[a-z0-9-_]+$"))
                {
                    throw new ValidationException(ValidationRules.Pattern, "ObjectId", "^[a-z0-9-_]+$");
                }
            }
        }
    }
}
