// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Vision.Face
{
    using Models;
    using System.Collections;
    using System.Collections.Generic;
    using System.IO;
    using System.Threading;
    using System.Threading.Tasks;

    /// <summary>
    /// Extension methods for LargeFaceListOperations.
    /// </summary>
    public static partial class LargeFaceListOperationsExtensions
    {
            /// <summary>
            /// Create an empty large face list with user-specified largeFaceListId, name,
            /// an optional userData and recognitionModel.
            /// &lt;br /&gt; Large face list is a list of faces, up to 1,000,000 faces, and
            /// used by [Face - Find
            /// Similar](https://docs.microsoft.com/rest/api/faceapi/face/findsimilar).
            /// &lt;br /&gt; After creation, user should use [LargeFaceList Face -
            /// Add](https://docs.microsoft.com/rest/api/faceapi/largefacelist/addfacefromurl)
            /// to import the faces and [LargeFaceList -
            /// Train](https://docs.microsoft.com/rest/api/faceapi/largefacelist/train) to
            /// make it ready for [Face - Find
            /// Similar](https://docs.microsoft.com/rest/api/faceapi/face/findsimilar). No
            /// image will be stored. Only the extracted face features are stored on server
            /// until [LargeFaceList -
            /// Delete](https://docs.microsoft.com/rest/api/faceapi/largefacelist/delete)
            /// is called.
            /// &lt;br /&gt; Find Similar is used for scenario like finding celebrity-like
            /// faces, similar face filtering, or as a light way face identification. But
            /// if the actual use is to identify person, please use
            /// [PersonGroup](https://docs.microsoft.com/rest/api/faceapi/persongroup) /
            /// [LargePersonGroup](https://docs.microsoft.com/rest/api/faceapi/largepersongroup)
            /// and [Face -
            /// Identify](https://docs.microsoft.com/rest/api/faceapi/face/identify).
            /// &lt;br/&gt;'recognitionModel' should be specified to associate with this
            /// large face list. The default value for 'recognitionModel' is
            /// 'recognition_01', if the latest model needed, please explicitly specify the
            /// model you need in this parameter. New faces that are added to an existing
            /// large face list will use the recognition model that's already associated
            /// with the collection. Existing face features in a large face list can't be
            /// updated to features extracted by another version of recognition model.
            /// Please refer to [Specify a recognition
            /// model](https://docs.microsoft.com/azure/cognitive-services/face/face-api-how-to-topics/specify-recognition-model).
            ///
            /// Large face list quota:
            /// * Free-tier subscription quota: 64 large face lists.
            /// * S0-tier subscription quota: 1,000,000 large face lists.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='largeFaceListId'>
            /// Id referencing a particular large face list.
            /// </param>
            /// <param name='name'>
            /// User defined name, maximum length is 128.
            /// </param>
            /// <param name='userData'>
            /// User specified data. Length should not exceed 16KB.
            /// </param>
            /// <param name='recognitionModel'>
            /// Possible values include: 'recognition_01', 'recognition_02',
            /// 'recognition_03', 'recognition_04'
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task CreateAsync(this ILargeFaceListOperations operations, string largeFaceListId, string name, string userData = default(string), string recognitionModel = default(string), CancellationToken cancellationToken = default(CancellationToken))
            {
                (await operations.CreateWithHttpMessagesAsync(largeFaceListId, name, userData, recognitionModel, null, cancellationToken).ConfigureAwait(false)).Dispose();
            }

            /// <summary>
            /// Retrieve a large face list’s largeFaceListId, name, userData and
            /// recognitionModel.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='largeFaceListId'>
            /// Id referencing a particular large face list.
            /// </param>
            /// <param name='returnRecognitionModel'>
            /// A value indicating whether the operation should return 'recognitionModel'
            /// in response.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<LargeFaceList> GetAsync(this ILargeFaceListOperations operations, string largeFaceListId, bool? returnRecognitionModel = false, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetWithHttpMessagesAsync(largeFaceListId, returnRecognitionModel, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Update information of a large face list.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='largeFaceListId'>
            /// Id referencing a particular large face list.
            /// </param>
            /// <param name='name'>
            /// User defined name, maximum length is 128.
            /// </param>
            /// <param name='userData'>
            /// User specified data. Length should not exceed 16KB.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task UpdateAsync(this ILargeFaceListOperations operations, string largeFaceListId, string name = default(string), string userData = default(string), CancellationToken cancellationToken = default(CancellationToken))
            {
                (await operations.UpdateWithHttpMessagesAsync(largeFaceListId, name, userData, null, cancellationToken).ConfigureAwait(false)).Dispose();
            }

            /// <summary>
            /// Delete a specified large face list.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='largeFaceListId'>
            /// Id referencing a particular large face list.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task DeleteAsync(this ILargeFaceListOperations operations, string largeFaceListId, CancellationToken cancellationToken = default(CancellationToken))
            {
                (await operations.DeleteWithHttpMessagesAsync(largeFaceListId, null, cancellationToken).ConfigureAwait(false)).Dispose();
            }

            /// <summary>
            /// Retrieve the training status of a large face list (completed or ongoing).
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='largeFaceListId'>
            /// Id referencing a particular large face list.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<TrainingStatus> GetTrainingStatusAsync(this ILargeFaceListOperations operations, string largeFaceListId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetTrainingStatusWithHttpMessagesAsync(largeFaceListId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// List large face lists’ information of largeFaceListId, name, userData and
            /// recognitionModel. &lt;br /&gt;
            /// To get face information inside largeFaceList use [LargeFaceList Face -
            /// Get](https://docs.microsoft.com/rest/api/faceapi/largefacelist/getface)&lt;br
            /// /&gt;
            /// * Large face lists are stored in alphabetical order of largeFaceListId.
            /// * "start" parameter (string, optional) is a user-provided largeFaceListId
            /// value that returned entries have larger ids by string comparison. "start"
            /// set to empty to indicate return from the first item.
            /// * "top" parameter (int, optional) specifies the number of entries to
            /// return. A maximal of 1000 entries can be returned in one call. To fetch
            /// more, you can specify "start" with the last returned entry’s Id of the
            /// current call.
            /// &lt;br /&gt;
            /// For example, total 5 large person lists: "list1", ..., "list5".
            /// &lt;br /&gt; "start=&amp;top=" will return all 5 lists.
            /// &lt;br /&gt; "start=&amp;top=2" will return "list1", "list2".
            /// &lt;br /&gt; "start=list2&amp;top=3" will return "list3", "list4", "list5".
            ///
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='returnRecognitionModel'>
            /// A value indicating whether the operation should return 'recognitionModel'
            /// in response.
            /// </param>
            /// <param name='start'>
            /// Starting large face list id to return (used to list a range of large face
            /// lists).
            /// </param>
            /// <param name='top'>
            /// Number of large face lists to return starting with the large face list id
            /// indicated by the 'start' parameter.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IList<LargeFaceList>> ListAsync(this ILargeFaceListOperations operations, bool? returnRecognitionModel = false, string start = default(string), int? top = default(int?), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ListWithHttpMessagesAsync(returnRecognitionModel, start, top, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Queue a large face list training task, the training task may not be started
            /// immediately.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='largeFaceListId'>
            /// Id referencing a particular large face list.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task TrainAsync(this ILargeFaceListOperations operations, string largeFaceListId, CancellationToken cancellationToken = default(CancellationToken))
            {
                (await operations.TrainWithHttpMessagesAsync(largeFaceListId, null, cancellationToken).ConfigureAwait(false)).Dispose();
            }

            /// <summary>
            /// Delete a face from a large face list by specified largeFaceListId and
            /// persistedFaceId.
            /// &lt;br /&gt; Adding/deleting faces to/from a same large face list are
            /// processed sequentially and to/from different large face lists are in
            /// parallel.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='largeFaceListId'>
            /// Id referencing a particular large face list.
            /// </param>
            /// <param name='persistedFaceId'>
            /// Id referencing a particular persistedFaceId of an existing face.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task DeleteFaceAsync(this ILargeFaceListOperations operations, string largeFaceListId, System.Guid persistedFaceId, CancellationToken cancellationToken = default(CancellationToken))
            {
                (await operations.DeleteFaceWithHttpMessagesAsync(largeFaceListId, persistedFaceId, null, cancellationToken).ConfigureAwait(false)).Dispose();
            }

            /// <summary>
            /// Retrieve information about a persisted face (specified by persistedFaceId
            /// and its belonging largeFaceListId).
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='largeFaceListId'>
            /// Id referencing a particular large face list.
            /// </param>
            /// <param name='persistedFaceId'>
            /// Id referencing a particular persistedFaceId of an existing face.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<PersistedFace> GetFaceAsync(this ILargeFaceListOperations operations, string largeFaceListId, System.Guid persistedFaceId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetFaceWithHttpMessagesAsync(largeFaceListId, persistedFaceId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Update a persisted face's userData field.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='largeFaceListId'>
            /// Id referencing a particular large face list.
            /// </param>
            /// <param name='persistedFaceId'>
            /// Id referencing a particular persistedFaceId of an existing face.
            /// </param>
            /// <param name='userData'>
            /// User-provided data attached to the face. The size limit is 1KB.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task UpdateFaceAsync(this ILargeFaceListOperations operations, string largeFaceListId, System.Guid persistedFaceId, string userData = default(string), CancellationToken cancellationToken = default(CancellationToken))
            {
                (await operations.UpdateFaceWithHttpMessagesAsync(largeFaceListId, persistedFaceId, userData, null, cancellationToken).ConfigureAwait(false)).Dispose();
            }

            /// <summary>
            /// Add a face to a specified large face list, up to 1,000,000 faces.
            /// &lt;br /&gt; To deal with an image contains multiple faces, input face can
            /// be specified as an image with a targetFace rectangle. It returns a
            /// persistedFaceId representing the added face. No image will be stored. Only
            /// the extracted face feature will be stored on server until [LargeFaceList
            /// Face -
            /// Delete](https://docs.microsoft.com/rest/api/faceapi/largefacelist/deleteface)
            /// or [LargeFaceList -
            /// Delete](https://docs.microsoft.com/rest/api/faceapi/largefacelist/delete)
            /// is called.
            /// &lt;br /&gt; Note persistedFaceId is different from faceId generated by
            /// [Face -
            /// Detect](https://docs.microsoft.com/rest/api/faceapi/face/detectwithurl).
            /// * Higher face image quality means better recognition precision. Please
            /// consider high-quality faces: frontal, clear, and face size is 200x200
            /// pixels (100 pixels between eyes) or bigger.
            /// * JPEG, PNG, GIF (the first frame), and BMP format are supported. The
            /// allowed image file size is from 1KB to 6MB.
            /// * "targetFace" rectangle should contain one face. Zero or multiple faces
            /// will be regarded as an error. If the provided "targetFace" rectangle is not
            /// returned from [Face -
            /// Detect](https://docs.microsoft.com/rest/api/faceapi/face/detectwithurl),
            /// there’s no guarantee to detect and add the face successfully.
            /// * Out of detectable face size (36x36 - 4096x4096 pixels), large head-pose,
            /// or large occlusions will cause failures.
            /// * Adding/deleting faces to/from a same face list are processed sequentially
            /// and to/from different face lists are in parallel.
            /// * The minimum detectable face size is 36x36 pixels in an image no larger
            /// than 1920x1080 pixels. Images with dimensions higher than 1920x1080 pixels
            /// will need a proportionally larger minimum face size.
            /// * Different 'detectionModel' values can be provided. To use and compare
            /// different detection models, please refer to [How to specify a detection
            /// model](https://docs.microsoft.com/azure/cognitive-services/face/face-api-how-to-topics/specify-detection-model)
            ///
            /// Quota:
            /// * Free-tier subscription quota: 1,000 faces per large face list.
            /// * S0-tier subscription quota: 1,000,000 faces per large face list.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='largeFaceListId'>
            /// Id referencing a particular large face list.
            /// </param>
            /// <param name='url'>
            /// Publicly reachable URL of an image
            /// </param>
            /// <param name='userData'>
            /// User-specified data about the face for any purpose. The maximum length is
            /// 1KB.
            /// </param>
            /// <param name='targetFace'>
            /// A face rectangle to specify the target face to be added to a person in the
            /// format of "targetFace=left,top,width,height". E.g.
            /// "targetFace=10,10,100,100". If there is more than one face in the image,
            /// targetFace is required to specify which face to add. No targetFace means
            /// there is only one face detected in the entire image.
            /// </param>
            /// <param name='detectionModel'>
            /// Name of detection model. Detection model is used to detect faces in the
            /// submitted image. A detection model name can be provided when performing
            /// Face - Detect or (Large)FaceList - Add Face or (Large)PersonGroup - Add
            /// Face. The default value is 'detection_01', if another model is needed,
            /// please explicitly specify it. Possible values include: 'detection_01',
            /// 'detection_02', 'detection_03'
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<PersistedFace> AddFaceFromUrlAsync(this ILargeFaceListOperations operations, string largeFaceListId, string url, string userData = default(string), IList<int> targetFace = default(IList<int>), string detectionModel = default(string), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.AddFaceFromUrlWithHttpMessagesAsync(largeFaceListId, url, userData, targetFace, detectionModel, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// List all faces in a large face list, and retrieve face information
            /// (including userData and persistedFaceIds of registered faces of the face).
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='largeFaceListId'>
            /// Id referencing a particular large face list.
            /// </param>
            /// <param name='start'>
            /// Starting face id to return (used to list a range of faces).
            /// </param>
            /// <param name='top'>
            /// Number of faces to return starting with the face id indicated by the
            /// 'start' parameter.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IList<PersistedFace>> ListFacesAsync(this ILargeFaceListOperations operations, string largeFaceListId, string start = default(string), int? top = default(int?), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ListFacesWithHttpMessagesAsync(largeFaceListId, start, top, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Add a face to a specified large face list, up to 1,000,000 faces.
            /// &lt;br /&gt; To deal with an image contains multiple faces, input face can
            /// be specified as an image with a targetFace rectangle. It returns a
            /// persistedFaceId representing the added face. No image will be stored. Only
            /// the extracted face feature will be stored on server until [LargeFaceList
            /// Face -
            /// Delete](https://docs.microsoft.com/rest/api/faceapi/largefacelist/deleteface)
            /// or [LargeFaceList -
            /// Delete](https://docs.microsoft.com/rest/api/faceapi/largefacelist/delete)
            /// is called.
            /// &lt;br /&gt; Note persistedFaceId is different from faceId generated by
            /// [Face -
            /// Detect](https://docs.microsoft.com/rest/api/faceapi/face/detectwithurl).
            /// * Higher face image quality means better recognition precision. Please
            /// consider high-quality faces: frontal, clear, and face size is 200x200
            /// pixels (100 pixels between eyes) or bigger.
            /// * JPEG, PNG, GIF (the first frame), and BMP format are supported. The
            /// allowed image file size is from 1KB to 6MB.
            /// * "targetFace" rectangle should contain one face. Zero or multiple faces
            /// will be regarded as an error. If the provided "targetFace" rectangle is not
            /// returned from [Face -
            /// Detect](https://docs.microsoft.com/rest/api/faceapi/face/detectwithurl),
            /// there’s no guarantee to detect and add the face successfully.
            /// * Out of detectable face size (36x36 - 4096x4096 pixels), large head-pose,
            /// or large occlusions will cause failures.
            /// * Adding/deleting faces to/from a same face list are processed sequentially
            /// and to/from different face lists are in parallel.
            /// * The minimum detectable face size is 36x36 pixels in an image no larger
            /// than 1920x1080 pixels. Images with dimensions higher than 1920x1080 pixels
            /// will need a proportionally larger minimum face size.
            /// * Different 'detectionModel' values can be provided. To use and compare
            /// different detection models, please refer to [How to specify a detection
            /// model](https://docs.microsoft.com/azure/cognitive-services/face/face-api-how-to-topics/specify-detection-model).
            ///
            /// Quota:
            /// * Free-tier subscription quota: 1,000 faces per large face list.
            /// * S0-tier subscription quota: 1,000,000 faces per large face list.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='largeFaceListId'>
            /// Id referencing a particular large face list.
            /// </param>
            /// <param name='image'>
            /// An image stream.
            /// </param>
            /// <param name='userData'>
            /// User-specified data about the face for any purpose. The maximum length is
            /// 1KB.
            /// </param>
            /// <param name='targetFace'>
            /// A face rectangle to specify the target face to be added to a person in the
            /// format of "targetFace=left,top,width,height". E.g.
            /// "targetFace=10,10,100,100". If there is more than one face in the image,
            /// targetFace is required to specify which face to add. No targetFace means
            /// there is only one face detected in the entire image.
            /// </param>
            /// <param name='detectionModel'>
            /// Name of detection model. Detection model is used to detect faces in the
            /// submitted image. A detection model name can be provided when performing
            /// Face - Detect or (Large)FaceList - Add Face or (Large)PersonGroup - Add
            /// Face. The default value is 'detection_01', if another model is needed,
            /// please explicitly specify it. Possible values include: 'detection_01',
            /// 'detection_02', 'detection_03'
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<PersistedFace> AddFaceFromStreamAsync(this ILargeFaceListOperations operations, string largeFaceListId, Stream image, string userData = default(string), IList<int> targetFace = default(IList<int>), string detectionModel = default(string), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.AddFaceFromStreamWithHttpMessagesAsync(largeFaceListId, image, userData, targetFace, detectionModel, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

    }
}
