// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Vision.CustomVision.Training.Models
{
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Parameters used for training.
    /// </summary>
    public partial class TrainingParameters
    {
        /// <summary>
        /// Initializes a new instance of the TrainingParameters class.
        /// </summary>
        public TrainingParameters()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the TrainingParameters class.
        /// </summary>
        /// <param name="selectedTags">List of tags selected for this training
        /// session, other tags in the project will be ignored.</param>
        /// <param name="customBaseModelInfo">Information of the previously
        /// trained iteration which provides the base model for current
        /// iteration's training.</param>
        public TrainingParameters(IList<System.Guid> selectedTags = default(IList<System.Guid>), CustomBaseModelInfo customBaseModelInfo = default(CustomBaseModelInfo))
        {
            SelectedTags = selectedTags;
            CustomBaseModelInfo = customBaseModelInfo;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets list of tags selected for this training session, other
        /// tags in the project will be ignored.
        /// </summary>
        [JsonProperty(PropertyName = "selectedTags")]
        public IList<System.Guid> SelectedTags { get; set; }

        /// <summary>
        /// Gets or sets information of the previously trained iteration which
        /// provides the base model for current iteration's training.
        /// </summary>
        [JsonProperty(PropertyName = "customBaseModelInfo")]
        public CustomBaseModelInfo CustomBaseModelInfo { get; set; }

        /// <summary>
        /// Validate the object.
        /// </summary>
        /// <exception cref="Rest.ValidationException">
        /// Thrown if validation fails
        /// </exception>
        public virtual void Validate()
        {
            if (CustomBaseModelInfo != null)
            {
                CustomBaseModelInfo.Validate();
            }
        }
    }
}
