// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Vision.CustomVision.Training.Models
{
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Contains properties we need to fetch suggested tags for. For the first
    /// call, Session and continuation set to null.
    /// Then on subsequent calls, uses the session/continuation from the
    /// previous SuggestedTagAndRegionQuery result to fetch additional results.
    /// </summary>
    public partial class SuggestedTagAndRegionQueryToken
    {
        /// <summary>
        /// Initializes a new instance of the SuggestedTagAndRegionQueryToken
        /// class.
        /// </summary>
        public SuggestedTagAndRegionQueryToken()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the SuggestedTagAndRegionQueryToken
        /// class.
        /// </summary>
        /// <param name="tagIds">Existing TagIds in project to filter suggested
        /// tags on.</param>
        /// <param name="threshold">Confidence threshold to filter suggested
        /// tags on.</param>
        /// <param name="session">SessionId for database query. Initially set
        /// to null but later used to paginate.</param>
        /// <param name="continuation">Continuation Id for database pagination.
        /// Initially null but later used to paginate.</param>
        /// <param name="maxCount">Maximum number of results you want to be
        /// returned in the response.</param>
        /// <param name="sortBy">OrderBy. Ordering mechanism for your results.
        /// Possible values include: 'UncertaintyAscending',
        /// 'UncertaintyDescending'</param>
        public SuggestedTagAndRegionQueryToken(IList<System.Guid> tagIds = default(IList<System.Guid>), double threshold = default(double), string session = default(string), string continuation = default(string), int maxCount = default(int), string sortBy = default(string))
        {
            TagIds = tagIds;
            Threshold = threshold;
            Session = session;
            Continuation = continuation;
            MaxCount = maxCount;
            SortBy = sortBy;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets existing TagIds in project to filter suggested tags
        /// on.
        /// </summary>
        [JsonProperty(PropertyName = "tagIds")]
        public IList<System.Guid> TagIds { get; set; }

        /// <summary>
        /// Gets or sets confidence threshold to filter suggested tags on.
        /// </summary>
        [JsonProperty(PropertyName = "threshold")]
        public double Threshold { get; set; }

        /// <summary>
        /// Gets or sets sessionId for database query. Initially set to null
        /// but later used to paginate.
        /// </summary>
        [JsonProperty(PropertyName = "session")]
        public string Session { get; set; }

        /// <summary>
        /// Gets or sets continuation Id for database pagination. Initially
        /// null but later used to paginate.
        /// </summary>
        [JsonProperty(PropertyName = "continuation")]
        public string Continuation { get; set; }

        /// <summary>
        /// Gets or sets maximum number of results you want to be returned in
        /// the response.
        /// </summary>
        [JsonProperty(PropertyName = "maxCount")]
        public int MaxCount { get; set; }

        /// <summary>
        /// Gets or sets orderBy. Ordering mechanism for your results. Possible
        /// values include: 'UncertaintyAscending', 'UncertaintyDescending'
        /// </summary>
        [JsonProperty(PropertyName = "sortBy")]
        public string SortBy { get; set; }

    }
}
