// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Vision.CustomVision.Training.Models
{
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Represents settings associated with a project.
    /// </summary>
    public partial class ProjectSettings
    {
        /// <summary>
        /// Initializes a new instance of the ProjectSettings class.
        /// </summary>
        public ProjectSettings()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the ProjectSettings class.
        /// </summary>
        /// <param name="domainId">Gets or sets the id of the Domain to use
        /// with this project.</param>
        /// <param name="classificationType">Gets or sets the classification
        /// type of the project. Possible values include: 'Multiclass',
        /// 'Multilabel'</param>
        /// <param name="targetExportPlatforms">A list of ExportPlatform that
        /// the trained model should be able to support.</param>
        /// <param name="useNegativeSet">Indicates if negative set is being
        /// used.</param>
        /// <param name="detectionParameters">Detection parameters in use, if
        /// any.</param>
        /// <param name="imageProcessingSettings">Gets or sets image
        /// preprocessing settings.</param>
        /// <param name="exportModelContainerUri">The uri to the Azure Storage
        /// container that will be used to store exported models.</param>
        /// <param name="notificationQueueUri">The uri to the Azure Storage
        /// queue that will be used to send project-related notifications. See
        /// &lt;a
        /// href="https://go.microsoft.com/fwlink/?linkid=2144149"&gt;Storage
        /// notifications&lt;/a&gt; documentation for setup and message
        /// format.</param>
        public ProjectSettings(System.Guid domainId = default(System.Guid), string classificationType = default(string), IList<string> targetExportPlatforms = default(IList<string>), bool? useNegativeSet = default(bool?), string detectionParameters = default(string), ImageProcessingSettings imageProcessingSettings = default(ImageProcessingSettings), string exportModelContainerUri = default(string), string notificationQueueUri = default(string))
        {
            DomainId = domainId;
            ClassificationType = classificationType;
            TargetExportPlatforms = targetExportPlatforms;
            UseNegativeSet = useNegativeSet;
            DetectionParameters = detectionParameters;
            ImageProcessingSettings = imageProcessingSettings;
            ExportModelContainerUri = exportModelContainerUri;
            NotificationQueueUri = notificationQueueUri;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets the id of the Domain to use with this project.
        /// </summary>
        [JsonProperty(PropertyName = "domainId")]
        public System.Guid DomainId { get; set; }

        /// <summary>
        /// Gets or sets the classification type of the project. Possible
        /// values include: 'Multiclass', 'Multilabel'
        /// </summary>
        [JsonProperty(PropertyName = "classificationType")]
        public string ClassificationType { get; set; }

        /// <summary>
        /// Gets or sets a list of ExportPlatform that the trained model should
        /// be able to support.
        /// </summary>
        [JsonProperty(PropertyName = "targetExportPlatforms")]
        public IList<string> TargetExportPlatforms { get; set; }

        /// <summary>
        /// Gets indicates if negative set is being used.
        /// </summary>
        [JsonProperty(PropertyName = "useNegativeSet")]
        public bool? UseNegativeSet { get; private set; }

        /// <summary>
        /// Gets detection parameters in use, if any.
        /// </summary>
        [JsonProperty(PropertyName = "detectionParameters")]
        public string DetectionParameters { get; private set; }

        /// <summary>
        /// Gets or sets image preprocessing settings.
        /// </summary>
        [JsonProperty(PropertyName = "imageProcessingSettings")]
        public ImageProcessingSettings ImageProcessingSettings { get; set; }

        /// <summary>
        /// Gets the uri to the Azure Storage container that will be used to
        /// store exported models.
        /// </summary>
        [JsonProperty(PropertyName = "exportModelContainerUri")]
        public string ExportModelContainerUri { get; private set; }

        /// <summary>
        /// Gets the uri to the Azure Storage queue that will be used to send
        /// project-related notifications. See &amp;lt;a
        /// href="https://go.microsoft.com/fwlink/?linkid=2144149"&amp;gt;Storage
        /// notifications&amp;lt;/a&amp;gt; documentation for setup and message
        /// format.
        /// </summary>
        [JsonProperty(PropertyName = "notificationQueueUri")]
        public string NotificationQueueUri { get; private set; }

    }
}
