// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Vision.CustomVision.Training.Models
{
    using Newtonsoft.Json;
    using System.Linq;

    /// <summary>
    /// Represents information about a project export.
    /// </summary>
    public partial class ProjectExport
    {
        /// <summary>
        /// Initializes a new instance of the ProjectExport class.
        /// </summary>
        public ProjectExport()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the ProjectExport class.
        /// </summary>
        /// <param name="iterationCount">Count of iterations that will be
        /// exported.</param>
        /// <param name="imageCount">Count of images that will be
        /// exported.</param>
        /// <param name="tagCount">Count of tags that will be exported.</param>
        /// <param name="regionCount">Count of regions that will be
        /// exported.</param>
        /// <param name="estimatedImportTimeInMS">Estimated time this project
        /// will take to import, can change based on network connectivity and
        /// load between
        /// source and destination regions.</param>
        /// <param name="token">Opaque token that should be passed to
        /// ImportProject to perform the import. This token grants access to
        /// import this
        /// project to all that have the token.</param>
        public ProjectExport(int iterationCount = default(int), int imageCount = default(int), int tagCount = default(int), int regionCount = default(int), int estimatedImportTimeInMS = default(int), string token = default(string))
        {
            IterationCount = iterationCount;
            ImageCount = imageCount;
            TagCount = tagCount;
            RegionCount = regionCount;
            EstimatedImportTimeInMS = estimatedImportTimeInMS;
            Token = token;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets count of iterations that will be exported.
        /// </summary>
        [JsonProperty(PropertyName = "iterationCount")]
        public int IterationCount { get; private set; }

        /// <summary>
        /// Gets count of images that will be exported.
        /// </summary>
        [JsonProperty(PropertyName = "imageCount")]
        public int ImageCount { get; private set; }

        /// <summary>
        /// Gets count of tags that will be exported.
        /// </summary>
        [JsonProperty(PropertyName = "tagCount")]
        public int TagCount { get; private set; }

        /// <summary>
        /// Gets count of regions that will be exported.
        /// </summary>
        [JsonProperty(PropertyName = "regionCount")]
        public int RegionCount { get; private set; }

        /// <summary>
        /// Gets estimated time this project will take to import, can change
        /// based on network connectivity and load between
        /// source and destination regions.
        /// </summary>
        [JsonProperty(PropertyName = "estimatedImportTimeInMS")]
        public int EstimatedImportTimeInMS { get; private set; }

        /// <summary>
        /// Gets opaque token that should be passed to ImportProject to perform
        /// the import. This token grants access to import this
        /// project to all that have the token.
        /// </summary>
        [JsonProperty(PropertyName = "token")]
        public string Token { get; private set; }

    }
}
