// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Vision.CustomVision.Training.Models
{
    using Newtonsoft.Json;
    using System.Linq;

    /// <summary>
    /// Prediction result.
    /// </summary>
    public partial class Prediction
    {
        /// <summary>
        /// Initializes a new instance of the Prediction class.
        /// </summary>
        public Prediction()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the Prediction class.
        /// </summary>
        /// <param name="probability">Probability of the tag.</param>
        /// <param name="tagId">Id of the predicted tag.</param>
        /// <param name="tagName">Name of the predicted tag.</param>
        /// <param name="boundingBox">Bounding box of the prediction.</param>
        /// <param name="tagType">Type of the predicted tag. Possible values
        /// include: 'Regular', 'Negative', 'GeneralProduct'</param>
        public Prediction(double probability = default(double), System.Guid tagId = default(System.Guid), string tagName = default(string), BoundingBox boundingBox = default(BoundingBox), string tagType = default(string))
        {
            Probability = probability;
            TagId = tagId;
            TagName = tagName;
            BoundingBox = boundingBox;
            TagType = tagType;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets probability of the tag.
        /// </summary>
        [JsonProperty(PropertyName = "probability")]
        public double Probability { get; private set; }

        /// <summary>
        /// Gets id of the predicted tag.
        /// </summary>
        [JsonProperty(PropertyName = "tagId")]
        public System.Guid TagId { get; private set; }

        /// <summary>
        /// Gets name of the predicted tag.
        /// </summary>
        [JsonProperty(PropertyName = "tagName")]
        public string TagName { get; private set; }

        /// <summary>
        /// Gets bounding box of the prediction.
        /// </summary>
        [JsonProperty(PropertyName = "boundingBox")]
        public BoundingBox BoundingBox { get; private set; }

        /// <summary>
        /// Gets type of the predicted tag. Possible values include: 'Regular',
        /// 'Negative', 'GeneralProduct'
        /// </summary>
        [JsonProperty(PropertyName = "tagType")]
        public string TagType { get; private set; }

        /// <summary>
        /// Validate the object.
        /// </summary>
        /// <exception cref="Rest.ValidationException">
        /// Thrown if validation fails
        /// </exception>
        public virtual void Validate()
        {
            if (BoundingBox != null)
            {
                BoundingBox.Validate();
            }
        }
    }
}
