// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Vision.CustomVision.Training.Models
{
    using Microsoft.Rest;
    using Newtonsoft.Json;
    using System.Linq;

    /// <summary>
    /// Model information.
    /// </summary>
    public partial class ModelInformation
    {
        /// <summary>
        /// Initializes a new instance of the ModelInformation class.
        /// </summary>
        public ModelInformation()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the ModelInformation class.
        /// </summary>
        /// <param name="description">Model description.</param>
        /// <param name="estimatedModelSizeInMegabytes">Estimation of the
        /// exported FP32 Onnx model size (2 tags) in megabytes. This
        /// information is not present if the model cannot be exported.</param>
        public ModelInformation(string description, int? estimatedModelSizeInMegabytes = default(int?))
        {
            EstimatedModelSizeInMegabytes = estimatedModelSizeInMegabytes;
            Description = description;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets estimation of the exported FP32 Onnx model size (2
        /// tags) in megabytes. This information is not present if the model
        /// cannot be exported.
        /// </summary>
        [JsonProperty(PropertyName = "estimatedModelSizeInMegabytes")]
        public int? EstimatedModelSizeInMegabytes { get; set; }

        /// <summary>
        /// Gets or sets model description.
        /// </summary>
        [JsonProperty(PropertyName = "description")]
        public string Description { get; set; }

        /// <summary>
        /// Validate the object.
        /// </summary>
        /// <exception cref="ValidationException">
        /// Thrown if validation fails
        /// </exception>
        public virtual void Validate()
        {
            if (Description == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "Description");
            }
        }
    }
}
