// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Vision.CustomVision.Training.Models
{
    using Microsoft.Rest;
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Iteration model to be sent over JSON.
    /// </summary>
    public partial class Iteration
    {
        /// <summary>
        /// Initializes a new instance of the Iteration class.
        /// </summary>
        public Iteration()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the Iteration class.
        /// </summary>
        /// <param name="name">Gets or sets the name of the iteration.</param>
        /// <param name="id">Gets the id of the iteration.</param>
        /// <param name="status">Gets the current iteration status.</param>
        /// <param name="created">Gets the time this iteration was
        /// completed.</param>
        /// <param name="lastModified">Gets the time this iteration was last
        /// modified.</param>
        /// <param name="trainedAt">Gets the time this iteration was last
        /// modified.</param>
        /// <param name="projectId">Gets the project id of the
        /// iteration.</param>
        /// <param name="exportable">Whether the iteration can be exported to
        /// another format for download.</param>
        /// <param name="exportableTo">A set of platforms this iteration can
        /// export to.</param>
        /// <param name="domainId">Get or sets a guid of the domain the
        /// iteration has been trained on.</param>
        /// <param name="classificationType">Gets the classification type of
        /// the project. Possible values include: 'Multiclass',
        /// 'Multilabel'</param>
        /// <param name="trainingType">Gets the training type of the iteration.
        /// Possible values include: 'Regular', 'Advanced'</param>
        /// <param name="reservedBudgetInHours">Gets the reserved advanced
        /// training budget for the iteration.</param>
        /// <param name="trainingTimeInMinutes">Gets the training time for the
        /// iteration.</param>
        /// <param name="publishName">Name of the published model.</param>
        /// <param name="originalPublishResourceId">Resource Provider Id this
        /// iteration was originally published to.</param>
        /// <param name="customBaseModelInfo">Information of the previously
        /// trained iteration which provides the base model for current
        /// iteration's training.
        /// Default value of null specifies that no previously trained
        /// iteration will be used for incremental learning.</param>
        /// <param name="trainingErrorDetails">Training error details, when
        /// training fails.
        /// Value is null when training succeeds.</param>
        public Iteration(string name, System.Guid id = default(System.Guid), string status = default(string), System.DateTime created = default(System.DateTime), System.DateTime lastModified = default(System.DateTime), System.DateTime? trainedAt = default(System.DateTime?), System.Guid projectId = default(System.Guid), bool exportable = default(bool), IList<string> exportableTo = default(IList<string>), System.Guid? domainId = default(System.Guid?), string classificationType = default(string), string trainingType = default(string), int reservedBudgetInHours = default(int), int trainingTimeInMinutes = default(int), string publishName = default(string), string originalPublishResourceId = default(string), CustomBaseModelInfo customBaseModelInfo = default(CustomBaseModelInfo), string trainingErrorDetails = default(string))
        {
            Id = id;
            Name = name;
            Status = status;
            Created = created;
            LastModified = lastModified;
            TrainedAt = trainedAt;
            ProjectId = projectId;
            Exportable = exportable;
            ExportableTo = exportableTo;
            DomainId = domainId;
            ClassificationType = classificationType;
            TrainingType = trainingType;
            ReservedBudgetInHours = reservedBudgetInHours;
            TrainingTimeInMinutes = trainingTimeInMinutes;
            PublishName = publishName;
            OriginalPublishResourceId = originalPublishResourceId;
            CustomBaseModelInfo = customBaseModelInfo;
            TrainingErrorDetails = trainingErrorDetails;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets the id of the iteration.
        /// </summary>
        [JsonProperty(PropertyName = "id")]
        public System.Guid Id { get; private set; }

        /// <summary>
        /// Gets or sets the name of the iteration.
        /// </summary>
        [JsonProperty(PropertyName = "name")]
        public string Name { get; set; }

        /// <summary>
        /// Gets the current iteration status.
        /// </summary>
        [JsonProperty(PropertyName = "status")]
        public string Status { get; private set; }

        /// <summary>
        /// Gets the time this iteration was completed.
        /// </summary>
        [JsonProperty(PropertyName = "created")]
        public System.DateTime Created { get; private set; }

        /// <summary>
        /// Gets the time this iteration was last modified.
        /// </summary>
        [JsonProperty(PropertyName = "lastModified")]
        public System.DateTime LastModified { get; private set; }

        /// <summary>
        /// Gets the time this iteration was last modified.
        /// </summary>
        [JsonProperty(PropertyName = "trainedAt")]
        public System.DateTime? TrainedAt { get; private set; }

        /// <summary>
        /// Gets the project id of the iteration.
        /// </summary>
        [JsonProperty(PropertyName = "projectId")]
        public System.Guid ProjectId { get; private set; }

        /// <summary>
        /// Gets whether the iteration can be exported to another format for
        /// download.
        /// </summary>
        [JsonProperty(PropertyName = "exportable")]
        public bool Exportable { get; private set; }

        /// <summary>
        /// Gets a set of platforms this iteration can export to.
        /// </summary>
        [JsonProperty(PropertyName = "exportableTo")]
        public IList<string> ExportableTo { get; private set; }

        /// <summary>
        /// Gets get or sets a guid of the domain the iteration has been
        /// trained on.
        /// </summary>
        [JsonProperty(PropertyName = "domainId")]
        public System.Guid? DomainId { get; private set; }

        /// <summary>
        /// Gets the classification type of the project. Possible values
        /// include: 'Multiclass', 'Multilabel'
        /// </summary>
        [JsonProperty(PropertyName = "classificationType")]
        public string ClassificationType { get; private set; }

        /// <summary>
        /// Gets the training type of the iteration. Possible values include:
        /// 'Regular', 'Advanced'
        /// </summary>
        [JsonProperty(PropertyName = "trainingType")]
        public string TrainingType { get; private set; }

        /// <summary>
        /// Gets the reserved advanced training budget for the iteration.
        /// </summary>
        [JsonProperty(PropertyName = "reservedBudgetInHours")]
        public int ReservedBudgetInHours { get; private set; }

        /// <summary>
        /// Gets the training time for the iteration.
        /// </summary>
        [JsonProperty(PropertyName = "trainingTimeInMinutes")]
        public int TrainingTimeInMinutes { get; private set; }

        /// <summary>
        /// Gets name of the published model.
        /// </summary>
        [JsonProperty(PropertyName = "publishName")]
        public string PublishName { get; private set; }

        /// <summary>
        /// Gets resource Provider Id this iteration was originally published
        /// to.
        /// </summary>
        [JsonProperty(PropertyName = "originalPublishResourceId")]
        public string OriginalPublishResourceId { get; private set; }

        /// <summary>
        /// Gets information of the previously trained iteration which provides
        /// the base model for current iteration's training.
        /// Default value of null specifies that no previously trained
        /// iteration will be used for incremental learning.
        /// </summary>
        [JsonProperty(PropertyName = "customBaseModelInfo")]
        public CustomBaseModelInfo CustomBaseModelInfo { get; private set; }

        /// <summary>
        /// Gets training error details, when training fails.
        /// Value is null when training succeeds.
        /// </summary>
        [JsonProperty(PropertyName = "trainingErrorDetails")]
        public string TrainingErrorDetails { get; private set; }

        /// <summary>
        /// Validate the object.
        /// </summary>
        /// <exception cref="ValidationException">
        /// Thrown if validation fails
        /// </exception>
        public virtual void Validate()
        {
            if (Name == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "Name");
            }
            if (CustomBaseModelInfo != null)
            {
                CustomBaseModelInfo.Validate();
            }
        }
    }
}
