// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Vision.CustomVision.Training.Models
{
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Image model to be sent as JSON.
    /// </summary>
    public partial class Image
    {
        /// <summary>
        /// Initializes a new instance of the Image class.
        /// </summary>
        public Image()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the Image class.
        /// </summary>
        /// <param name="id">Id of the image.</param>
        /// <param name="created">Date the image was created.</param>
        /// <param name="width">Width of the image.</param>
        /// <param name="height">Height of the image.</param>
        /// <param name="resizedImageUri">The URI to the (resized) image used
        /// for training. If VNET feature is enabled this will be a relative
        /// path to be used with GetArtifact, otherwise this will be an
        /// absolute URI to the resource.</param>
        /// <param name="thumbnailUri">The URI to the thumbnail of the original
        /// image. If VNET feature is enabled this will be a relative path to
        /// be used with GetArtifact, otherwise this will be an absolute URI to
        /// the resource.</param>
        /// <param name="originalImageUri">The URI to the original uploaded
        /// image. If VNET feature is enabled this will be a relative path to
        /// be used with GetArtifact, otherwise this will be an absolute URI to
        /// the resource.</param>
        /// <param name="tags">Tags associated with this image.</param>
        /// <param name="regions">Regions associated with this image.</param>
        /// <param name="metadata">Metadata associated with this image.</param>
        public Image(System.Guid id = default(System.Guid), System.DateTime created = default(System.DateTime), int width = default(int), int height = default(int), string resizedImageUri = default(string), string thumbnailUri = default(string), string originalImageUri = default(string), IList<ImageTag> tags = default(IList<ImageTag>), IList<ImageRegion> regions = default(IList<ImageRegion>), IDictionary<string, string> metadata = default(IDictionary<string, string>))
        {
            Id = id;
            Created = created;
            Width = width;
            Height = height;
            ResizedImageUri = resizedImageUri;
            ThumbnailUri = thumbnailUri;
            OriginalImageUri = originalImageUri;
            Tags = tags;
            Regions = regions;
            Metadata = metadata;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets id of the image.
        /// </summary>
        [JsonProperty(PropertyName = "id")]
        public System.Guid Id { get; private set; }

        /// <summary>
        /// Gets date the image was created.
        /// </summary>
        [JsonProperty(PropertyName = "created")]
        public System.DateTime Created { get; private set; }

        /// <summary>
        /// Gets width of the image.
        /// </summary>
        [JsonProperty(PropertyName = "width")]
        public int Width { get; private set; }

        /// <summary>
        /// Gets height of the image.
        /// </summary>
        [JsonProperty(PropertyName = "height")]
        public int Height { get; private set; }

        /// <summary>
        /// Gets the URI to the (resized) image used for training. If VNET
        /// feature is enabled this will be a relative path to be used with
        /// GetArtifact, otherwise this will be an absolute URI to the
        /// resource.
        /// </summary>
        [JsonProperty(PropertyName = "resizedImageUri")]
        public string ResizedImageUri { get; private set; }

        /// <summary>
        /// Gets the URI to the thumbnail of the original image. If VNET
        /// feature is enabled this will be a relative path to be used with
        /// GetArtifact, otherwise this will be an absolute URI to the
        /// resource.
        /// </summary>
        [JsonProperty(PropertyName = "thumbnailUri")]
        public string ThumbnailUri { get; private set; }

        /// <summary>
        /// Gets the URI to the original uploaded image. If VNET feature is
        /// enabled this will be a relative path to be used with GetArtifact,
        /// otherwise this will be an absolute URI to the resource.
        /// </summary>
        [JsonProperty(PropertyName = "originalImageUri")]
        public string OriginalImageUri { get; private set; }

        /// <summary>
        /// Gets tags associated with this image.
        /// </summary>
        [JsonProperty(PropertyName = "tags")]
        public IList<ImageTag> Tags { get; private set; }

        /// <summary>
        /// Gets regions associated with this image.
        /// </summary>
        [JsonProperty(PropertyName = "regions")]
        public IList<ImageRegion> Regions { get; private set; }

        /// <summary>
        /// Gets metadata associated with this image.
        /// </summary>
        [JsonProperty(PropertyName = "metadata")]
        public IDictionary<string, string> Metadata { get; private set; }

    }
}
