// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Vision.CustomVision.Training.Models
{
    using Newtonsoft.Json;
    using System.Linq;

    public partial class Export
    {
        /// <summary>
        /// Initializes a new instance of the Export class.
        /// </summary>
        public Export()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the Export class.
        /// </summary>
        /// <param name="platform">Platform of the export. Possible values
        /// include: 'CoreML', 'TensorFlow', 'DockerFile', 'ONNX', 'VAIDK',
        /// 'OpenVino'</param>
        /// <param name="status">Status of the export. Possible values include:
        /// 'Exporting', 'Failed', 'Done'</param>
        /// <param name="downloadUri">URI used to download the model. If VNET
        /// feature is enabled this will be a relative path to be used with
        /// GetArtifact, otherwise this will be an absolute URI to the
        /// resource.</param>
        /// <param name="flavor">Flavor of the export. These are
        /// specializations of the export platform.
        /// Docker platform has valid flavors: Linux, Windows, ARM.
        /// Tensorflow platform has valid flavors: TensorFlowNormal,
        /// TensorFlowLite.
        /// ONNX platform has valid flavors: ONNX10, ONNX12. Possible values
        /// include: 'Linux', 'Windows', 'ONNX10', 'ONNX12', 'ARM',
        /// 'TensorFlowNormal', 'TensorFlowLite'</param>
        /// <param name="newerVersionAvailable">Indicates an updated version of
        /// the export package is available and should be re-exported for the
        /// latest changes.</param>
        public Export(string platform = default(string), string status = default(string), string downloadUri = default(string), string flavor = default(string), bool newerVersionAvailable = default(bool))
        {
            Platform = platform;
            Status = status;
            DownloadUri = downloadUri;
            Flavor = flavor;
            NewerVersionAvailable = newerVersionAvailable;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets platform of the export. Possible values include: 'CoreML',
        /// 'TensorFlow', 'DockerFile', 'ONNX', 'VAIDK', 'OpenVino'
        /// </summary>
        [JsonProperty(PropertyName = "platform")]
        public string Platform { get; private set; }

        /// <summary>
        /// Gets status of the export. Possible values include: 'Exporting',
        /// 'Failed', 'Done'
        /// </summary>
        [JsonProperty(PropertyName = "status")]
        public string Status { get; private set; }

        /// <summary>
        /// Gets URI used to download the model. If VNET feature is enabled
        /// this will be a relative path to be used with GetArtifact, otherwise
        /// this will be an absolute URI to the resource.
        /// </summary>
        [JsonProperty(PropertyName = "downloadUri")]
        public string DownloadUri { get; private set; }

        /// <summary>
        /// Gets flavor of the export. These are specializations of the export
        /// platform.
        /// Docker platform has valid flavors: Linux, Windows, ARM.
        /// Tensorflow platform has valid flavors: TensorFlowNormal,
        /// TensorFlowLite.
        /// ONNX platform has valid flavors: ONNX10, ONNX12. Possible values
        /// include: 'Linux', 'Windows', 'ONNX10', 'ONNX12', 'ARM',
        /// 'TensorFlowNormal', 'TensorFlowLite'
        /// </summary>
        [JsonProperty(PropertyName = "flavor")]
        public string Flavor { get; private set; }

        /// <summary>
        /// Gets indicates an updated version of the export package is
        /// available and should be re-exported for the latest changes.
        /// </summary>
        [JsonProperty(PropertyName = "newerVersionAvailable")]
        public bool NewerVersionAvailable { get; private set; }

    }
}
