// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Vision.CustomVision.Training
{
    using Microsoft.Rest;
    using Models;
    using System.Collections;
    using System.Collections.Generic;
    using System.IO;
    using System.Threading;
    using System.Threading.Tasks;

    /// <summary>
    /// Extension methods for CustomVisionTrainingClient.
    /// </summary>
    public static partial class CustomVisionTrainingClientExtensions
    {
            /// <summary>
            /// Get a list of the available domains.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            public static IList<Domain> GetDomains(this ICustomVisionTrainingClient operations)
            {
                return operations.GetDomainsAsync().GetAwaiter().GetResult();
            }

            /// <summary>
            /// Get a list of the available domains.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IList<Domain>> GetDomainsAsync(this ICustomVisionTrainingClient operations, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetDomainsWithHttpMessagesAsync(null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Get a list of the available domains.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse<IList<Domain>> GetDomainsWithHttpMessages(this ICustomVisionTrainingClient operations, Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.GetDomainsWithHttpMessagesAsync(customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Get information about a specific domain.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='domainId'>
            /// The id of the domain to get information about.
            /// </param>
            public static Domain GetDomain(this ICustomVisionTrainingClient operations, System.Guid domainId)
            {
                return operations.GetDomainAsync(domainId).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Get information about a specific domain.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='domainId'>
            /// The id of the domain to get information about.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<Domain> GetDomainAsync(this ICustomVisionTrainingClient operations, System.Guid domainId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetDomainWithHttpMessagesAsync(domainId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Get information about a specific domain.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='domainId'>
            /// The id of the domain to get information about.
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse<Domain> GetDomainWithHttpMessages(this ICustomVisionTrainingClient operations, System.Guid domainId, Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.GetDomainWithHttpMessagesAsync(domainId, customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Get your projects.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            public static IList<Project> GetProjects(this ICustomVisionTrainingClient operations)
            {
                return operations.GetProjectsAsync().GetAwaiter().GetResult();
            }

            /// <summary>
            /// Get your projects.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IList<Project>> GetProjectsAsync(this ICustomVisionTrainingClient operations, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetProjectsWithHttpMessagesAsync(null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Get your projects.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse<IList<Project>> GetProjectsWithHttpMessages(this ICustomVisionTrainingClient operations, Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.GetProjectsWithHttpMessagesAsync(customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Create a project.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='name'>
            /// Name of the project.
            /// </param>
            /// <param name='description'>
            /// The description of the project.
            /// </param>
            /// <param name='domainId'>
            /// The id of the domain to use for this project. Defaults to General.
            /// </param>
            /// <param name='classificationType'>
            /// The type of classifier to create for this project. Possible values include:
            /// 'Multiclass', 'Multilabel'
            /// </param>
            /// <param name='targetExportPlatforms'>
            /// List of platforms the trained model is intending exporting to.
            /// </param>
            /// <param name='options'>
            /// Additional project creation options.
            /// </param>
            public static Project CreateProject(this ICustomVisionTrainingClient operations, string name, string description = default(string), System.Guid? domainId = default(System.Guid?), string classificationType = default(string), IList<string> targetExportPlatforms = default(IList<string>), CreateProjectOptions options = default(CreateProjectOptions))
            {
                return operations.CreateProjectAsync(name, description, domainId, classificationType, targetExportPlatforms, options).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Create a project.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='name'>
            /// Name of the project.
            /// </param>
            /// <param name='description'>
            /// The description of the project.
            /// </param>
            /// <param name='domainId'>
            /// The id of the domain to use for this project. Defaults to General.
            /// </param>
            /// <param name='classificationType'>
            /// The type of classifier to create for this project. Possible values include:
            /// 'Multiclass', 'Multilabel'
            /// </param>
            /// <param name='targetExportPlatforms'>
            /// List of platforms the trained model is intending exporting to.
            /// </param>
            /// <param name='options'>
            /// Additional project creation options.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<Project> CreateProjectAsync(this ICustomVisionTrainingClient operations, string name, string description = default(string), System.Guid? domainId = default(System.Guid?), string classificationType = default(string), IList<string> targetExportPlatforms = default(IList<string>), CreateProjectOptions options = default(CreateProjectOptions), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.CreateProjectWithHttpMessagesAsync(name, description, domainId, classificationType, targetExportPlatforms, options, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Create a project.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='name'>
            /// Name of the project.
            /// </param>
            /// <param name='description'>
            /// The description of the project.
            /// </param>
            /// <param name='domainId'>
            /// The id of the domain to use for this project. Defaults to General.
            /// </param>
            /// <param name='classificationType'>
            /// The type of classifier to create for this project. Possible values include:
            /// 'Multiclass', 'Multilabel'
            /// </param>
            /// <param name='targetExportPlatforms'>
            /// List of platforms the trained model is intending exporting to.
            /// </param>
            /// <param name='options'>
            /// Additional project creation options.
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse<Project> CreateProjectWithHttpMessages(this ICustomVisionTrainingClient operations, string name, string description = default(string), System.Guid? domainId = default(System.Guid?), string classificationType = default(string), IList<string> targetExportPlatforms = default(IList<string>), CreateProjectOptions options = default(CreateProjectOptions), Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.CreateProjectWithHttpMessagesAsync(name, description, domainId, classificationType, targetExportPlatforms, options, customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Get a specific project.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The id of the project to get.
            /// </param>
            public static Project GetProject(this ICustomVisionTrainingClient operations, System.Guid projectId)
            {
                return operations.GetProjectAsync(projectId).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Get a specific project.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The id of the project to get.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<Project> GetProjectAsync(this ICustomVisionTrainingClient operations, System.Guid projectId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetProjectWithHttpMessagesAsync(projectId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Get a specific project.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The id of the project to get.
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse<Project> GetProjectWithHttpMessages(this ICustomVisionTrainingClient operations, System.Guid projectId, Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.GetProjectWithHttpMessagesAsync(projectId, customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Delete a specific project.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            public static void DeleteProject(this ICustomVisionTrainingClient operations, System.Guid projectId)
            {
                operations.DeleteProjectAsync(projectId).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Delete a specific project.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task DeleteProjectAsync(this ICustomVisionTrainingClient operations, System.Guid projectId, CancellationToken cancellationToken = default(CancellationToken))
            {
                (await operations.DeleteProjectWithHttpMessagesAsync(projectId, null, cancellationToken).ConfigureAwait(false)).Dispose();
            }

            /// <summary>
            /// Delete a specific project.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse DeleteProjectWithHttpMessages(this ICustomVisionTrainingClient operations, System.Guid projectId, Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.DeleteProjectWithHttpMessagesAsync(projectId, customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Update a specific project.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The id of the project to update.
            /// </param>
            /// <param name='updatedProject'>
            /// The updated project model.
            /// </param>
            public static Project UpdateProject(this ICustomVisionTrainingClient operations, System.Guid projectId, Project updatedProject)
            {
                return operations.UpdateProjectAsync(projectId, updatedProject).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Update a specific project.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The id of the project to update.
            /// </param>
            /// <param name='updatedProject'>
            /// The updated project model.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<Project> UpdateProjectAsync(this ICustomVisionTrainingClient operations, System.Guid projectId, Project updatedProject, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.UpdateProjectWithHttpMessagesAsync(projectId, updatedProject, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Update a specific project.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The id of the project to update.
            /// </param>
            /// <param name='updatedProject'>
            /// The updated project model.
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse<Project> UpdateProjectWithHttpMessages(this ICustomVisionTrainingClient operations, System.Guid projectId, Project updatedProject, Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.UpdateProjectWithHttpMessagesAsync(projectId, updatedProject, customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Get artifact content from blob storage, based on artifact relative path in
            /// the blob.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='path'>
            /// The relative path for artifact.
            /// </param>
            public static Stream GetArtifact(this ICustomVisionTrainingClient operations, System.Guid projectId, string path)
            {
                return operations.GetArtifactAsync(projectId, path).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Get artifact content from blob storage, based on artifact relative path in
            /// the blob.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='path'>
            /// The relative path for artifact.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<Stream> GetArtifactAsync(this ICustomVisionTrainingClient operations, System.Guid projectId, string path, CancellationToken cancellationToken = default(CancellationToken))
            {
                var _result = await operations.GetArtifactWithHttpMessagesAsync(projectId, path, null, cancellationToken).ConfigureAwait(false);
                _result.Request.Dispose();
                return _result.Body;
            }

            /// <summary>
            /// Get artifact content from blob storage, based on artifact relative path in
            /// the blob.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='path'>
            /// The relative path for artifact.
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse<Stream> GetArtifactWithHttpMessages(this ICustomVisionTrainingClient operations, System.Guid projectId, string path, Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.GetArtifactWithHttpMessagesAsync(projectId, path, customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Exports a project.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id of the project to export.
            /// </param>
            public static ProjectExport ExportProject(this ICustomVisionTrainingClient operations, System.Guid projectId)
            {
                return operations.ExportProjectAsync(projectId).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Exports a project.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id of the project to export.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<ProjectExport> ExportProjectAsync(this ICustomVisionTrainingClient operations, System.Guid projectId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ExportProjectWithHttpMessagesAsync(projectId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Exports a project.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id of the project to export.
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse<ProjectExport> ExportProjectWithHttpMessages(this ICustomVisionTrainingClient operations, System.Guid projectId, Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.ExportProjectWithHttpMessagesAsync(projectId, customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Get images for a given project iteration or workspace.
            /// </summary>
            /// <remarks>
            /// This API supports batching and range selection. By default it will only
            /// return first 50 images matching images.
            /// Use the {take} and {skip} parameters to control how many images to return
            /// in a given batch.
            /// The filtering is on an and/or relationship. For example, if the provided
            /// tag ids are for the "Dog" and
            /// "Cat" tags, then only images tagged with Dog and/or Cat will be returned
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='iterationId'>
            /// The iteration id. Defaults to workspace.
            /// </param>
            /// <param name='tagIds'>
            /// A list of tags ids to filter the images. Defaults to all tagged images when
            /// null. Limited to 20.
            /// </param>
            /// <param name='taggingStatus'>
            /// The tagging status filter. It can be 'All', 'Tagged', or 'Untagged'.
            /// Defaults to 'All'. Possible values include: 'All', 'Tagged', 'Untagged'
            /// </param>
            /// <param name='filter'>
            /// An expression to filter the images against image metadata. Only images
            /// where the expression evaluates to true are included in the response.
            /// The expression supports eq (Equal), ne (Not equal), and (Logical and), or
            /// (Logical or) operators.
            /// Here is an example, metadata=key1 eq 'value1' and key2 ne 'value2'.
            /// </param>
            /// <param name='orderBy'>
            /// The ordering. Defaults to newest. Possible values include: 'Newest',
            /// 'Oldest'
            /// </param>
            /// <param name='take'>
            /// Maximum number of images to return. Defaults to 50, limited to 256.
            /// </param>
            /// <param name='skip'>
            /// Number of images to skip before beginning the image batch. Defaults to 0.
            /// </param>
            public static IList<Image> GetImages(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid? iterationId = default(System.Guid?), IList<System.Guid> tagIds = default(IList<System.Guid>), string taggingStatus = default(string), string filter = default(string), string orderBy = default(string), int? take = 50, int? skip = 0)
            {
                return operations.GetImagesAsync(projectId, iterationId, tagIds, taggingStatus, filter, orderBy, take, skip).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Get images for a given project iteration or workspace.
            /// </summary>
            /// <remarks>
            /// This API supports batching and range selection. By default it will only
            /// return first 50 images matching images.
            /// Use the {take} and {skip} parameters to control how many images to return
            /// in a given batch.
            /// The filtering is on an and/or relationship. For example, if the provided
            /// tag ids are for the "Dog" and
            /// "Cat" tags, then only images tagged with Dog and/or Cat will be returned
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='iterationId'>
            /// The iteration id. Defaults to workspace.
            /// </param>
            /// <param name='tagIds'>
            /// A list of tags ids to filter the images. Defaults to all tagged images when
            /// null. Limited to 20.
            /// </param>
            /// <param name='taggingStatus'>
            /// The tagging status filter. It can be 'All', 'Tagged', or 'Untagged'.
            /// Defaults to 'All'. Possible values include: 'All', 'Tagged', 'Untagged'
            /// </param>
            /// <param name='filter'>
            /// An expression to filter the images against image metadata. Only images
            /// where the expression evaluates to true are included in the response.
            /// The expression supports eq (Equal), ne (Not equal), and (Logical and), or
            /// (Logical or) operators.
            /// Here is an example, metadata=key1 eq 'value1' and key2 ne 'value2'.
            /// </param>
            /// <param name='orderBy'>
            /// The ordering. Defaults to newest. Possible values include: 'Newest',
            /// 'Oldest'
            /// </param>
            /// <param name='take'>
            /// Maximum number of images to return. Defaults to 50, limited to 256.
            /// </param>
            /// <param name='skip'>
            /// Number of images to skip before beginning the image batch. Defaults to 0.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IList<Image>> GetImagesAsync(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid? iterationId = default(System.Guid?), IList<System.Guid> tagIds = default(IList<System.Guid>), string taggingStatus = default(string), string filter = default(string), string orderBy = default(string), int? take = 50, int? skip = 0, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetImagesWithHttpMessagesAsync(projectId, iterationId, tagIds, taggingStatus, filter, orderBy, take, skip, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Get images for a given project iteration or workspace.
            /// </summary>
            /// <remarks>
            /// This API supports batching and range selection. By default it will only
            /// return first 50 images matching images.
            /// Use the {take} and {skip} parameters to control how many images to return
            /// in a given batch.
            /// The filtering is on an and/or relationship. For example, if the provided
            /// tag ids are for the "Dog" and
            /// "Cat" tags, then only images tagged with Dog and/or Cat will be returned
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='iterationId'>
            /// The iteration id. Defaults to workspace.
            /// </param>
            /// <param name='tagIds'>
            /// A list of tags ids to filter the images. Defaults to all tagged images when
            /// null. Limited to 20.
            /// </param>
            /// <param name='taggingStatus'>
            /// The tagging status filter. It can be 'All', 'Tagged', or 'Untagged'.
            /// Defaults to 'All'. Possible values include: 'All', 'Tagged', 'Untagged'
            /// </param>
            /// <param name='filter'>
            /// An expression to filter the images against image metadata. Only images
            /// where the expression evaluates to true are included in the response.
            /// The expression supports eq (Equal), ne (Not equal), and (Logical and), or
            /// (Logical or) operators.
            /// Here is an example, metadata=key1 eq 'value1' and key2 ne 'value2'.
            /// </param>
            /// <param name='orderBy'>
            /// The ordering. Defaults to newest. Possible values include: 'Newest',
            /// 'Oldest'
            /// </param>
            /// <param name='take'>
            /// Maximum number of images to return. Defaults to 50, limited to 256.
            /// </param>
            /// <param name='skip'>
            /// Number of images to skip before beginning the image batch. Defaults to 0.
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse<IList<Image>> GetImagesWithHttpMessages(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid? iterationId = default(System.Guid?), IList<System.Guid> tagIds = default(IList<System.Guid>), string taggingStatus = default(string), string filter = default(string), string orderBy = default(string), int? take = 50, int? skip = 0, Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.GetImagesWithHttpMessagesAsync(projectId, iterationId, tagIds, taggingStatus, filter, orderBy, take, skip, customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Add the provided images to the set of training images.
            /// </summary>
            /// <remarks>
            /// This API accepts body content as multipart/form-data and
            /// application/octet-stream. When using multipart
            /// multiple image files can be sent at once, with a maximum of 64 files.
            /// If all images are successful created, 200(OK) status code will be returned.
            /// Otherwise, 207 (Multi-Status) status code will be returned and detail
            /// status for each image will be listed in the response payload.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='imageData'>
            /// Binary image data. Supported formats are JPEG, GIF, PNG, and BMP. Supports
            /// images up to 6MB.
            /// </param>
            /// <param name='tagIds'>
            /// The tags ids with which to tag each image. Limited to 20.
            /// </param>
            public static ImageCreateSummary CreateImagesFromData(this ICustomVisionTrainingClient operations, System.Guid projectId, Stream imageData, IList<System.Guid> tagIds = default(IList<System.Guid>))
            {
                return operations.CreateImagesFromDataAsync(projectId, imageData, tagIds).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Add the provided images to the set of training images.
            /// </summary>
            /// <remarks>
            /// This API accepts body content as multipart/form-data and
            /// application/octet-stream. When using multipart
            /// multiple image files can be sent at once, with a maximum of 64 files.
            /// If all images are successful created, 200(OK) status code will be returned.
            /// Otherwise, 207 (Multi-Status) status code will be returned and detail
            /// status for each image will be listed in the response payload.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='imageData'>
            /// Binary image data. Supported formats are JPEG, GIF, PNG, and BMP. Supports
            /// images up to 6MB.
            /// </param>
            /// <param name='tagIds'>
            /// The tags ids with which to tag each image. Limited to 20.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<ImageCreateSummary> CreateImagesFromDataAsync(this ICustomVisionTrainingClient operations, System.Guid projectId, Stream imageData, IList<System.Guid> tagIds = default(IList<System.Guid>), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.CreateImagesFromDataWithHttpMessagesAsync(projectId, imageData, tagIds, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Add the provided images to the set of training images.
            /// </summary>
            /// <remarks>
            /// This API accepts body content as multipart/form-data and
            /// application/octet-stream. When using multipart
            /// multiple image files can be sent at once, with a maximum of 64 files.
            /// If all images are successful created, 200(OK) status code will be returned.
            /// Otherwise, 207 (Multi-Status) status code will be returned and detail
            /// status for each image will be listed in the response payload.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='imageData'>
            /// Binary image data. Supported formats are JPEG, GIF, PNG, and BMP. Supports
            /// images up to 6MB.
            /// </param>
            /// <param name='tagIds'>
            /// The tags ids with which to tag each image. Limited to 20.
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse<ImageCreateSummary> CreateImagesFromDataWithHttpMessages(this ICustomVisionTrainingClient operations, System.Guid projectId, Stream imageData, IList<System.Guid> tagIds = default(IList<System.Guid>), Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.CreateImagesFromDataWithHttpMessagesAsync(projectId, imageData, tagIds, customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Delete images from the set of training images.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='imageIds'>
            /// Ids of the images to be deleted. Limited to 256 images per batch.
            /// </param>
            /// <param name='allImages'>
            /// Flag to specify delete all images, specify this flag or a list of images.
            /// Using this flag will return a 202 response to indicate the images are being
            /// deleted.
            /// </param>
            /// <param name='allIterations'>
            /// Removes these images from all iterations, not just the current workspace.
            /// Using this flag will return a 202 response to indicate the images are being
            /// deleted.
            /// </param>
            public static void DeleteImages(this ICustomVisionTrainingClient operations, System.Guid projectId, IList<System.Guid> imageIds = default(IList<System.Guid>), bool? allImages = default(bool?), bool? allIterations = default(bool?))
            {
                operations.DeleteImagesAsync(projectId, imageIds, allImages, allIterations).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Delete images from the set of training images.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='imageIds'>
            /// Ids of the images to be deleted. Limited to 256 images per batch.
            /// </param>
            /// <param name='allImages'>
            /// Flag to specify delete all images, specify this flag or a list of images.
            /// Using this flag will return a 202 response to indicate the images are being
            /// deleted.
            /// </param>
            /// <param name='allIterations'>
            /// Removes these images from all iterations, not just the current workspace.
            /// Using this flag will return a 202 response to indicate the images are being
            /// deleted.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task DeleteImagesAsync(this ICustomVisionTrainingClient operations, System.Guid projectId, IList<System.Guid> imageIds = default(IList<System.Guid>), bool? allImages = default(bool?), bool? allIterations = default(bool?), CancellationToken cancellationToken = default(CancellationToken))
            {
                (await operations.DeleteImagesWithHttpMessagesAsync(projectId, imageIds, allImages, allIterations, null, cancellationToken).ConfigureAwait(false)).Dispose();
            }

            /// <summary>
            /// Delete images from the set of training images.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='imageIds'>
            /// Ids of the images to be deleted. Limited to 256 images per batch.
            /// </param>
            /// <param name='allImages'>
            /// Flag to specify delete all images, specify this flag or a list of images.
            /// Using this flag will return a 202 response to indicate the images are being
            /// deleted.
            /// </param>
            /// <param name='allIterations'>
            /// Removes these images from all iterations, not just the current workspace.
            /// Using this flag will return a 202 response to indicate the images are being
            /// deleted.
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse DeleteImagesWithHttpMessages(this ICustomVisionTrainingClient operations, System.Guid projectId, IList<System.Guid> imageIds = default(IList<System.Guid>), bool? allImages = default(bool?), bool? allIterations = default(bool?), Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.DeleteImagesWithHttpMessagesAsync(projectId, imageIds, allImages, allIterations, customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Get region proposals for an image. Returns empty array if no proposals are
            /// found.
            /// </summary>
            /// <remarks>
            /// This API will get region proposals for an image along with confidences for
            /// the region. It returns an empty array if no proposals are found.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='imageId'>
            /// The image id.
            /// </param>
            public static ImageRegionProposal GetImageRegionProposals(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid imageId)
            {
                return operations.GetImageRegionProposalsAsync(projectId, imageId).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Get region proposals for an image. Returns empty array if no proposals are
            /// found.
            /// </summary>
            /// <remarks>
            /// This API will get region proposals for an image along with confidences for
            /// the region. It returns an empty array if no proposals are found.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='imageId'>
            /// The image id.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<ImageRegionProposal> GetImageRegionProposalsAsync(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid imageId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetImageRegionProposalsWithHttpMessagesAsync(projectId, imageId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Get region proposals for an image. Returns empty array if no proposals are
            /// found.
            /// </summary>
            /// <remarks>
            /// This API will get region proposals for an image along with confidences for
            /// the region. It returns an empty array if no proposals are found.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='imageId'>
            /// The image id.
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse<ImageRegionProposal> GetImageRegionProposalsWithHttpMessages(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid imageId, Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.GetImageRegionProposalsWithHttpMessagesAsync(projectId, imageId, customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Get the number of images.
            /// </summary>
            /// <remarks>
            /// The filtering is on an and/or relationship. For example, if the provided
            /// tag ids are for the "Dog" and
            /// "Cat" tags, then only images tagged with Dog and/or Cat will be returned
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='iterationId'>
            /// The iteration id. Defaults to workspace.
            /// </param>
            /// <param name='taggingStatus'>
            /// The tagging status filter. It can be 'All', 'Tagged', or 'Untagged'.
            /// Defaults to 'All'. Possible values include: 'All', 'Tagged', 'Untagged'
            /// </param>
            /// <param name='filter'>
            /// An expression to filter the images against image metadata. Only images
            /// where the expression evaluates to true are included in the response.
            /// The expression supports eq (Equal), ne (Not equal), and (Logical and), or
            /// (Logical or) operators.
            /// Here is an example, metadata=key1 eq 'value1' and key2 ne 'value2'.
            /// </param>
            /// <param name='tagIds'>
            /// A list of tags ids to filter the images to count. Defaults to all tags when
            /// null.
            /// </param>
            public static int? GetImageCount(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid? iterationId = default(System.Guid?), string taggingStatus = default(string), string filter = default(string), IList<System.Guid> tagIds = default(IList<System.Guid>))
            {
                return operations.GetImageCountAsync(projectId, iterationId, taggingStatus, filter, tagIds).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Get the number of images.
            /// </summary>
            /// <remarks>
            /// The filtering is on an and/or relationship. For example, if the provided
            /// tag ids are for the "Dog" and
            /// "Cat" tags, then only images tagged with Dog and/or Cat will be returned
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='iterationId'>
            /// The iteration id. Defaults to workspace.
            /// </param>
            /// <param name='taggingStatus'>
            /// The tagging status filter. It can be 'All', 'Tagged', or 'Untagged'.
            /// Defaults to 'All'. Possible values include: 'All', 'Tagged', 'Untagged'
            /// </param>
            /// <param name='filter'>
            /// An expression to filter the images against image metadata. Only images
            /// where the expression evaluates to true are included in the response.
            /// The expression supports eq (Equal), ne (Not equal), and (Logical and), or
            /// (Logical or) operators.
            /// Here is an example, metadata=key1 eq 'value1' and key2 ne 'value2'.
            /// </param>
            /// <param name='tagIds'>
            /// A list of tags ids to filter the images to count. Defaults to all tags when
            /// null.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<int?> GetImageCountAsync(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid? iterationId = default(System.Guid?), string taggingStatus = default(string), string filter = default(string), IList<System.Guid> tagIds = default(IList<System.Guid>), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetImageCountWithHttpMessagesAsync(projectId, iterationId, taggingStatus, filter, tagIds, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Get the number of images.
            /// </summary>
            /// <remarks>
            /// The filtering is on an and/or relationship. For example, if the provided
            /// tag ids are for the "Dog" and
            /// "Cat" tags, then only images tagged with Dog and/or Cat will be returned
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='iterationId'>
            /// The iteration id. Defaults to workspace.
            /// </param>
            /// <param name='taggingStatus'>
            /// The tagging status filter. It can be 'All', 'Tagged', or 'Untagged'.
            /// Defaults to 'All'. Possible values include: 'All', 'Tagged', 'Untagged'
            /// </param>
            /// <param name='filter'>
            /// An expression to filter the images against image metadata. Only images
            /// where the expression evaluates to true are included in the response.
            /// The expression supports eq (Equal), ne (Not equal), and (Logical and), or
            /// (Logical or) operators.
            /// Here is an example, metadata=key1 eq 'value1' and key2 ne 'value2'.
            /// </param>
            /// <param name='tagIds'>
            /// A list of tags ids to filter the images to count. Defaults to all tags when
            /// null.
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse<int?> GetImageCountWithHttpMessages(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid? iterationId = default(System.Guid?), string taggingStatus = default(string), string filter = default(string), IList<System.Guid> tagIds = default(IList<System.Guid>), Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.GetImageCountWithHttpMessagesAsync(projectId, iterationId, taggingStatus, filter, tagIds, customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Add the provided batch of images to the set of training images.
            /// </summary>
            /// <remarks>
            /// This API accepts a batch of files, and optionally tags, to create images.
            /// There is a limit of 64 images and 20 tags.
            /// If all images are successful created, 200(OK) status code will be returned.
            /// Otherwise, 207 (Multi-Status) status code will be returned and detail
            /// status for each image will be listed in the response payload.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='batch'>
            /// The batch of image files to add. Limited to 64 images and 20 tags per
            /// batch.
            /// </param>
            public static ImageCreateSummary CreateImagesFromFiles(this ICustomVisionTrainingClient operations, System.Guid projectId, ImageFileCreateBatch batch)
            {
                return operations.CreateImagesFromFilesAsync(projectId, batch).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Add the provided batch of images to the set of training images.
            /// </summary>
            /// <remarks>
            /// This API accepts a batch of files, and optionally tags, to create images.
            /// There is a limit of 64 images and 20 tags.
            /// If all images are successful created, 200(OK) status code will be returned.
            /// Otherwise, 207 (Multi-Status) status code will be returned and detail
            /// status for each image will be listed in the response payload.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='batch'>
            /// The batch of image files to add. Limited to 64 images and 20 tags per
            /// batch.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<ImageCreateSummary> CreateImagesFromFilesAsync(this ICustomVisionTrainingClient operations, System.Guid projectId, ImageFileCreateBatch batch, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.CreateImagesFromFilesWithHttpMessagesAsync(projectId, batch, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Add the provided batch of images to the set of training images.
            /// </summary>
            /// <remarks>
            /// This API accepts a batch of files, and optionally tags, to create images.
            /// There is a limit of 64 images and 20 tags.
            /// If all images are successful created, 200(OK) status code will be returned.
            /// Otherwise, 207 (Multi-Status) status code will be returned and detail
            /// status for each image will be listed in the response payload.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='batch'>
            /// The batch of image files to add. Limited to 64 images and 20 tags per
            /// batch.
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse<ImageCreateSummary> CreateImagesFromFilesWithHttpMessages(this ICustomVisionTrainingClient operations, System.Guid projectId, ImageFileCreateBatch batch, Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.CreateImagesFromFilesWithHttpMessagesAsync(projectId, batch, customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Get images by id for a given project iteration.
            /// </summary>
            /// <remarks>
            /// This API will return a set of Images for the specified tags and optionally
            /// iteration. If no iteration is specified the
            /// current workspace is used.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='imageIds'>
            /// The list of image ids to retrieve. Limited to 256.
            /// </param>
            /// <param name='iterationId'>
            /// The iteration id. Defaults to workspace.
            /// </param>
            public static IList<Image> GetImagesByIds(this ICustomVisionTrainingClient operations, System.Guid projectId, IList<System.Guid> imageIds = default(IList<System.Guid>), System.Guid? iterationId = default(System.Guid?))
            {
                return operations.GetImagesByIdsAsync(projectId, imageIds, iterationId).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Get images by id for a given project iteration.
            /// </summary>
            /// <remarks>
            /// This API will return a set of Images for the specified tags and optionally
            /// iteration. If no iteration is specified the
            /// current workspace is used.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='imageIds'>
            /// The list of image ids to retrieve. Limited to 256.
            /// </param>
            /// <param name='iterationId'>
            /// The iteration id. Defaults to workspace.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IList<Image>> GetImagesByIdsAsync(this ICustomVisionTrainingClient operations, System.Guid projectId, IList<System.Guid> imageIds = default(IList<System.Guid>), System.Guid? iterationId = default(System.Guid?), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetImagesByIdsWithHttpMessagesAsync(projectId, imageIds, iterationId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Get images by id for a given project iteration.
            /// </summary>
            /// <remarks>
            /// This API will return a set of Images for the specified tags and optionally
            /// iteration. If no iteration is specified the
            /// current workspace is used.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='imageIds'>
            /// The list of image ids to retrieve. Limited to 256.
            /// </param>
            /// <param name='iterationId'>
            /// The iteration id. Defaults to workspace.
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse<IList<Image>> GetImagesByIdsWithHttpMessages(this ICustomVisionTrainingClient operations, System.Guid projectId, IList<System.Guid> imageIds = default(IList<System.Guid>), System.Guid? iterationId = default(System.Guid?), Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.GetImagesByIdsWithHttpMessagesAsync(projectId, imageIds, iterationId, customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Update metadata of images.
            /// </summary>
            /// <remarks>
            /// This API accepts a batch of image Ids, and metadata, to update images.
            /// There is a limit of 64 images.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='imageIds'>
            /// The list of image ids to update. Limited to 64.
            /// </param>
            /// <param name='metadata'>
            /// The metadata to be updated to the specified images. Limited to 10 key-value
            /// pairs per image. The length of key is limited to 128. The length of value
            /// is limited to 256.
            /// </param>
            public static ImageMetadataUpdateSummary UpdateImageMetadata(this ICustomVisionTrainingClient operations, System.Guid projectId, IList<System.Guid> imageIds, IDictionary<string, string> metadata)
            {
                return operations.UpdateImageMetadataAsync(projectId, imageIds, metadata).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Update metadata of images.
            /// </summary>
            /// <remarks>
            /// This API accepts a batch of image Ids, and metadata, to update images.
            /// There is a limit of 64 images.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='imageIds'>
            /// The list of image ids to update. Limited to 64.
            /// </param>
            /// <param name='metadata'>
            /// The metadata to be updated to the specified images. Limited to 10 key-value
            /// pairs per image. The length of key is limited to 128. The length of value
            /// is limited to 256.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<ImageMetadataUpdateSummary> UpdateImageMetadataAsync(this ICustomVisionTrainingClient operations, System.Guid projectId, IList<System.Guid> imageIds, IDictionary<string, string> metadata, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.UpdateImageMetadataWithHttpMessagesAsync(projectId, imageIds, metadata, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Update metadata of images.
            /// </summary>
            /// <remarks>
            /// This API accepts a batch of image Ids, and metadata, to update images.
            /// There is a limit of 64 images.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='imageIds'>
            /// The list of image ids to update. Limited to 64.
            /// </param>
            /// <param name='metadata'>
            /// The metadata to be updated to the specified images. Limited to 10 key-value
            /// pairs per image. The length of key is limited to 128. The length of value
            /// is limited to 256.
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse<ImageMetadataUpdateSummary> UpdateImageMetadataWithHttpMessages(this ICustomVisionTrainingClient operations, System.Guid projectId, IList<System.Guid> imageIds, IDictionary<string, string> metadata, Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.UpdateImageMetadataWithHttpMessagesAsync(projectId, imageIds, metadata, customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Add the specified predicted images to the set of training images.
            /// </summary>
            /// <remarks>
            /// This API creates a batch of images from predicted images specified. There
            /// is a limit of 64 images and 20 tags.
            /// If all images are successful created, 200(OK) status code will be returned.
            /// Otherwise, 207 (Multi-Status) status code will be returned and detail
            /// status for each image will be listed in the response payload.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='batch'>
            /// Image, tag ids, and metadata. Limited to 64 images and 20 tags per batch.
            /// </param>
            public static ImageCreateSummary CreateImagesFromPredictions(this ICustomVisionTrainingClient operations, System.Guid projectId, ImageIdCreateBatch batch)
            {
                return operations.CreateImagesFromPredictionsAsync(projectId, batch).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Add the specified predicted images to the set of training images.
            /// </summary>
            /// <remarks>
            /// This API creates a batch of images from predicted images specified. There
            /// is a limit of 64 images and 20 tags.
            /// If all images are successful created, 200(OK) status code will be returned.
            /// Otherwise, 207 (Multi-Status) status code will be returned and detail
            /// status for each image will be listed in the response payload.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='batch'>
            /// Image, tag ids, and metadata. Limited to 64 images and 20 tags per batch.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<ImageCreateSummary> CreateImagesFromPredictionsAsync(this ICustomVisionTrainingClient operations, System.Guid projectId, ImageIdCreateBatch batch, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.CreateImagesFromPredictionsWithHttpMessagesAsync(projectId, batch, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Add the specified predicted images to the set of training images.
            /// </summary>
            /// <remarks>
            /// This API creates a batch of images from predicted images specified. There
            /// is a limit of 64 images and 20 tags.
            /// If all images are successful created, 200(OK) status code will be returned.
            /// Otherwise, 207 (Multi-Status) status code will be returned and detail
            /// status for each image will be listed in the response payload.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='batch'>
            /// Image, tag ids, and metadata. Limited to 64 images and 20 tags per batch.
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse<ImageCreateSummary> CreateImagesFromPredictionsWithHttpMessages(this ICustomVisionTrainingClient operations, System.Guid projectId, ImageIdCreateBatch batch, Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.CreateImagesFromPredictionsWithHttpMessagesAsync(projectId, batch, customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Create a set of image regions.
            /// </summary>
            /// <remarks>
            /// This API accepts a batch of image regions, and optionally tags, to update
            /// existing images with region information.
            /// There is a limit of 64 entries in the batch.
            /// If all regions are successful created, 200(OK) status code will be
            /// returned.
            /// Otherwise, 207 (Multi-Status) status code will be returned and detail
            /// status for each region will be listed in the response payload.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='batch'>
            /// Batch of image regions which include a tag and bounding box. Limited to 64.
            /// </param>
            public static ImageRegionCreateSummary CreateImageRegions(this ICustomVisionTrainingClient operations, System.Guid projectId, ImageRegionCreateBatch batch)
            {
                return operations.CreateImageRegionsAsync(projectId, batch).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Create a set of image regions.
            /// </summary>
            /// <remarks>
            /// This API accepts a batch of image regions, and optionally tags, to update
            /// existing images with region information.
            /// There is a limit of 64 entries in the batch.
            /// If all regions are successful created, 200(OK) status code will be
            /// returned.
            /// Otherwise, 207 (Multi-Status) status code will be returned and detail
            /// status for each region will be listed in the response payload.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='batch'>
            /// Batch of image regions which include a tag and bounding box. Limited to 64.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<ImageRegionCreateSummary> CreateImageRegionsAsync(this ICustomVisionTrainingClient operations, System.Guid projectId, ImageRegionCreateBatch batch, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.CreateImageRegionsWithHttpMessagesAsync(projectId, batch, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Create a set of image regions.
            /// </summary>
            /// <remarks>
            /// This API accepts a batch of image regions, and optionally tags, to update
            /// existing images with region information.
            /// There is a limit of 64 entries in the batch.
            /// If all regions are successful created, 200(OK) status code will be
            /// returned.
            /// Otherwise, 207 (Multi-Status) status code will be returned and detail
            /// status for each region will be listed in the response payload.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='batch'>
            /// Batch of image regions which include a tag and bounding box. Limited to 64.
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse<ImageRegionCreateSummary> CreateImageRegionsWithHttpMessages(this ICustomVisionTrainingClient operations, System.Guid projectId, ImageRegionCreateBatch batch, Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.CreateImageRegionsWithHttpMessagesAsync(projectId, batch, customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Delete a set of image regions.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='regionIds'>
            /// Regions to delete. Limited to 64.
            /// </param>
            public static void DeleteImageRegions(this ICustomVisionTrainingClient operations, System.Guid projectId, IList<System.Guid> regionIds)
            {
                operations.DeleteImageRegionsAsync(projectId, regionIds).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Delete a set of image regions.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='regionIds'>
            /// Regions to delete. Limited to 64.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task DeleteImageRegionsAsync(this ICustomVisionTrainingClient operations, System.Guid projectId, IList<System.Guid> regionIds, CancellationToken cancellationToken = default(CancellationToken))
            {
                (await operations.DeleteImageRegionsWithHttpMessagesAsync(projectId, regionIds, null, cancellationToken).ConfigureAwait(false)).Dispose();
            }

            /// <summary>
            /// Delete a set of image regions.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='regionIds'>
            /// Regions to delete. Limited to 64.
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse DeleteImageRegionsWithHttpMessages(this ICustomVisionTrainingClient operations, System.Guid projectId, IList<System.Guid> regionIds, Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.DeleteImageRegionsWithHttpMessagesAsync(projectId, regionIds, customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Get untagged images whose suggested tags match given tags. Returns empty
            /// array if no images are found.
            /// </summary>
            /// <remarks>
            /// This API will fetch untagged images filtered by suggested tags Ids. It
            /// returns an empty array if no images are found.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='iterationId'>
            /// IterationId to use for the suggested tags and regions.
            /// </param>
            /// <param name='query'>
            /// Contains properties we need to query suggested images.
            /// </param>
            public static SuggestedTagAndRegionQuery QuerySuggestedImages(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid iterationId, SuggestedTagAndRegionQueryToken query)
            {
                return operations.QuerySuggestedImagesAsync(projectId, iterationId, query).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Get untagged images whose suggested tags match given tags. Returns empty
            /// array if no images are found.
            /// </summary>
            /// <remarks>
            /// This API will fetch untagged images filtered by suggested tags Ids. It
            /// returns an empty array if no images are found.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='iterationId'>
            /// IterationId to use for the suggested tags and regions.
            /// </param>
            /// <param name='query'>
            /// Contains properties we need to query suggested images.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<SuggestedTagAndRegionQuery> QuerySuggestedImagesAsync(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid iterationId, SuggestedTagAndRegionQueryToken query, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.QuerySuggestedImagesWithHttpMessagesAsync(projectId, iterationId, query, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Get untagged images whose suggested tags match given tags. Returns empty
            /// array if no images are found.
            /// </summary>
            /// <remarks>
            /// This API will fetch untagged images filtered by suggested tags Ids. It
            /// returns an empty array if no images are found.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='iterationId'>
            /// IterationId to use for the suggested tags and regions.
            /// </param>
            /// <param name='query'>
            /// Contains properties we need to query suggested images.
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse<SuggestedTagAndRegionQuery> QuerySuggestedImagesWithHttpMessages(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid iterationId, SuggestedTagAndRegionQueryToken query, Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.QuerySuggestedImagesWithHttpMessagesAsync(projectId, iterationId, query, customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Get count of images whose suggested tags match given tags and their
            /// probabilities are greater than or equal to the given threshold. Returns
            /// count as 0 if none found.
            /// </summary>
            /// <remarks>
            /// This API takes in tagIds to get count of untagged images per suggested tags
            /// for a given threshold.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='iterationId'>
            /// IterationId to use for the suggested tags and regions.
            /// </param>
            /// <param name='query'>
            /// Model that contains tagIds, threshold and projectType to query by.
            /// </param>
            public static IDictionary<string, int?> QuerySuggestedImageCount(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid iterationId, TagFilter query)
            {
                return operations.QuerySuggestedImageCountAsync(projectId, iterationId, query).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Get count of images whose suggested tags match given tags and their
            /// probabilities are greater than or equal to the given threshold. Returns
            /// count as 0 if none found.
            /// </summary>
            /// <remarks>
            /// This API takes in tagIds to get count of untagged images per suggested tags
            /// for a given threshold.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='iterationId'>
            /// IterationId to use for the suggested tags and regions.
            /// </param>
            /// <param name='query'>
            /// Model that contains tagIds, threshold and projectType to query by.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IDictionary<string, int?>> QuerySuggestedImageCountAsync(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid iterationId, TagFilter query, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.QuerySuggestedImageCountWithHttpMessagesAsync(projectId, iterationId, query, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Get count of images whose suggested tags match given tags and their
            /// probabilities are greater than or equal to the given threshold. Returns
            /// count as 0 if none found.
            /// </summary>
            /// <remarks>
            /// This API takes in tagIds to get count of untagged images per suggested tags
            /// for a given threshold.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='iterationId'>
            /// IterationId to use for the suggested tags and regions.
            /// </param>
            /// <param name='query'>
            /// Model that contains tagIds, threshold and projectType to query by.
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse<IDictionary<string, int?>> QuerySuggestedImageCountWithHttpMessages(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid iterationId, TagFilter query, Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.QuerySuggestedImageCountWithHttpMessagesAsync(projectId, iterationId, query, customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Get tagged images for a given project iteration.
            /// </summary>
            /// <remarks>
            /// This API supports batching and range selection. By default it will only
            /// return first 50 images matching images.
            /// Use the {take} and {skip} parameters to control how many images to return
            /// in a given batch.
            /// The filtering is on an and/or relationship. For example, if the provided
            /// tag ids are for the "Dog" and
            /// "Cat" tags, then only images tagged with Dog and/or Cat will be returned
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='iterationId'>
            /// The iteration id. Defaults to workspace.
            /// </param>
            /// <param name='tagIds'>
            /// A list of tags ids to filter the images. Defaults to all tagged images when
            /// null. Limited to 20.
            /// </param>
            /// <param name='orderBy'>
            /// The ordering. Defaults to newest. Possible values include: 'Newest',
            /// 'Oldest'
            /// </param>
            /// <param name='take'>
            /// Maximum number of images to return. Defaults to 50, limited to 256.
            /// </param>
            /// <param name='skip'>
            /// Number of images to skip before beginning the image batch. Defaults to 0.
            /// </param>
            public static IList<Image> GetTaggedImages(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid? iterationId = default(System.Guid?), IList<System.Guid> tagIds = default(IList<System.Guid>), string orderBy = default(string), int? take = 50, int? skip = 0)
            {
                return operations.GetTaggedImagesAsync(projectId, iterationId, tagIds, orderBy, take, skip).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Get tagged images for a given project iteration.
            /// </summary>
            /// <remarks>
            /// This API supports batching and range selection. By default it will only
            /// return first 50 images matching images.
            /// Use the {take} and {skip} parameters to control how many images to return
            /// in a given batch.
            /// The filtering is on an and/or relationship. For example, if the provided
            /// tag ids are for the "Dog" and
            /// "Cat" tags, then only images tagged with Dog and/or Cat will be returned
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='iterationId'>
            /// The iteration id. Defaults to workspace.
            /// </param>
            /// <param name='tagIds'>
            /// A list of tags ids to filter the images. Defaults to all tagged images when
            /// null. Limited to 20.
            /// </param>
            /// <param name='orderBy'>
            /// The ordering. Defaults to newest. Possible values include: 'Newest',
            /// 'Oldest'
            /// </param>
            /// <param name='take'>
            /// Maximum number of images to return. Defaults to 50, limited to 256.
            /// </param>
            /// <param name='skip'>
            /// Number of images to skip before beginning the image batch. Defaults to 0.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IList<Image>> GetTaggedImagesAsync(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid? iterationId = default(System.Guid?), IList<System.Guid> tagIds = default(IList<System.Guid>), string orderBy = default(string), int? take = 50, int? skip = 0, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetTaggedImagesWithHttpMessagesAsync(projectId, iterationId, tagIds, orderBy, take, skip, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Get tagged images for a given project iteration.
            /// </summary>
            /// <remarks>
            /// This API supports batching and range selection. By default it will only
            /// return first 50 images matching images.
            /// Use the {take} and {skip} parameters to control how many images to return
            /// in a given batch.
            /// The filtering is on an and/or relationship. For example, if the provided
            /// tag ids are for the "Dog" and
            /// "Cat" tags, then only images tagged with Dog and/or Cat will be returned
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='iterationId'>
            /// The iteration id. Defaults to workspace.
            /// </param>
            /// <param name='tagIds'>
            /// A list of tags ids to filter the images. Defaults to all tagged images when
            /// null. Limited to 20.
            /// </param>
            /// <param name='orderBy'>
            /// The ordering. Defaults to newest. Possible values include: 'Newest',
            /// 'Oldest'
            /// </param>
            /// <param name='take'>
            /// Maximum number of images to return. Defaults to 50, limited to 256.
            /// </param>
            /// <param name='skip'>
            /// Number of images to skip before beginning the image batch. Defaults to 0.
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse<IList<Image>> GetTaggedImagesWithHttpMessages(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid? iterationId = default(System.Guid?), IList<System.Guid> tagIds = default(IList<System.Guid>), string orderBy = default(string), int? take = 50, int? skip = 0, Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.GetTaggedImagesWithHttpMessagesAsync(projectId, iterationId, tagIds, orderBy, take, skip, customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Gets the number of images tagged with the provided {tagIds}.
            /// </summary>
            /// <remarks>
            /// The filtering is on an and/or relationship. For example, if the provided
            /// tag ids are for the "Dog" and
            /// "Cat" tags, then only images tagged with Dog and/or Cat will be returned
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='iterationId'>
            /// The iteration id. Defaults to workspace.
            /// </param>
            /// <param name='tagIds'>
            /// A list of tags ids to filter the images to count. Defaults to all tags when
            /// null.
            /// </param>
            public static int? GetTaggedImageCount(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid? iterationId = default(System.Guid?), IList<System.Guid> tagIds = default(IList<System.Guid>))
            {
                return operations.GetTaggedImageCountAsync(projectId, iterationId, tagIds).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Gets the number of images tagged with the provided {tagIds}.
            /// </summary>
            /// <remarks>
            /// The filtering is on an and/or relationship. For example, if the provided
            /// tag ids are for the "Dog" and
            /// "Cat" tags, then only images tagged with Dog and/or Cat will be returned
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='iterationId'>
            /// The iteration id. Defaults to workspace.
            /// </param>
            /// <param name='tagIds'>
            /// A list of tags ids to filter the images to count. Defaults to all tags when
            /// null.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<int?> GetTaggedImageCountAsync(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid? iterationId = default(System.Guid?), IList<System.Guid> tagIds = default(IList<System.Guid>), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetTaggedImageCountWithHttpMessagesAsync(projectId, iterationId, tagIds, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Gets the number of images tagged with the provided {tagIds}.
            /// </summary>
            /// <remarks>
            /// The filtering is on an and/or relationship. For example, if the provided
            /// tag ids are for the "Dog" and
            /// "Cat" tags, then only images tagged with Dog and/or Cat will be returned
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='iterationId'>
            /// The iteration id. Defaults to workspace.
            /// </param>
            /// <param name='tagIds'>
            /// A list of tags ids to filter the images to count. Defaults to all tags when
            /// null.
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse<int?> GetTaggedImageCountWithHttpMessages(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid? iterationId = default(System.Guid?), IList<System.Guid> tagIds = default(IList<System.Guid>), Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.GetTaggedImageCountWithHttpMessagesAsync(projectId, iterationId, tagIds, customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Associate a set of images with a set of tags.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='batch'>
            /// Batch of image tags. Limited to 128 tags per batch.
            /// </param>
            public static ImageTagCreateSummary CreateImageTags(this ICustomVisionTrainingClient operations, System.Guid projectId, ImageTagCreateBatch batch)
            {
                return operations.CreateImageTagsAsync(projectId, batch).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Associate a set of images with a set of tags.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='batch'>
            /// Batch of image tags. Limited to 128 tags per batch.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<ImageTagCreateSummary> CreateImageTagsAsync(this ICustomVisionTrainingClient operations, System.Guid projectId, ImageTagCreateBatch batch, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.CreateImageTagsWithHttpMessagesAsync(projectId, batch, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Associate a set of images with a set of tags.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='batch'>
            /// Batch of image tags. Limited to 128 tags per batch.
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse<ImageTagCreateSummary> CreateImageTagsWithHttpMessages(this ICustomVisionTrainingClient operations, System.Guid projectId, ImageTagCreateBatch batch, Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.CreateImageTagsWithHttpMessagesAsync(projectId, batch, customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Remove a set of tags from a set of images.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='imageIds'>
            /// Image ids. Limited to 64 images.
            /// </param>
            /// <param name='tagIds'>
            /// Tags to be deleted from the specified images. Limited to 20 tags.
            /// </param>
            public static void DeleteImageTags(this ICustomVisionTrainingClient operations, System.Guid projectId, IList<System.Guid> imageIds, IList<System.Guid> tagIds)
            {
                operations.DeleteImageTagsAsync(projectId, imageIds, tagIds).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Remove a set of tags from a set of images.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='imageIds'>
            /// Image ids. Limited to 64 images.
            /// </param>
            /// <param name='tagIds'>
            /// Tags to be deleted from the specified images. Limited to 20 tags.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task DeleteImageTagsAsync(this ICustomVisionTrainingClient operations, System.Guid projectId, IList<System.Guid> imageIds, IList<System.Guid> tagIds, CancellationToken cancellationToken = default(CancellationToken))
            {
                (await operations.DeleteImageTagsWithHttpMessagesAsync(projectId, imageIds, tagIds, null, cancellationToken).ConfigureAwait(false)).Dispose();
            }

            /// <summary>
            /// Remove a set of tags from a set of images.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='imageIds'>
            /// Image ids. Limited to 64 images.
            /// </param>
            /// <param name='tagIds'>
            /// Tags to be deleted from the specified images. Limited to 20 tags.
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse DeleteImageTagsWithHttpMessages(this ICustomVisionTrainingClient operations, System.Guid projectId, IList<System.Guid> imageIds, IList<System.Guid> tagIds, Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.DeleteImageTagsWithHttpMessagesAsync(projectId, imageIds, tagIds, customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Get untagged images for a given project iteration.
            /// </summary>
            /// <remarks>
            /// This API supports batching and range selection. By default it will only
            /// return first 50 images matching images.
            /// Use the {take} and {skip} parameters to control how many images to return
            /// in a given batch.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='iterationId'>
            /// The iteration id. Defaults to workspace.
            /// </param>
            /// <param name='orderBy'>
            /// The ordering. Defaults to newest. Possible values include: 'Newest',
            /// 'Oldest'
            /// </param>
            /// <param name='take'>
            /// Maximum number of images to return. Defaults to 50, limited to 256.
            /// </param>
            /// <param name='skip'>
            /// Number of images to skip before beginning the image batch. Defaults to 0.
            /// </param>
            public static IList<Image> GetUntaggedImages(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid? iterationId = default(System.Guid?), string orderBy = default(string), int? take = 50, int? skip = 0)
            {
                return operations.GetUntaggedImagesAsync(projectId, iterationId, orderBy, take, skip).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Get untagged images for a given project iteration.
            /// </summary>
            /// <remarks>
            /// This API supports batching and range selection. By default it will only
            /// return first 50 images matching images.
            /// Use the {take} and {skip} parameters to control how many images to return
            /// in a given batch.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='iterationId'>
            /// The iteration id. Defaults to workspace.
            /// </param>
            /// <param name='orderBy'>
            /// The ordering. Defaults to newest. Possible values include: 'Newest',
            /// 'Oldest'
            /// </param>
            /// <param name='take'>
            /// Maximum number of images to return. Defaults to 50, limited to 256.
            /// </param>
            /// <param name='skip'>
            /// Number of images to skip before beginning the image batch. Defaults to 0.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IList<Image>> GetUntaggedImagesAsync(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid? iterationId = default(System.Guid?), string orderBy = default(string), int? take = 50, int? skip = 0, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetUntaggedImagesWithHttpMessagesAsync(projectId, iterationId, orderBy, take, skip, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Get untagged images for a given project iteration.
            /// </summary>
            /// <remarks>
            /// This API supports batching and range selection. By default it will only
            /// return first 50 images matching images.
            /// Use the {take} and {skip} parameters to control how many images to return
            /// in a given batch.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='iterationId'>
            /// The iteration id. Defaults to workspace.
            /// </param>
            /// <param name='orderBy'>
            /// The ordering. Defaults to newest. Possible values include: 'Newest',
            /// 'Oldest'
            /// </param>
            /// <param name='take'>
            /// Maximum number of images to return. Defaults to 50, limited to 256.
            /// </param>
            /// <param name='skip'>
            /// Number of images to skip before beginning the image batch. Defaults to 0.
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse<IList<Image>> GetUntaggedImagesWithHttpMessages(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid? iterationId = default(System.Guid?), string orderBy = default(string), int? take = 50, int? skip = 0, Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.GetUntaggedImagesWithHttpMessagesAsync(projectId, iterationId, orderBy, take, skip, customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Gets the number of untagged images.
            /// </summary>
            /// <remarks>
            /// This API returns the images which have no tags for a given project and
            /// optionally an iteration. If no iteration is specified the
            /// current workspace is used.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='iterationId'>
            /// The iteration id. Defaults to workspace.
            /// </param>
            public static int? GetUntaggedImageCount(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid? iterationId = default(System.Guid?))
            {
                return operations.GetUntaggedImageCountAsync(projectId, iterationId).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Gets the number of untagged images.
            /// </summary>
            /// <remarks>
            /// This API returns the images which have no tags for a given project and
            /// optionally an iteration. If no iteration is specified the
            /// current workspace is used.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='iterationId'>
            /// The iteration id. Defaults to workspace.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<int?> GetUntaggedImageCountAsync(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid? iterationId = default(System.Guid?), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetUntaggedImageCountWithHttpMessagesAsync(projectId, iterationId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Gets the number of untagged images.
            /// </summary>
            /// <remarks>
            /// This API returns the images which have no tags for a given project and
            /// optionally an iteration. If no iteration is specified the
            /// current workspace is used.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='iterationId'>
            /// The iteration id. Defaults to workspace.
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse<int?> GetUntaggedImageCountWithHttpMessages(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid? iterationId = default(System.Guid?), Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.GetUntaggedImageCountWithHttpMessagesAsync(projectId, iterationId, customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Add the provided images urls to the set of training images.
            /// </summary>
            /// <remarks>
            /// This API accepts a batch of urls, and optionally tags, to create images.
            /// There is a limit of 64 images and 20 tags.
            /// If all images are successful created, 200(OK) status code will be returned.
            /// Otherwise, 207 (Multi-Status) status code will be returned and detail
            /// status for each image will be listed in the response payload.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='batch'>
            /// Image urls, tag ids, and metadata. Limited to 64 images and 20 tags per
            /// batch.
            /// </param>
            public static ImageCreateSummary CreateImagesFromUrls(this ICustomVisionTrainingClient operations, System.Guid projectId, ImageUrlCreateBatch batch)
            {
                return operations.CreateImagesFromUrlsAsync(projectId, batch).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Add the provided images urls to the set of training images.
            /// </summary>
            /// <remarks>
            /// This API accepts a batch of urls, and optionally tags, to create images.
            /// There is a limit of 64 images and 20 tags.
            /// If all images are successful created, 200(OK) status code will be returned.
            /// Otherwise, 207 (Multi-Status) status code will be returned and detail
            /// status for each image will be listed in the response payload.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='batch'>
            /// Image urls, tag ids, and metadata. Limited to 64 images and 20 tags per
            /// batch.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<ImageCreateSummary> CreateImagesFromUrlsAsync(this ICustomVisionTrainingClient operations, System.Guid projectId, ImageUrlCreateBatch batch, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.CreateImagesFromUrlsWithHttpMessagesAsync(projectId, batch, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Add the provided images urls to the set of training images.
            /// </summary>
            /// <remarks>
            /// This API accepts a batch of urls, and optionally tags, to create images.
            /// There is a limit of 64 images and 20 tags.
            /// If all images are successful created, 200(OK) status code will be returned.
            /// Otherwise, 207 (Multi-Status) status code will be returned and detail
            /// status for each image will be listed in the response payload.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='batch'>
            /// Image urls, tag ids, and metadata. Limited to 64 images and 20 tags per
            /// batch.
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse<ImageCreateSummary> CreateImagesFromUrlsWithHttpMessages(this ICustomVisionTrainingClient operations, System.Guid projectId, ImageUrlCreateBatch batch, Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.CreateImagesFromUrlsWithHttpMessagesAsync(projectId, batch, customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Get iterations for the project.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            public static IList<Iteration> GetIterations(this ICustomVisionTrainingClient operations, System.Guid projectId)
            {
                return operations.GetIterationsAsync(projectId).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Get iterations for the project.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IList<Iteration>> GetIterationsAsync(this ICustomVisionTrainingClient operations, System.Guid projectId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetIterationsWithHttpMessagesAsync(projectId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Get iterations for the project.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse<IList<Iteration>> GetIterationsWithHttpMessages(this ICustomVisionTrainingClient operations, System.Guid projectId, Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.GetIterationsWithHttpMessagesAsync(projectId, customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Get a specific iteration.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The id of the project the iteration belongs to.
            /// </param>
            /// <param name='iterationId'>
            /// The id of the iteration to get.
            /// </param>
            public static Iteration GetIteration(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid iterationId)
            {
                return operations.GetIterationAsync(projectId, iterationId).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Get a specific iteration.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The id of the project the iteration belongs to.
            /// </param>
            /// <param name='iterationId'>
            /// The id of the iteration to get.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<Iteration> GetIterationAsync(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid iterationId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetIterationWithHttpMessagesAsync(projectId, iterationId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Get a specific iteration.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The id of the project the iteration belongs to.
            /// </param>
            /// <param name='iterationId'>
            /// The id of the iteration to get.
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse<Iteration> GetIterationWithHttpMessages(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid iterationId, Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.GetIterationWithHttpMessagesAsync(projectId, iterationId, customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Delete a specific iteration of a project.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='iterationId'>
            /// The iteration id.
            /// </param>
            public static void DeleteIteration(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid iterationId)
            {
                operations.DeleteIterationAsync(projectId, iterationId).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Delete a specific iteration of a project.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='iterationId'>
            /// The iteration id.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task DeleteIterationAsync(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid iterationId, CancellationToken cancellationToken = default(CancellationToken))
            {
                (await operations.DeleteIterationWithHttpMessagesAsync(projectId, iterationId, null, cancellationToken).ConfigureAwait(false)).Dispose();
            }

            /// <summary>
            /// Delete a specific iteration of a project.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='iterationId'>
            /// The iteration id.
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse DeleteIterationWithHttpMessages(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid iterationId, Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.DeleteIterationWithHttpMessagesAsync(projectId, iterationId, customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Update a specific iteration.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// Project id.
            /// </param>
            /// <param name='iterationId'>
            /// Iteration id.
            /// </param>
            /// <param name='updatedIteration'>
            /// The updated iteration model.
            /// </param>
            public static Iteration UpdateIteration(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid iterationId, Iteration updatedIteration)
            {
                return operations.UpdateIterationAsync(projectId, iterationId, updatedIteration).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Update a specific iteration.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// Project id.
            /// </param>
            /// <param name='iterationId'>
            /// Iteration id.
            /// </param>
            /// <param name='updatedIteration'>
            /// The updated iteration model.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<Iteration> UpdateIterationAsync(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid iterationId, Iteration updatedIteration, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.UpdateIterationWithHttpMessagesAsync(projectId, iterationId, updatedIteration, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Update a specific iteration.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// Project id.
            /// </param>
            /// <param name='iterationId'>
            /// Iteration id.
            /// </param>
            /// <param name='updatedIteration'>
            /// The updated iteration model.
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse<Iteration> UpdateIterationWithHttpMessages(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid iterationId, Iteration updatedIteration, Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.UpdateIterationWithHttpMessagesAsync(projectId, iterationId, updatedIteration, customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Get the list of exports for a specific iteration.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='iterationId'>
            /// The iteration id.
            /// </param>
            public static IList<Export> GetExports(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid iterationId)
            {
                return operations.GetExportsAsync(projectId, iterationId).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Get the list of exports for a specific iteration.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='iterationId'>
            /// The iteration id.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IList<Export>> GetExportsAsync(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid iterationId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetExportsWithHttpMessagesAsync(projectId, iterationId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Get the list of exports for a specific iteration.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='iterationId'>
            /// The iteration id.
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse<IList<Export>> GetExportsWithHttpMessages(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid iterationId, Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.GetExportsWithHttpMessagesAsync(projectId, iterationId, customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Export a trained iteration.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='iterationId'>
            /// The iteration id.
            /// </param>
            /// <param name='platform'>
            /// The target platform. Possible values include: 'CoreML', 'TensorFlow',
            /// 'DockerFile', 'ONNX', 'VAIDK', 'OpenVino'
            /// </param>
            /// <param name='flavor'>
            /// The flavor of the target platform. Possible values include: 'Linux',
            /// 'Windows', 'ONNX10', 'ONNX12', 'ARM', 'TensorFlowNormal', 'TensorFlowLite'
            /// </param>
            public static Export ExportIteration(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid iterationId, string platform, string flavor = default(string))
            {
                return operations.ExportIterationAsync(projectId, iterationId, platform, flavor).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Export a trained iteration.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='iterationId'>
            /// The iteration id.
            /// </param>
            /// <param name='platform'>
            /// The target platform. Possible values include: 'CoreML', 'TensorFlow',
            /// 'DockerFile', 'ONNX', 'VAIDK', 'OpenVino'
            /// </param>
            /// <param name='flavor'>
            /// The flavor of the target platform. Possible values include: 'Linux',
            /// 'Windows', 'ONNX10', 'ONNX12', 'ARM', 'TensorFlowNormal', 'TensorFlowLite'
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<Export> ExportIterationAsync(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid iterationId, string platform, string flavor = default(string), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ExportIterationWithHttpMessagesAsync(projectId, iterationId, platform, flavor, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Export a trained iteration.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='iterationId'>
            /// The iteration id.
            /// </param>
            /// <param name='platform'>
            /// The target platform. Possible values include: 'CoreML', 'TensorFlow',
            /// 'DockerFile', 'ONNX', 'VAIDK', 'OpenVino'
            /// </param>
            /// <param name='flavor'>
            /// The flavor of the target platform. Possible values include: 'Linux',
            /// 'Windows', 'ONNX10', 'ONNX12', 'ARM', 'TensorFlowNormal', 'TensorFlowLite'
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse<Export> ExportIterationWithHttpMessages(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid iterationId, string platform, string flavor = default(string), Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.ExportIterationWithHttpMessagesAsync(projectId, iterationId, platform, flavor, customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Get detailed performance information about an iteration.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The id of the project the iteration belongs to.
            /// </param>
            /// <param name='iterationId'>
            /// The id of the iteration to get.
            /// </param>
            /// <param name='threshold'>
            /// The threshold used to determine true predictions.
            /// </param>
            /// <param name='overlapThreshold'>
            /// If applicable, the bounding box overlap threshold used to determine true
            /// predictions.
            /// </param>
            public static IterationPerformance GetIterationPerformance(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid iterationId, double? threshold = default(double?), double? overlapThreshold = default(double?))
            {
                return operations.GetIterationPerformanceAsync(projectId, iterationId, threshold, overlapThreshold).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Get detailed performance information about an iteration.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The id of the project the iteration belongs to.
            /// </param>
            /// <param name='iterationId'>
            /// The id of the iteration to get.
            /// </param>
            /// <param name='threshold'>
            /// The threshold used to determine true predictions.
            /// </param>
            /// <param name='overlapThreshold'>
            /// If applicable, the bounding box overlap threshold used to determine true
            /// predictions.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IterationPerformance> GetIterationPerformanceAsync(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid iterationId, double? threshold = default(double?), double? overlapThreshold = default(double?), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetIterationPerformanceWithHttpMessagesAsync(projectId, iterationId, threshold, overlapThreshold, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Get detailed performance information about an iteration.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The id of the project the iteration belongs to.
            /// </param>
            /// <param name='iterationId'>
            /// The id of the iteration to get.
            /// </param>
            /// <param name='threshold'>
            /// The threshold used to determine true predictions.
            /// </param>
            /// <param name='overlapThreshold'>
            /// If applicable, the bounding box overlap threshold used to determine true
            /// predictions.
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse<IterationPerformance> GetIterationPerformanceWithHttpMessages(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid iterationId, double? threshold = default(double?), double? overlapThreshold = default(double?), Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.GetIterationPerformanceWithHttpMessagesAsync(projectId, iterationId, threshold, overlapThreshold, customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Get image with its prediction for a given project iteration.
            /// </summary>
            /// <remarks>
            /// This API supports batching and range selection. By default it will only
            /// return first 50 images matching images.
            /// Use the {take} and {skip} parameters to control how many images to return
            /// in a given batch.
            /// The filtering is on an and/or relationship. For example, if the provided
            /// tag ids are for the "Dog" and
            /// "Cat" tags, then only images tagged with Dog and/or Cat will be returned
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='iterationId'>
            /// The iteration id. Defaults to workspace.
            /// </param>
            /// <param name='tagIds'>
            /// A list of tags ids to filter the images. Defaults to all tagged images when
            /// null. Limited to 20.
            /// </param>
            /// <param name='orderBy'>
            /// The ordering. Defaults to newest. Possible values include: 'Newest',
            /// 'Oldest'
            /// </param>
            /// <param name='take'>
            /// Maximum number of images to return. Defaults to 50, limited to 256.
            /// </param>
            /// <param name='skip'>
            /// Number of images to skip before beginning the image batch. Defaults to 0.
            /// </param>
            public static IList<ImagePerformance> GetImagePerformances(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid iterationId, IList<System.Guid> tagIds = default(IList<System.Guid>), string orderBy = default(string), int? take = 50, int? skip = 0)
            {
                return operations.GetImagePerformancesAsync(projectId, iterationId, tagIds, orderBy, take, skip).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Get image with its prediction for a given project iteration.
            /// </summary>
            /// <remarks>
            /// This API supports batching and range selection. By default it will only
            /// return first 50 images matching images.
            /// Use the {take} and {skip} parameters to control how many images to return
            /// in a given batch.
            /// The filtering is on an and/or relationship. For example, if the provided
            /// tag ids are for the "Dog" and
            /// "Cat" tags, then only images tagged with Dog and/or Cat will be returned
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='iterationId'>
            /// The iteration id. Defaults to workspace.
            /// </param>
            /// <param name='tagIds'>
            /// A list of tags ids to filter the images. Defaults to all tagged images when
            /// null. Limited to 20.
            /// </param>
            /// <param name='orderBy'>
            /// The ordering. Defaults to newest. Possible values include: 'Newest',
            /// 'Oldest'
            /// </param>
            /// <param name='take'>
            /// Maximum number of images to return. Defaults to 50, limited to 256.
            /// </param>
            /// <param name='skip'>
            /// Number of images to skip before beginning the image batch. Defaults to 0.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IList<ImagePerformance>> GetImagePerformancesAsync(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid iterationId, IList<System.Guid> tagIds = default(IList<System.Guid>), string orderBy = default(string), int? take = 50, int? skip = 0, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetImagePerformancesWithHttpMessagesAsync(projectId, iterationId, tagIds, orderBy, take, skip, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Get image with its prediction for a given project iteration.
            /// </summary>
            /// <remarks>
            /// This API supports batching and range selection. By default it will only
            /// return first 50 images matching images.
            /// Use the {take} and {skip} parameters to control how many images to return
            /// in a given batch.
            /// The filtering is on an and/or relationship. For example, if the provided
            /// tag ids are for the "Dog" and
            /// "Cat" tags, then only images tagged with Dog and/or Cat will be returned
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='iterationId'>
            /// The iteration id. Defaults to workspace.
            /// </param>
            /// <param name='tagIds'>
            /// A list of tags ids to filter the images. Defaults to all tagged images when
            /// null. Limited to 20.
            /// </param>
            /// <param name='orderBy'>
            /// The ordering. Defaults to newest. Possible values include: 'Newest',
            /// 'Oldest'
            /// </param>
            /// <param name='take'>
            /// Maximum number of images to return. Defaults to 50, limited to 256.
            /// </param>
            /// <param name='skip'>
            /// Number of images to skip before beginning the image batch. Defaults to 0.
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse<IList<ImagePerformance>> GetImagePerformancesWithHttpMessages(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid iterationId, IList<System.Guid> tagIds = default(IList<System.Guid>), string orderBy = default(string), int? take = 50, int? skip = 0, Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.GetImagePerformancesWithHttpMessagesAsync(projectId, iterationId, tagIds, orderBy, take, skip, customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Gets the number of images tagged with the provided {tagIds} that have
            /// prediction results from
            /// training for the provided iteration {iterationId}.
            /// </summary>
            /// <remarks>
            /// The filtering is on an and/or relationship. For example, if the provided
            /// tag ids are for the "Dog" and
            /// "Cat" tags, then only images tagged with Dog and/or Cat will be returned
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='iterationId'>
            /// The iteration id. Defaults to workspace.
            /// </param>
            /// <param name='tagIds'>
            /// A list of tags ids to filter the images to count. Defaults to all tags when
            /// null.
            /// </param>
            public static int? GetImagePerformanceCount(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid iterationId, IList<System.Guid> tagIds = default(IList<System.Guid>))
            {
                return operations.GetImagePerformanceCountAsync(projectId, iterationId, tagIds).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Gets the number of images tagged with the provided {tagIds} that have
            /// prediction results from
            /// training for the provided iteration {iterationId}.
            /// </summary>
            /// <remarks>
            /// The filtering is on an and/or relationship. For example, if the provided
            /// tag ids are for the "Dog" and
            /// "Cat" tags, then only images tagged with Dog and/or Cat will be returned
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='iterationId'>
            /// The iteration id. Defaults to workspace.
            /// </param>
            /// <param name='tagIds'>
            /// A list of tags ids to filter the images to count. Defaults to all tags when
            /// null.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<int?> GetImagePerformanceCountAsync(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid iterationId, IList<System.Guid> tagIds = default(IList<System.Guid>), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetImagePerformanceCountWithHttpMessagesAsync(projectId, iterationId, tagIds, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Gets the number of images tagged with the provided {tagIds} that have
            /// prediction results from
            /// training for the provided iteration {iterationId}.
            /// </summary>
            /// <remarks>
            /// The filtering is on an and/or relationship. For example, if the provided
            /// tag ids are for the "Dog" and
            /// "Cat" tags, then only images tagged with Dog and/or Cat will be returned
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='iterationId'>
            /// The iteration id. Defaults to workspace.
            /// </param>
            /// <param name='tagIds'>
            /// A list of tags ids to filter the images to count. Defaults to all tags when
            /// null.
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse<int?> GetImagePerformanceCountWithHttpMessages(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid iterationId, IList<System.Guid> tagIds = default(IList<System.Guid>), Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.GetImagePerformanceCountWithHttpMessagesAsync(projectId, iterationId, tagIds, customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Publish a specific iteration.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='iterationId'>
            /// The iteration id.
            /// </param>
            /// <param name='publishName'>
            /// The name to give the published iteration.
            /// </param>
            /// <param name='predictionId'>
            /// The id of the prediction resource to publish to.
            /// </param>
            /// <param name='overwrite'>
            /// Whether to overwrite the published model with the given name (default:
            /// false).
            /// </param>
            public static bool? PublishIteration(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid iterationId, string publishName, string predictionId, bool? overwrite = default(bool?))
            {
                return operations.PublishIterationAsync(projectId, iterationId, publishName, predictionId, overwrite).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Publish a specific iteration.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='iterationId'>
            /// The iteration id.
            /// </param>
            /// <param name='publishName'>
            /// The name to give the published iteration.
            /// </param>
            /// <param name='predictionId'>
            /// The id of the prediction resource to publish to.
            /// </param>
            /// <param name='overwrite'>
            /// Whether to overwrite the published model with the given name (default:
            /// false).
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<bool?> PublishIterationAsync(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid iterationId, string publishName, string predictionId, bool? overwrite = default(bool?), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.PublishIterationWithHttpMessagesAsync(projectId, iterationId, publishName, predictionId, overwrite, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Publish a specific iteration.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='iterationId'>
            /// The iteration id.
            /// </param>
            /// <param name='publishName'>
            /// The name to give the published iteration.
            /// </param>
            /// <param name='predictionId'>
            /// The id of the prediction resource to publish to.
            /// </param>
            /// <param name='overwrite'>
            /// Whether to overwrite the published model with the given name (default:
            /// false).
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse<bool?> PublishIterationWithHttpMessages(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid iterationId, string publishName, string predictionId, bool? overwrite = default(bool?), Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.PublishIterationWithHttpMessagesAsync(projectId, iterationId, publishName, predictionId, overwrite, customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Unpublish a specific iteration.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='iterationId'>
            /// The iteration id.
            /// </param>
            public static void UnpublishIteration(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid iterationId)
            {
                operations.UnpublishIterationAsync(projectId, iterationId).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Unpublish a specific iteration.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='iterationId'>
            /// The iteration id.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task UnpublishIterationAsync(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid iterationId, CancellationToken cancellationToken = default(CancellationToken))
            {
                (await operations.UnpublishIterationWithHttpMessagesAsync(projectId, iterationId, null, cancellationToken).ConfigureAwait(false)).Dispose();
            }

            /// <summary>
            /// Unpublish a specific iteration.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='iterationId'>
            /// The iteration id.
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse UnpublishIterationWithHttpMessages(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid iterationId, Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.UnpublishIterationWithHttpMessagesAsync(projectId, iterationId, customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Delete a set of predicted images and their associated prediction results.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='ids'>
            /// The prediction ids. Limited to 64.
            /// </param>
            public static void DeletePrediction(this ICustomVisionTrainingClient operations, System.Guid projectId, IList<System.Guid> ids)
            {
                operations.DeletePredictionAsync(projectId, ids).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Delete a set of predicted images and their associated prediction results.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='ids'>
            /// The prediction ids. Limited to 64.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task DeletePredictionAsync(this ICustomVisionTrainingClient operations, System.Guid projectId, IList<System.Guid> ids, CancellationToken cancellationToken = default(CancellationToken))
            {
                (await operations.DeletePredictionWithHttpMessagesAsync(projectId, ids, null, cancellationToken).ConfigureAwait(false)).Dispose();
            }

            /// <summary>
            /// Delete a set of predicted images and their associated prediction results.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='ids'>
            /// The prediction ids. Limited to 64.
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse DeletePredictionWithHttpMessages(this ICustomVisionTrainingClient operations, System.Guid projectId, IList<System.Guid> ids, Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.DeletePredictionWithHttpMessagesAsync(projectId, ids, customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Get images that were sent to your prediction endpoint.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='query'>
            /// Parameters used to query the predictions. Limited to combining 2 tags.
            /// </param>
            public static PredictionQueryResult QueryPredictions(this ICustomVisionTrainingClient operations, System.Guid projectId, PredictionQueryToken query)
            {
                return operations.QueryPredictionsAsync(projectId, query).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Get images that were sent to your prediction endpoint.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='query'>
            /// Parameters used to query the predictions. Limited to combining 2 tags.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<PredictionQueryResult> QueryPredictionsAsync(this ICustomVisionTrainingClient operations, System.Guid projectId, PredictionQueryToken query, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.QueryPredictionsWithHttpMessagesAsync(projectId, query, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Get images that were sent to your prediction endpoint.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='query'>
            /// Parameters used to query the predictions. Limited to combining 2 tags.
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse<PredictionQueryResult> QueryPredictionsWithHttpMessages(this ICustomVisionTrainingClient operations, System.Guid projectId, PredictionQueryToken query, Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.QueryPredictionsWithHttpMessagesAsync(projectId, query, customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Quick test an image.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='imageData'>
            /// Binary image data. Supported formats are JPEG, GIF, PNG, and BMP. Supports
            /// images up to 6MB.
            /// </param>
            /// <param name='iterationId'>
            /// Optional. Specifies the id of a particular iteration to evaluate against.
            /// The default iteration for the project will be used when not specified.
            /// </param>
            /// <param name='store'>
            /// Optional. Specifies whether or not to store the result of this prediction.
            /// The default is true, to store.
            /// </param>
            public static ImagePrediction QuickTestImage(this ICustomVisionTrainingClient operations, System.Guid projectId, Stream imageData, System.Guid? iterationId = default(System.Guid?), bool? store = true)
            {
                return operations.QuickTestImageAsync(projectId, imageData, iterationId, store).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Quick test an image.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='imageData'>
            /// Binary image data. Supported formats are JPEG, GIF, PNG, and BMP. Supports
            /// images up to 6MB.
            /// </param>
            /// <param name='iterationId'>
            /// Optional. Specifies the id of a particular iteration to evaluate against.
            /// The default iteration for the project will be used when not specified.
            /// </param>
            /// <param name='store'>
            /// Optional. Specifies whether or not to store the result of this prediction.
            /// The default is true, to store.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<ImagePrediction> QuickTestImageAsync(this ICustomVisionTrainingClient operations, System.Guid projectId, Stream imageData, System.Guid? iterationId = default(System.Guid?), bool? store = true, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.QuickTestImageWithHttpMessagesAsync(projectId, imageData, iterationId, store, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Quick test an image.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='imageData'>
            /// Binary image data. Supported formats are JPEG, GIF, PNG, and BMP. Supports
            /// images up to 6MB.
            /// </param>
            /// <param name='iterationId'>
            /// Optional. Specifies the id of a particular iteration to evaluate against.
            /// The default iteration for the project will be used when not specified.
            /// </param>
            /// <param name='store'>
            /// Optional. Specifies whether or not to store the result of this prediction.
            /// The default is true, to store.
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse<ImagePrediction> QuickTestImageWithHttpMessages(this ICustomVisionTrainingClient operations, System.Guid projectId, Stream imageData, System.Guid? iterationId = default(System.Guid?), bool? store = true, Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.QuickTestImageWithHttpMessagesAsync(projectId, imageData, iterationId, store, customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Quick test an image url.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project to evaluate against.
            /// </param>
            /// <param name='imageUrl'>
            /// An ImageUrl that contains the url of the image to be evaluated.
            /// </param>
            /// <param name='iterationId'>
            /// Optional. Specifies the id of a particular iteration to evaluate against.
            /// The default iteration for the project will be used when not specified.
            /// </param>
            /// <param name='store'>
            /// Optional. Specifies whether or not to store the result of this prediction.
            /// The default is true, to store.
            /// </param>
            public static ImagePrediction QuickTestImageUrl(this ICustomVisionTrainingClient operations, System.Guid projectId, ImageUrl imageUrl, System.Guid? iterationId = default(System.Guid?), bool? store = true)
            {
                return operations.QuickTestImageUrlAsync(projectId, imageUrl, iterationId, store).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Quick test an image url.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project to evaluate against.
            /// </param>
            /// <param name='imageUrl'>
            /// An ImageUrl that contains the url of the image to be evaluated.
            /// </param>
            /// <param name='iterationId'>
            /// Optional. Specifies the id of a particular iteration to evaluate against.
            /// The default iteration for the project will be used when not specified.
            /// </param>
            /// <param name='store'>
            /// Optional. Specifies whether or not to store the result of this prediction.
            /// The default is true, to store.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<ImagePrediction> QuickTestImageUrlAsync(this ICustomVisionTrainingClient operations, System.Guid projectId, ImageUrl imageUrl, System.Guid? iterationId = default(System.Guid?), bool? store = true, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.QuickTestImageUrlWithHttpMessagesAsync(projectId, imageUrl, iterationId, store, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Quick test an image url.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project to evaluate against.
            /// </param>
            /// <param name='imageUrl'>
            /// An ImageUrl that contains the url of the image to be evaluated.
            /// </param>
            /// <param name='iterationId'>
            /// Optional. Specifies the id of a particular iteration to evaluate against.
            /// The default iteration for the project will be used when not specified.
            /// </param>
            /// <param name='store'>
            /// Optional. Specifies whether or not to store the result of this prediction.
            /// The default is true, to store.
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse<ImagePrediction> QuickTestImageUrlWithHttpMessages(this ICustomVisionTrainingClient operations, System.Guid projectId, ImageUrl imageUrl, System.Guid? iterationId = default(System.Guid?), bool? store = true, Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.QuickTestImageUrlWithHttpMessagesAsync(projectId, imageUrl, iterationId, store, customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Get the tags for a given project and iteration.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='iterationId'>
            /// The iteration id. Defaults to workspace.
            /// </param>
            public static IList<Tag> GetTags(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid? iterationId = default(System.Guid?))
            {
                return operations.GetTagsAsync(projectId, iterationId).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Get the tags for a given project and iteration.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='iterationId'>
            /// The iteration id. Defaults to workspace.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IList<Tag>> GetTagsAsync(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid? iterationId = default(System.Guid?), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetTagsWithHttpMessagesAsync(projectId, iterationId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Get the tags for a given project and iteration.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='iterationId'>
            /// The iteration id. Defaults to workspace.
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse<IList<Tag>> GetTagsWithHttpMessages(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid? iterationId = default(System.Guid?), Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.GetTagsWithHttpMessagesAsync(projectId, iterationId, customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Create a tag for the project.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='name'>
            /// The tag name.
            /// </param>
            /// <param name='description'>
            /// Optional description for the tag.
            /// </param>
            /// <param name='type'>
            /// Optional type for the tag. Possible values include: 'Regular', 'Negative',
            /// 'GeneralProduct'
            /// </param>
            public static Tag CreateTag(this ICustomVisionTrainingClient operations, System.Guid projectId, string name, string description = default(string), string type = default(string))
            {
                return operations.CreateTagAsync(projectId, name, description, type).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Create a tag for the project.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='name'>
            /// The tag name.
            /// </param>
            /// <param name='description'>
            /// Optional description for the tag.
            /// </param>
            /// <param name='type'>
            /// Optional type for the tag. Possible values include: 'Regular', 'Negative',
            /// 'GeneralProduct'
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<Tag> CreateTagAsync(this ICustomVisionTrainingClient operations, System.Guid projectId, string name, string description = default(string), string type = default(string), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.CreateTagWithHttpMessagesAsync(projectId, name, description, type, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Create a tag for the project.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='name'>
            /// The tag name.
            /// </param>
            /// <param name='description'>
            /// Optional description for the tag.
            /// </param>
            /// <param name='type'>
            /// Optional type for the tag. Possible values include: 'Regular', 'Negative',
            /// 'GeneralProduct'
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse<Tag> CreateTagWithHttpMessages(this ICustomVisionTrainingClient operations, System.Guid projectId, string name, string description = default(string), string type = default(string), Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.CreateTagWithHttpMessagesAsync(projectId, name, description, type, customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Get information about a specific tag.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project this tag belongs to.
            /// </param>
            /// <param name='tagId'>
            /// The tag id.
            /// </param>
            /// <param name='iterationId'>
            /// The iteration to retrieve this tag from. Optional, defaults to current
            /// training set.
            /// </param>
            public static Tag GetTag(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid tagId, System.Guid? iterationId = default(System.Guid?))
            {
                return operations.GetTagAsync(projectId, tagId, iterationId).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Get information about a specific tag.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project this tag belongs to.
            /// </param>
            /// <param name='tagId'>
            /// The tag id.
            /// </param>
            /// <param name='iterationId'>
            /// The iteration to retrieve this tag from. Optional, defaults to current
            /// training set.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<Tag> GetTagAsync(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid tagId, System.Guid? iterationId = default(System.Guid?), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetTagWithHttpMessagesAsync(projectId, tagId, iterationId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Get information about a specific tag.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project this tag belongs to.
            /// </param>
            /// <param name='tagId'>
            /// The tag id.
            /// </param>
            /// <param name='iterationId'>
            /// The iteration to retrieve this tag from. Optional, defaults to current
            /// training set.
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse<Tag> GetTagWithHttpMessages(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid tagId, System.Guid? iterationId = default(System.Guid?), Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.GetTagWithHttpMessagesAsync(projectId, tagId, iterationId, customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Delete a tag from the project.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='tagId'>
            /// Id of the tag to be deleted.
            /// </param>
            public static void DeleteTag(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid tagId)
            {
                operations.DeleteTagAsync(projectId, tagId).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Delete a tag from the project.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='tagId'>
            /// Id of the tag to be deleted.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task DeleteTagAsync(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid tagId, CancellationToken cancellationToken = default(CancellationToken))
            {
                (await operations.DeleteTagWithHttpMessagesAsync(projectId, tagId, null, cancellationToken).ConfigureAwait(false)).Dispose();
            }

            /// <summary>
            /// Delete a tag from the project.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='tagId'>
            /// Id of the tag to be deleted.
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse DeleteTagWithHttpMessages(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid tagId, Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.DeleteTagWithHttpMessagesAsync(projectId, tagId, customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Update a tag.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='tagId'>
            /// The id of the target tag.
            /// </param>
            /// <param name='updatedTag'>
            /// The updated tag model.
            /// </param>
            public static Tag UpdateTag(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid tagId, Tag updatedTag)
            {
                return operations.UpdateTagAsync(projectId, tagId, updatedTag).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Update a tag.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='tagId'>
            /// The id of the target tag.
            /// </param>
            /// <param name='updatedTag'>
            /// The updated tag model.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<Tag> UpdateTagAsync(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid tagId, Tag updatedTag, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.UpdateTagWithHttpMessagesAsync(projectId, tagId, updatedTag, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Update a tag.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='tagId'>
            /// The id of the target tag.
            /// </param>
            /// <param name='updatedTag'>
            /// The updated tag model.
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse<Tag> UpdateTagWithHttpMessages(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid tagId, Tag updatedTag, Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.UpdateTagWithHttpMessagesAsync(projectId, tagId, updatedTag, customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Suggest tags and regions for an array/batch of untagged images. Returns
            /// empty array if no tags are found.
            /// </summary>
            /// <remarks>
            /// This API will get suggested tags and regions for an array/batch of untagged
            /// images along with confidences for the tags. It returns an empty array if no
            /// tags are found.
            /// There is a limit of 64 images in the batch.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='iterationId'>
            /// IterationId to use for tag and region suggestion.
            /// </param>
            /// <param name='imageIds'>
            /// Array of image ids tag suggestion are needed for. Use GetUntaggedImages API
            /// to get imageIds.
            /// </param>
            public static IList<SuggestedTagAndRegion> SuggestTagsAndRegions(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid iterationId, IList<System.Guid> imageIds)
            {
                return operations.SuggestTagsAndRegionsAsync(projectId, iterationId, imageIds).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Suggest tags and regions for an array/batch of untagged images. Returns
            /// empty array if no tags are found.
            /// </summary>
            /// <remarks>
            /// This API will get suggested tags and regions for an array/batch of untagged
            /// images along with confidences for the tags. It returns an empty array if no
            /// tags are found.
            /// There is a limit of 64 images in the batch.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='iterationId'>
            /// IterationId to use for tag and region suggestion.
            /// </param>
            /// <param name='imageIds'>
            /// Array of image ids tag suggestion are needed for. Use GetUntaggedImages API
            /// to get imageIds.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IList<SuggestedTagAndRegion>> SuggestTagsAndRegionsAsync(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid iterationId, IList<System.Guid> imageIds, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.SuggestTagsAndRegionsWithHttpMessagesAsync(projectId, iterationId, imageIds, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Suggest tags and regions for an array/batch of untagged images. Returns
            /// empty array if no tags are found.
            /// </summary>
            /// <remarks>
            /// This API will get suggested tags and regions for an array/batch of untagged
            /// images along with confidences for the tags. It returns an empty array if no
            /// tags are found.
            /// There is a limit of 64 images in the batch.
            /// </remarks>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='iterationId'>
            /// IterationId to use for tag and region suggestion.
            /// </param>
            /// <param name='imageIds'>
            /// Array of image ids tag suggestion are needed for. Use GetUntaggedImages API
            /// to get imageIds.
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse<IList<SuggestedTagAndRegion>> SuggestTagsAndRegionsWithHttpMessages(this ICustomVisionTrainingClient operations, System.Guid projectId, System.Guid iterationId, IList<System.Guid> imageIds, Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.SuggestTagsAndRegionsWithHttpMessagesAsync(projectId, iterationId, imageIds, customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Queues project for training.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='trainingType'>
            /// The type of training to use to train the project (default: Regular).
            /// Possible values include: 'Regular', 'Advanced'
            /// </param>
            /// <param name='reservedBudgetInHours'>
            /// The number of hours reserved as budget for training (if applicable).
            /// </param>
            /// <param name='forceTrain'>
            /// Whether to force train even if dataset and configuration does not change
            /// (default: false).
            /// </param>
            /// <param name='notificationEmailAddress'>
            /// The email address to send notification to when training finishes (default:
            /// null).
            /// </param>
            /// <param name='trainingParameters'>
            /// Additional training parameters passed in to control how the project is
            /// trained.
            /// </param>
            public static Iteration TrainProject(this ICustomVisionTrainingClient operations, System.Guid projectId, string trainingType = default(string), int? reservedBudgetInHours = 0, bool? forceTrain = false, string notificationEmailAddress = default(string), TrainingParameters trainingParameters = default(TrainingParameters))
            {
                return operations.TrainProjectAsync(projectId, trainingType, reservedBudgetInHours, forceTrain, notificationEmailAddress, trainingParameters).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Queues project for training.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='trainingType'>
            /// The type of training to use to train the project (default: Regular).
            /// Possible values include: 'Regular', 'Advanced'
            /// </param>
            /// <param name='reservedBudgetInHours'>
            /// The number of hours reserved as budget for training (if applicable).
            /// </param>
            /// <param name='forceTrain'>
            /// Whether to force train even if dataset and configuration does not change
            /// (default: false).
            /// </param>
            /// <param name='notificationEmailAddress'>
            /// The email address to send notification to when training finishes (default:
            /// null).
            /// </param>
            /// <param name='trainingParameters'>
            /// Additional training parameters passed in to control how the project is
            /// trained.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<Iteration> TrainProjectAsync(this ICustomVisionTrainingClient operations, System.Guid projectId, string trainingType = default(string), int? reservedBudgetInHours = 0, bool? forceTrain = false, string notificationEmailAddress = default(string), TrainingParameters trainingParameters = default(TrainingParameters), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.TrainProjectWithHttpMessagesAsync(projectId, trainingType, reservedBudgetInHours, forceTrain, notificationEmailAddress, trainingParameters, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Queues project for training.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='projectId'>
            /// The project id.
            /// </param>
            /// <param name='trainingType'>
            /// The type of training to use to train the project (default: Regular).
            /// Possible values include: 'Regular', 'Advanced'
            /// </param>
            /// <param name='reservedBudgetInHours'>
            /// The number of hours reserved as budget for training (if applicable).
            /// </param>
            /// <param name='forceTrain'>
            /// Whether to force train even if dataset and configuration does not change
            /// (default: false).
            /// </param>
            /// <param name='notificationEmailAddress'>
            /// The email address to send notification to when training finishes (default:
            /// null).
            /// </param>
            /// <param name='trainingParameters'>
            /// Additional training parameters passed in to control how the project is
            /// trained.
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse<Iteration> TrainProjectWithHttpMessages(this ICustomVisionTrainingClient operations, System.Guid projectId, string trainingType = default(string), int? reservedBudgetInHours = 0, bool? forceTrain = false, string notificationEmailAddress = default(string), TrainingParameters trainingParameters = default(TrainingParameters), Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.TrainProjectWithHttpMessagesAsync(projectId, trainingType, reservedBudgetInHours, forceTrain, notificationEmailAddress, trainingParameters, customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Imports a project.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='token'>
            /// Token generated from the export project call.
            /// </param>
            /// <param name='name'>
            /// Optional, name of the project to use instead of auto-generated name.
            /// </param>
            public static Project ImportProject(this ICustomVisionTrainingClient operations, string token, string name = default(string))
            {
                return operations.ImportProjectAsync(token, name).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Imports a project.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='token'>
            /// Token generated from the export project call.
            /// </param>
            /// <param name='name'>
            /// Optional, name of the project to use instead of auto-generated name.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<Project> ImportProjectAsync(this ICustomVisionTrainingClient operations, string token, string name = default(string), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.ImportProjectWithHttpMessagesAsync(token, name, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Imports a project.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='token'>
            /// Token generated from the export project call.
            /// </param>
            /// <param name='name'>
            /// Optional, name of the project to use instead of auto-generated name.
            /// </param>
            /// <param name='customHeaders'>
            /// Headers that will be added to request.
            /// </param>
            public static HttpOperationResponse<Project> ImportProjectWithHttpMessages(this ICustomVisionTrainingClient operations, string token, string name = default(string), Dictionary<string, List<string>> customHeaders = null)
            {
                return operations.ImportProjectWithHttpMessagesAsync(token, name, customHeaders, CancellationToken.None).ConfigureAwait(false).GetAwaiter().GetResult();
            }

    }
}
