// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Vision.CustomVision.Prediction
{
    using Microsoft.Rest;
    using Models;
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.IO;
    using System.Threading;
    using System.Threading.Tasks;

    /// <summary>
    /// </summary>
    public partial interface ICustomVisionPredictionClient : System.IDisposable
    {
        /// <summary>
        /// The base URI of the service.
        /// </summary>

        /// <summary>
        /// Gets or sets json serialization settings.
        /// </summary>
        JsonSerializerSettings SerializationSettings { get; }

        /// <summary>
        /// Gets or sets json deserialization settings.
        /// </summary>
        JsonSerializerSettings DeserializationSettings { get; }

        /// <summary>
        /// Supported Cognitive Services endpoints.
        /// </summary>
        string Endpoint { get; set; }

        /// <summary>
        /// Subscription credentials which uniquely identify client
        /// subscription.
        /// </summary>
        ServiceClientCredentials Credentials { get; }


        /// <summary>
        /// Classify an image and saves the result.
        /// </summary>
        /// <param name='projectId'>
        /// The project id.
        /// </param>
        /// <param name='publishedName'>
        /// Specifies the name of the model to evaluate against.
        /// </param>
        /// <param name='imageData'>
        /// Binary image data. Supported formats are JPEG, GIF, PNG, and BMP.
        /// Supports images up to 4MB.
        /// </param>
        /// <param name='application'>
        /// Optional. Specifies the name of application using the endpoint.
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        Task<HttpOperationResponse<ImagePrediction>> ClassifyImageWithHttpMessagesAsync(System.Guid projectId, string publishedName, Stream imageData, string application = default(string), Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));

        /// <summary>
        /// Classify an image without saving the result.
        /// </summary>
        /// <param name='projectId'>
        /// The project id.
        /// </param>
        /// <param name='publishedName'>
        /// Specifies the name of the model to evaluate against.
        /// </param>
        /// <param name='imageData'>
        /// Binary image data. Supported formats are JPEG, GIF, PNG, and BMP.
        /// Supports images up to 4MB.
        /// </param>
        /// <param name='application'>
        /// Optional. Specifies the name of application using the endpoint.
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        Task<HttpOperationResponse<ImagePrediction>> ClassifyImageWithNoStoreWithHttpMessagesAsync(System.Guid projectId, string publishedName, Stream imageData, string application = default(string), Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));

        /// <summary>
        /// Classify an image url and saves the result.
        /// </summary>
        /// <param name='projectId'>
        /// The project id.
        /// </param>
        /// <param name='publishedName'>
        /// Specifies the name of the model to evaluate against.
        /// </param>
        /// <param name='imageUrl'>
        /// An ImageUrl that contains the url of the image to be evaluated.
        /// </param>
        /// <param name='application'>
        /// Optional. Specifies the name of application using the endpoint.
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        Task<HttpOperationResponse<ImagePrediction>> ClassifyImageUrlWithHttpMessagesAsync(System.Guid projectId, string publishedName, ImageUrl imageUrl, string application = default(string), Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));

        /// <summary>
        /// Classify an image url without saving the result.
        /// </summary>
        /// <param name='projectId'>
        /// The project id.
        /// </param>
        /// <param name='publishedName'>
        /// Specifies the name of the model to evaluate against.
        /// </param>
        /// <param name='imageUrl'>
        /// An {Iris.Web.Api.Models.ImageUrl} that contains the url of the
        /// image to be evaluated.
        /// </param>
        /// <param name='application'>
        /// Optional. Specifies the name of application using the endpoint.
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        Task<HttpOperationResponse<ImagePrediction>> ClassifyImageUrlWithNoStoreWithHttpMessagesAsync(System.Guid projectId, string publishedName, ImageUrl imageUrl, string application = default(string), Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));

        /// <summary>
        /// Detect objects in an image and saves the result.
        /// </summary>
        /// <param name='projectId'>
        /// The project id.
        /// </param>
        /// <param name='publishedName'>
        /// Specifies the name of the model to evaluate against.
        /// </param>
        /// <param name='imageData'>
        /// Binary image data. Supported formats are JPEG, GIF, PNG, and BMP.
        /// Supports images up to 4MB.
        /// </param>
        /// <param name='application'>
        /// Optional. Specifies the name of application using the endpoint.
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        Task<HttpOperationResponse<ImagePrediction>> DetectImageWithHttpMessagesAsync(System.Guid projectId, string publishedName, Stream imageData, string application = default(string), Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));

        /// <summary>
        /// Detect objects in an image without saving the result.
        /// </summary>
        /// <param name='projectId'>
        /// The project id.
        /// </param>
        /// <param name='publishedName'>
        /// Specifies the name of the model to evaluate against.
        /// </param>
        /// <param name='imageData'>
        /// Binary image data. Supported formats are JPEG, GIF, PNG, and BMP.
        /// Supports images up to 4MB.
        /// </param>
        /// <param name='application'>
        /// Optional. Specifies the name of application using the endpoint.
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        Task<HttpOperationResponse<ImagePrediction>> DetectImageWithNoStoreWithHttpMessagesAsync(System.Guid projectId, string publishedName, Stream imageData, string application = default(string), Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));

        /// <summary>
        /// Detect objects in an image url and saves the result.
        /// </summary>
        /// <param name='projectId'>
        /// The project id.
        /// </param>
        /// <param name='publishedName'>
        /// Specifies the name of the model to evaluate against.
        /// </param>
        /// <param name='imageUrl'>
        /// An ImageUrl that contains the url of the image to be evaluated.
        /// </param>
        /// <param name='application'>
        /// Optional. Specifies the name of application using the endpoint.
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        Task<HttpOperationResponse<ImagePrediction>> DetectImageUrlWithHttpMessagesAsync(System.Guid projectId, string publishedName, ImageUrl imageUrl, string application = default(string), Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));

        /// <summary>
        /// Detect objects in an image url without saving the result.
        /// </summary>
        /// <param name='projectId'>
        /// The project id.
        /// </param>
        /// <param name='publishedName'>
        /// Specifies the name of the model to evaluate against.
        /// </param>
        /// <param name='imageUrl'>
        /// An {Iris.Web.Api.Models.ImageUrl} that contains the url of the
        /// image to be evaluated.
        /// </param>
        /// <param name='application'>
        /// Optional. Specifies the name of application using the endpoint.
        /// </param>
        /// <param name='customHeaders'>
        /// The headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        Task<HttpOperationResponse<ImagePrediction>> DetectImageUrlWithNoStoreWithHttpMessagesAsync(System.Guid projectId, string publishedName, ImageUrl imageUrl, string application = default(string), Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken));

    }
}
