// <auto-generated>
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.ContentModerator
{
    using Models;
    using System.Collections;
    using System.Collections.Generic;
    using System.IO;
    using System.Threading;
    using System.Threading.Tasks;

    /// <summary>
    /// Extension methods for Reviews.
    /// </summary>
    public static partial class ReviewsExtensions
    {
            /// <summary>
            /// Returns review details for the review Id passed.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='teamName'>
            /// Your Team Name.
            /// </param>
            /// <param name='reviewId'>
            /// Id of the review.
            /// </param>
            public static Review GetReview(this IReviews operations, string teamName, string reviewId)
            {
                return operations.GetReviewAsync(teamName, reviewId).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Returns review details for the review Id passed.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='teamName'>
            /// Your Team Name.
            /// </param>
            /// <param name='reviewId'>
            /// Id of the review.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<Review> GetReviewAsync(this IReviews operations, string teamName, string reviewId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetReviewWithHttpMessagesAsync(teamName, reviewId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Get the Job Details for a Job Id.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='teamName'>
            /// Your Team Name.
            /// </param>
            /// <param name='jobId'>
            /// Id of the job.
            /// </param>
            public static Job GetJobDetails(this IReviews operations, string teamName, string jobId)
            {
                return operations.GetJobDetailsAsync(teamName, jobId).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Get the Job Details for a Job Id.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='teamName'>
            /// Your Team Name.
            /// </param>
            /// <param name='jobId'>
            /// Id of the job.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<Job> GetJobDetailsAsync(this IReviews operations, string teamName, string jobId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetJobDetailsWithHttpMessagesAsync(teamName, jobId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// The reviews created would show up for Reviewers on your team. As Reviewers
            /// complete reviewing, results of the Review would be POSTED (i.e. HTTP POST)
            /// on the specified CallBackEndpoint.
            ///
            /// &lt;h3&gt;CallBack Schemas &lt;/h3&gt;
            /// &lt;h4&gt;Review Completion CallBack Sample&lt;/h4&gt;
            /// &lt;p&gt;
            /// {&lt;br/&gt;
            /// "ReviewId": "&lt;Review Id&gt;",&lt;br/&gt;
            /// "ModifiedOn": "2016-10-11T22:36:32.9934851Z",&lt;br/&gt;
            /// "ModifiedBy": "&lt;Name of the Reviewer&gt;",&lt;br/&gt;
            /// "CallBackType": "Review",&lt;br/&gt;
            /// "ContentId": "&lt;The ContentId that was specified input&gt;",&lt;br/&gt;
            /// "Metadata": {&lt;br/&gt;
            /// "adultscore": "0.xxx",&lt;br/&gt;
            /// "a": "False",&lt;br/&gt;
            /// "racyscore": "0.xxx",&lt;br/&gt;
            /// "r": "True"&lt;br/&gt;
            /// },&lt;br/&gt;
            /// "ReviewerResultTags": {&lt;br/&gt;
            /// "a": "False",&lt;br/&gt;
            /// "r": "True"&lt;br/&gt;
            /// }&lt;br/&gt;
            /// }&lt;br/&gt;
            ///
            /// &lt;/p&gt;.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='urlContentType'>
            /// The content type.
            /// </param>
            /// <param name='teamName'>
            /// Your team name.
            /// </param>
            /// <param name='createReviewBody'>
            /// Body for create reviews API
            /// </param>
            /// <param name='subTeam'>
            /// SubTeam of your team, you want to assign the created review to.
            /// </param>
            public static IList<string> CreateReviews(this IReviews operations, string urlContentType, string teamName, IList<CreateReviewBodyItem> createReviewBody, string subTeam = default(string))
            {
                return operations.CreateReviewsAsync(urlContentType, teamName, createReviewBody, subTeam).GetAwaiter().GetResult();
            }

            /// <summary>
            /// The reviews created would show up for Reviewers on your team. As Reviewers
            /// complete reviewing, results of the Review would be POSTED (i.e. HTTP POST)
            /// on the specified CallBackEndpoint.
            ///
            /// &lt;h3&gt;CallBack Schemas &lt;/h3&gt;
            /// &lt;h4&gt;Review Completion CallBack Sample&lt;/h4&gt;
            /// &lt;p&gt;
            /// {&lt;br/&gt;
            /// "ReviewId": "&lt;Review Id&gt;",&lt;br/&gt;
            /// "ModifiedOn": "2016-10-11T22:36:32.9934851Z",&lt;br/&gt;
            /// "ModifiedBy": "&lt;Name of the Reviewer&gt;",&lt;br/&gt;
            /// "CallBackType": "Review",&lt;br/&gt;
            /// "ContentId": "&lt;The ContentId that was specified input&gt;",&lt;br/&gt;
            /// "Metadata": {&lt;br/&gt;
            /// "adultscore": "0.xxx",&lt;br/&gt;
            /// "a": "False",&lt;br/&gt;
            /// "racyscore": "0.xxx",&lt;br/&gt;
            /// "r": "True"&lt;br/&gt;
            /// },&lt;br/&gt;
            /// "ReviewerResultTags": {&lt;br/&gt;
            /// "a": "False",&lt;br/&gt;
            /// "r": "True"&lt;br/&gt;
            /// }&lt;br/&gt;
            /// }&lt;br/&gt;
            ///
            /// &lt;/p&gt;.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='urlContentType'>
            /// The content type.
            /// </param>
            /// <param name='teamName'>
            /// Your team name.
            /// </param>
            /// <param name='createReviewBody'>
            /// Body for create reviews API
            /// </param>
            /// <param name='subTeam'>
            /// SubTeam of your team, you want to assign the created review to.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IList<string>> CreateReviewsAsync(this IReviews operations, string urlContentType, string teamName, IList<CreateReviewBodyItem> createReviewBody, string subTeam = default(string), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.CreateReviewsWithHttpMessagesAsync(urlContentType, teamName, createReviewBody, subTeam, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// A job Id will be returned for the content posted on this endpoint.
            ///
            /// Once the content is evaluated against the Workflow provided the review will
            /// be created or ignored based on the workflow expression.
            ///
            /// &lt;h3&gt;CallBack Schemas &lt;/h3&gt;
            ///
            /// &lt;p&gt;
            /// &lt;h4&gt;Job Completion CallBack Sample&lt;/h4&gt;&lt;br/&gt;
            ///
            /// {&lt;br/&gt;
            /// "JobId": "&lt;Job Id&gt;,&lt;br/&gt;
            /// "ReviewId": "&lt;Review Id, if the Job resulted in a Review to be
            /// created&gt;",&lt;br/&gt;
            /// "WorkFlowId": "default",&lt;br/&gt;
            /// "Status": "&lt;This will be one of Complete, InProgress,
            /// Error&gt;",&lt;br/&gt;
            /// "ContentType": "Image",&lt;br/&gt;
            /// "ContentId": "&lt;This is the ContentId that was specified on
            /// input&gt;",&lt;br/&gt;
            /// "CallBackType": "Job",&lt;br/&gt;
            /// "Metadata": {&lt;br/&gt;
            /// "adultscore": "0.xxx",&lt;br/&gt;
            /// "a": "False",&lt;br/&gt;
            /// "racyscore": "0.xxx",&lt;br/&gt;
            /// "r": "True"&lt;br/&gt;
            /// }&lt;br/&gt;
            /// }&lt;br/&gt;
            ///
            /// &lt;/p&gt;
            /// &lt;p&gt;
            /// &lt;h4&gt;Review Completion CallBack Sample&lt;/h4&gt;&lt;br/&gt;
            ///
            /// {
            /// "ReviewId": "&lt;Review Id&gt;",&lt;br/&gt;
            /// "ModifiedOn": "2016-10-11T22:36:32.9934851Z",&lt;br/&gt;
            /// "ModifiedBy": "&lt;Name of the Reviewer&gt;",&lt;br/&gt;
            /// "CallBackType": "Review",&lt;br/&gt;
            /// "ContentId": "&lt;The ContentId that was specified input&gt;",&lt;br/&gt;
            /// "Metadata": {&lt;br/&gt;
            /// "adultscore": "0.xxx",
            /// "a": "False",&lt;br/&gt;
            /// "racyscore": "0.xxx",&lt;br/&gt;
            /// "r": "True"&lt;br/&gt;
            /// },&lt;br/&gt;
            /// "ReviewerResultTags": {&lt;br/&gt;
            /// "a": "False",&lt;br/&gt;
            /// "r": "True"&lt;br/&gt;
            /// }&lt;br/&gt;
            /// }&lt;br/&gt;
            ///
            /// &lt;/p&gt;.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='teamName'>
            /// Your team name.
            /// </param>
            /// <param name='contentType'>
            /// Image, Text or Video. Possible values include: 'Image', 'Text', 'Video'
            /// </param>
            /// <param name='contentId'>
            /// Id/Name to identify the content submitted.
            /// </param>
            /// <param name='workflowName'>
            /// Workflow Name that you want to invoke.
            /// </param>
            /// <param name='jobContentType'>
            /// The content type. Possible values include: 'application/json', 'image/jpeg'
            /// </param>
            /// <param name='content'>
            /// Content to evaluate.
            /// </param>
            /// <param name='callBackEndpoint'>
            /// Callback endpoint for posting the create job result.
            /// </param>
            public static JobId CreateJob(this IReviews operations, string teamName, string contentType, string contentId, string workflowName, string jobContentType, Content content, string callBackEndpoint = default(string))
            {
                return operations.CreateJobAsync(teamName, contentType, contentId, workflowName, jobContentType, content, callBackEndpoint).GetAwaiter().GetResult();
            }

            /// <summary>
            /// A job Id will be returned for the content posted on this endpoint.
            ///
            /// Once the content is evaluated against the Workflow provided the review will
            /// be created or ignored based on the workflow expression.
            ///
            /// &lt;h3&gt;CallBack Schemas &lt;/h3&gt;
            ///
            /// &lt;p&gt;
            /// &lt;h4&gt;Job Completion CallBack Sample&lt;/h4&gt;&lt;br/&gt;
            ///
            /// {&lt;br/&gt;
            /// "JobId": "&lt;Job Id&gt;,&lt;br/&gt;
            /// "ReviewId": "&lt;Review Id, if the Job resulted in a Review to be
            /// created&gt;",&lt;br/&gt;
            /// "WorkFlowId": "default",&lt;br/&gt;
            /// "Status": "&lt;This will be one of Complete, InProgress,
            /// Error&gt;",&lt;br/&gt;
            /// "ContentType": "Image",&lt;br/&gt;
            /// "ContentId": "&lt;This is the ContentId that was specified on
            /// input&gt;",&lt;br/&gt;
            /// "CallBackType": "Job",&lt;br/&gt;
            /// "Metadata": {&lt;br/&gt;
            /// "adultscore": "0.xxx",&lt;br/&gt;
            /// "a": "False",&lt;br/&gt;
            /// "racyscore": "0.xxx",&lt;br/&gt;
            /// "r": "True"&lt;br/&gt;
            /// }&lt;br/&gt;
            /// }&lt;br/&gt;
            ///
            /// &lt;/p&gt;
            /// &lt;p&gt;
            /// &lt;h4&gt;Review Completion CallBack Sample&lt;/h4&gt;&lt;br/&gt;
            ///
            /// {
            /// "ReviewId": "&lt;Review Id&gt;",&lt;br/&gt;
            /// "ModifiedOn": "2016-10-11T22:36:32.9934851Z",&lt;br/&gt;
            /// "ModifiedBy": "&lt;Name of the Reviewer&gt;",&lt;br/&gt;
            /// "CallBackType": "Review",&lt;br/&gt;
            /// "ContentId": "&lt;The ContentId that was specified input&gt;",&lt;br/&gt;
            /// "Metadata": {&lt;br/&gt;
            /// "adultscore": "0.xxx",
            /// "a": "False",&lt;br/&gt;
            /// "racyscore": "0.xxx",&lt;br/&gt;
            /// "r": "True"&lt;br/&gt;
            /// },&lt;br/&gt;
            /// "ReviewerResultTags": {&lt;br/&gt;
            /// "a": "False",&lt;br/&gt;
            /// "r": "True"&lt;br/&gt;
            /// }&lt;br/&gt;
            /// }&lt;br/&gt;
            ///
            /// &lt;/p&gt;.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='teamName'>
            /// Your team name.
            /// </param>
            /// <param name='contentType'>
            /// Image, Text or Video. Possible values include: 'Image', 'Text', 'Video'
            /// </param>
            /// <param name='contentId'>
            /// Id/Name to identify the content submitted.
            /// </param>
            /// <param name='workflowName'>
            /// Workflow Name that you want to invoke.
            /// </param>
            /// <param name='jobContentType'>
            /// The content type. Possible values include: 'application/json', 'image/jpeg'
            /// </param>
            /// <param name='content'>
            /// Content to evaluate.
            /// </param>
            /// <param name='callBackEndpoint'>
            /// Callback endpoint for posting the create job result.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<JobId> CreateJobAsync(this IReviews operations, string teamName, string contentType, string contentId, string workflowName, string jobContentType, Content content, string callBackEndpoint = default(string), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.CreateJobWithHttpMessagesAsync(teamName, contentType, contentId, workflowName, jobContentType, content, callBackEndpoint, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// The reviews created would show up for Reviewers on your team. As Reviewers
            /// complete reviewing, results of the Review would be POSTED (i.e. HTTP POST)
            /// on the specified CallBackEndpoint.
            ///
            /// &lt;h3&gt;CallBack Schemas &lt;/h3&gt;
            /// &lt;h4&gt;Review Completion CallBack Sample&lt;/h4&gt;
            /// &lt;p&gt;
            /// {&lt;br/&gt;
            /// "ReviewId": "&lt;Review Id&gt;",&lt;br/&gt;
            /// "ModifiedOn": "2016-10-11T22:36:32.9934851Z",&lt;br/&gt;
            /// "ModifiedBy": "&lt;Name of the Reviewer&gt;",&lt;br/&gt;
            /// "CallBackType": "Review",&lt;br/&gt;
            /// "ContentId": "&lt;The ContentId that was specified input&gt;",&lt;br/&gt;
            /// "Metadata": {&lt;br/&gt;
            /// "adultscore": "0.xxx",&lt;br/&gt;
            /// "a": "False",&lt;br/&gt;
            /// "racyscore": "0.xxx",&lt;br/&gt;
            /// "r": "True"&lt;br/&gt;
            /// },&lt;br/&gt;
            /// "ReviewerResultTags": {&lt;br/&gt;
            /// "a": "False",&lt;br/&gt;
            /// "r": "True"&lt;br/&gt;
            /// }&lt;br/&gt;
            /// }&lt;br/&gt;
            ///
            /// &lt;/p&gt;.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='teamName'>
            /// Your team name.
            /// </param>
            /// <param name='reviewId'>
            /// Id of the review.
            /// </param>
            /// <param name='timescale'>
            /// Timescale of the video you are adding frames to.
            /// </param>
            public static void AddVideoFrame(this IReviews operations, string teamName, string reviewId, int? timescale = default(int?))
            {
                operations.AddVideoFrameAsync(teamName, reviewId, timescale).GetAwaiter().GetResult();
            }

            /// <summary>
            /// The reviews created would show up for Reviewers on your team. As Reviewers
            /// complete reviewing, results of the Review would be POSTED (i.e. HTTP POST)
            /// on the specified CallBackEndpoint.
            ///
            /// &lt;h3&gt;CallBack Schemas &lt;/h3&gt;
            /// &lt;h4&gt;Review Completion CallBack Sample&lt;/h4&gt;
            /// &lt;p&gt;
            /// {&lt;br/&gt;
            /// "ReviewId": "&lt;Review Id&gt;",&lt;br/&gt;
            /// "ModifiedOn": "2016-10-11T22:36:32.9934851Z",&lt;br/&gt;
            /// "ModifiedBy": "&lt;Name of the Reviewer&gt;",&lt;br/&gt;
            /// "CallBackType": "Review",&lt;br/&gt;
            /// "ContentId": "&lt;The ContentId that was specified input&gt;",&lt;br/&gt;
            /// "Metadata": {&lt;br/&gt;
            /// "adultscore": "0.xxx",&lt;br/&gt;
            /// "a": "False",&lt;br/&gt;
            /// "racyscore": "0.xxx",&lt;br/&gt;
            /// "r": "True"&lt;br/&gt;
            /// },&lt;br/&gt;
            /// "ReviewerResultTags": {&lt;br/&gt;
            /// "a": "False",&lt;br/&gt;
            /// "r": "True"&lt;br/&gt;
            /// }&lt;br/&gt;
            /// }&lt;br/&gt;
            ///
            /// &lt;/p&gt;.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='teamName'>
            /// Your team name.
            /// </param>
            /// <param name='reviewId'>
            /// Id of the review.
            /// </param>
            /// <param name='timescale'>
            /// Timescale of the video you are adding frames to.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task AddVideoFrameAsync(this IReviews operations, string teamName, string reviewId, int? timescale = default(int?), CancellationToken cancellationToken = default(CancellationToken))
            {
                (await operations.AddVideoFrameWithHttpMessagesAsync(teamName, reviewId, timescale, null, cancellationToken).ConfigureAwait(false)).Dispose();
            }

            /// <summary>
            /// The reviews created would show up for Reviewers on your team. As Reviewers
            /// complete reviewing, results of the Review would be POSTED (i.e. HTTP POST)
            /// on the specified CallBackEndpoint.
            ///
            /// &lt;h3&gt;CallBack Schemas &lt;/h3&gt;
            /// &lt;h4&gt;Review Completion CallBack Sample&lt;/h4&gt;
            /// &lt;p&gt;
            /// {&lt;br/&gt;
            /// "ReviewId": "&lt;Review Id&gt;",&lt;br/&gt;
            /// "ModifiedOn": "2016-10-11T22:36:32.9934851Z",&lt;br/&gt;
            /// "ModifiedBy": "&lt;Name of the Reviewer&gt;",&lt;br/&gt;
            /// "CallBackType": "Review",&lt;br/&gt;
            /// "ContentId": "&lt;The ContentId that was specified input&gt;",&lt;br/&gt;
            /// "Metadata": {&lt;br/&gt;
            /// "adultscore": "0.xxx",&lt;br/&gt;
            /// "a": "False",&lt;br/&gt;
            /// "racyscore": "0.xxx",&lt;br/&gt;
            /// "r": "True"&lt;br/&gt;
            /// },&lt;br/&gt;
            /// "ReviewerResultTags": {&lt;br/&gt;
            /// "a": "False",&lt;br/&gt;
            /// "r": "True"&lt;br/&gt;
            /// }&lt;br/&gt;
            /// }&lt;br/&gt;
            ///
            /// &lt;/p&gt;.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='teamName'>
            /// Your team name.
            /// </param>
            /// <param name='reviewId'>
            /// Id of the review.
            /// </param>
            /// <param name='startSeed'>
            /// Time stamp of the frame from where you want to start fetching the frames.
            /// </param>
            /// <param name='noOfRecords'>
            /// Number of frames to fetch.
            /// </param>
            /// <param name='filter'>
            /// Get frames filtered by tags.
            /// </param>
            public static Frames GetVideoFrames(this IReviews operations, string teamName, string reviewId, int? startSeed = default(int?), int? noOfRecords = default(int?), string filter = default(string))
            {
                return operations.GetVideoFramesAsync(teamName, reviewId, startSeed, noOfRecords, filter).GetAwaiter().GetResult();
            }

            /// <summary>
            /// The reviews created would show up for Reviewers on your team. As Reviewers
            /// complete reviewing, results of the Review would be POSTED (i.e. HTTP POST)
            /// on the specified CallBackEndpoint.
            ///
            /// &lt;h3&gt;CallBack Schemas &lt;/h3&gt;
            /// &lt;h4&gt;Review Completion CallBack Sample&lt;/h4&gt;
            /// &lt;p&gt;
            /// {&lt;br/&gt;
            /// "ReviewId": "&lt;Review Id&gt;",&lt;br/&gt;
            /// "ModifiedOn": "2016-10-11T22:36:32.9934851Z",&lt;br/&gt;
            /// "ModifiedBy": "&lt;Name of the Reviewer&gt;",&lt;br/&gt;
            /// "CallBackType": "Review",&lt;br/&gt;
            /// "ContentId": "&lt;The ContentId that was specified input&gt;",&lt;br/&gt;
            /// "Metadata": {&lt;br/&gt;
            /// "adultscore": "0.xxx",&lt;br/&gt;
            /// "a": "False",&lt;br/&gt;
            /// "racyscore": "0.xxx",&lt;br/&gt;
            /// "r": "True"&lt;br/&gt;
            /// },&lt;br/&gt;
            /// "ReviewerResultTags": {&lt;br/&gt;
            /// "a": "False",&lt;br/&gt;
            /// "r": "True"&lt;br/&gt;
            /// }&lt;br/&gt;
            /// }&lt;br/&gt;
            ///
            /// &lt;/p&gt;.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='teamName'>
            /// Your team name.
            /// </param>
            /// <param name='reviewId'>
            /// Id of the review.
            /// </param>
            /// <param name='startSeed'>
            /// Time stamp of the frame from where you want to start fetching the frames.
            /// </param>
            /// <param name='noOfRecords'>
            /// Number of frames to fetch.
            /// </param>
            /// <param name='filter'>
            /// Get frames filtered by tags.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<Frames> GetVideoFramesAsync(this IReviews operations, string teamName, string reviewId, int? startSeed = default(int?), int? noOfRecords = default(int?), string filter = default(string), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetVideoFramesWithHttpMessagesAsync(teamName, reviewId, startSeed, noOfRecords, filter, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Publish video review to make it available for review.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='teamName'>
            /// Your team name.
            /// </param>
            /// <param name='reviewId'>
            /// Id of the review.
            /// </param>
            public static void PublishVideoReview(this IReviews operations, string teamName, string reviewId)
            {
                operations.PublishVideoReviewAsync(teamName, reviewId).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Publish video review to make it available for review.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='teamName'>
            /// Your team name.
            /// </param>
            /// <param name='reviewId'>
            /// Id of the review.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task PublishVideoReviewAsync(this IReviews operations, string teamName, string reviewId, CancellationToken cancellationToken = default(CancellationToken))
            {
                (await operations.PublishVideoReviewWithHttpMessagesAsync(teamName, reviewId, null, cancellationToken).ConfigureAwait(false)).Dispose();
            }

            /// <summary>
            /// This API adds a transcript screen text result file for a video review.
            /// Transcript screen text result file is a result of Screen Text API . In
            /// order to generate transcript screen text result file , a transcript file
            /// has to be screened for profanity using Screen Text API.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='contentType'>
            /// The content type.
            /// </param>
            /// <param name='teamName'>
            /// Your team name.
            /// </param>
            /// <param name='reviewId'>
            /// Id of the review.
            /// </param>
            /// <param name='transcriptModerationBody'>
            /// Body for add video transcript moderation result API
            /// </param>
            public static void AddVideoTranscriptModerationResult(this IReviews operations, string contentType, string teamName, string reviewId, IList<TranscriptModerationBodyItem> transcriptModerationBody)
            {
                operations.AddVideoTranscriptModerationResultAsync(contentType, teamName, reviewId, transcriptModerationBody).GetAwaiter().GetResult();
            }

            /// <summary>
            /// This API adds a transcript screen text result file for a video review.
            /// Transcript screen text result file is a result of Screen Text API . In
            /// order to generate transcript screen text result file , a transcript file
            /// has to be screened for profanity using Screen Text API.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='contentType'>
            /// The content type.
            /// </param>
            /// <param name='teamName'>
            /// Your team name.
            /// </param>
            /// <param name='reviewId'>
            /// Id of the review.
            /// </param>
            /// <param name='transcriptModerationBody'>
            /// Body for add video transcript moderation result API
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task AddVideoTranscriptModerationResultAsync(this IReviews operations, string contentType, string teamName, string reviewId, IList<TranscriptModerationBodyItem> transcriptModerationBody, CancellationToken cancellationToken = default(CancellationToken))
            {
                (await operations.AddVideoTranscriptModerationResultWithHttpMessagesAsync(contentType, teamName, reviewId, transcriptModerationBody, null, cancellationToken).ConfigureAwait(false)).Dispose();
            }

            /// <summary>
            /// This API adds a transcript file (text version of all the words spoken in a
            /// video) to a video review. The file should be a valid WebVTT format.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='teamName'>
            /// Your team name.
            /// </param>
            /// <param name='reviewId'>
            /// Id of the review.
            /// </param>
            /// <param name='vTTfile'>
            /// Transcript file of the video.
            /// </param>
            public static void AddVideoTranscript(this IReviews operations, string teamName, string reviewId, Stream vTTfile)
            {
                operations.AddVideoTranscriptAsync(teamName, reviewId, vTTfile).GetAwaiter().GetResult();
            }

            /// <summary>
            /// This API adds a transcript file (text version of all the words spoken in a
            /// video) to a video review. The file should be a valid WebVTT format.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='teamName'>
            /// Your team name.
            /// </param>
            /// <param name='reviewId'>
            /// Id of the review.
            /// </param>
            /// <param name='vTTfile'>
            /// Transcript file of the video.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task AddVideoTranscriptAsync(this IReviews operations, string teamName, string reviewId, Stream vTTfile, CancellationToken cancellationToken = default(CancellationToken))
            {
                (await operations.AddVideoTranscriptWithHttpMessagesAsync(teamName, reviewId, vTTfile, null, cancellationToken).ConfigureAwait(false)).Dispose();
            }

            /// <summary>
            /// The reviews created would show up for Reviewers on your team. As Reviewers
            /// complete reviewing, results of the Review would be POSTED (i.e. HTTP POST)
            /// on the specified CallBackEndpoint.
            ///
            /// &lt;h3&gt;CallBack Schemas &lt;/h3&gt;
            /// &lt;h4&gt;Review Completion CallBack Sample&lt;/h4&gt;
            /// &lt;p&gt;
            /// {&lt;br/&gt;
            /// "ReviewId": "&lt;Review Id&gt;",&lt;br/&gt;
            /// "ModifiedOn": "2016-10-11T22:36:32.9934851Z",&lt;br/&gt;
            /// "ModifiedBy": "&lt;Name of the Reviewer&gt;",&lt;br/&gt;
            /// "CallBackType": "Review",&lt;br/&gt;
            /// "ContentId": "&lt;The ContentId that was specified input&gt;",&lt;br/&gt;
            /// "Metadata": {&lt;br/&gt;
            /// "adultscore": "0.xxx",&lt;br/&gt;
            /// "a": "False",&lt;br/&gt;
            /// "racyscore": "0.xxx",&lt;br/&gt;
            /// "r": "True"&lt;br/&gt;
            /// },&lt;br/&gt;
            /// "ReviewerResultTags": {&lt;br/&gt;
            /// "a": "False",&lt;br/&gt;
            /// "r": "True"&lt;br/&gt;
            /// }&lt;br/&gt;
            /// }&lt;br/&gt;
            ///
            /// &lt;/p&gt;.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='contentType'>
            /// The content type.
            /// </param>
            /// <param name='teamName'>
            /// Your team name.
            /// </param>
            /// <param name='createVideoReviewsBody'>
            /// Body for create reviews API
            /// </param>
            /// <param name='subTeam'>
            /// SubTeam of your team, you want to assign the created review to.
            /// </param>
            public static IList<string> CreateVideoReviews(this IReviews operations, string contentType, string teamName, IList<CreateVideoReviewsBodyItem> createVideoReviewsBody, string subTeam = default(string))
            {
                return operations.CreateVideoReviewsAsync(contentType, teamName, createVideoReviewsBody, subTeam).GetAwaiter().GetResult();
            }

            /// <summary>
            /// The reviews created would show up for Reviewers on your team. As Reviewers
            /// complete reviewing, results of the Review would be POSTED (i.e. HTTP POST)
            /// on the specified CallBackEndpoint.
            ///
            /// &lt;h3&gt;CallBack Schemas &lt;/h3&gt;
            /// &lt;h4&gt;Review Completion CallBack Sample&lt;/h4&gt;
            /// &lt;p&gt;
            /// {&lt;br/&gt;
            /// "ReviewId": "&lt;Review Id&gt;",&lt;br/&gt;
            /// "ModifiedOn": "2016-10-11T22:36:32.9934851Z",&lt;br/&gt;
            /// "ModifiedBy": "&lt;Name of the Reviewer&gt;",&lt;br/&gt;
            /// "CallBackType": "Review",&lt;br/&gt;
            /// "ContentId": "&lt;The ContentId that was specified input&gt;",&lt;br/&gt;
            /// "Metadata": {&lt;br/&gt;
            /// "adultscore": "0.xxx",&lt;br/&gt;
            /// "a": "False",&lt;br/&gt;
            /// "racyscore": "0.xxx",&lt;br/&gt;
            /// "r": "True"&lt;br/&gt;
            /// },&lt;br/&gt;
            /// "ReviewerResultTags": {&lt;br/&gt;
            /// "a": "False",&lt;br/&gt;
            /// "r": "True"&lt;br/&gt;
            /// }&lt;br/&gt;
            /// }&lt;br/&gt;
            ///
            /// &lt;/p&gt;.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='contentType'>
            /// The content type.
            /// </param>
            /// <param name='teamName'>
            /// Your team name.
            /// </param>
            /// <param name='createVideoReviewsBody'>
            /// Body for create reviews API
            /// </param>
            /// <param name='subTeam'>
            /// SubTeam of your team, you want to assign the created review to.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IList<string>> CreateVideoReviewsAsync(this IReviews operations, string contentType, string teamName, IList<CreateVideoReviewsBodyItem> createVideoReviewsBody, string subTeam = default(string), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.CreateVideoReviewsWithHttpMessagesAsync(contentType, teamName, createVideoReviewsBody, subTeam, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Use this method to add frames for a video review.Timescale: This parameter
            /// is a factor which is used to convert the timestamp on a frame into
            /// milliseconds. Timescale is provided in the output of the Content Moderator
            /// video media processor on the Azure Media Services platform.Timescale in the
            /// Video Moderation output is Ticks/Second.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='contentType'>
            /// The content type.
            /// </param>
            /// <param name='teamName'>
            /// Your team name.
            /// </param>
            /// <param name='reviewId'>
            /// Id of the review.
            /// </param>
            /// <param name='videoFrameBody'>
            /// Body for add video frames API
            /// </param>
            /// <param name='timescale'>
            /// Timescale of the video.
            /// </param>
            public static void AddVideoFrameUrl(this IReviews operations, string contentType, string teamName, string reviewId, IList<VideoFrameBodyItem> videoFrameBody, int? timescale = default(int?))
            {
                operations.AddVideoFrameUrlAsync(contentType, teamName, reviewId, videoFrameBody, timescale).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Use this method to add frames for a video review.Timescale: This parameter
            /// is a factor which is used to convert the timestamp on a frame into
            /// milliseconds. Timescale is provided in the output of the Content Moderator
            /// video media processor on the Azure Media Services platform.Timescale in the
            /// Video Moderation output is Ticks/Second.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='contentType'>
            /// The content type.
            /// </param>
            /// <param name='teamName'>
            /// Your team name.
            /// </param>
            /// <param name='reviewId'>
            /// Id of the review.
            /// </param>
            /// <param name='videoFrameBody'>
            /// Body for add video frames API
            /// </param>
            /// <param name='timescale'>
            /// Timescale of the video.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task AddVideoFrameUrlAsync(this IReviews operations, string contentType, string teamName, string reviewId, IList<VideoFrameBodyItem> videoFrameBody, int? timescale = default(int?), CancellationToken cancellationToken = default(CancellationToken))
            {
                (await operations.AddVideoFrameUrlWithHttpMessagesAsync(contentType, teamName, reviewId, videoFrameBody, timescale, null, cancellationToken).ConfigureAwait(false)).Dispose();
            }

            /// <summary>
            /// Use this method to add frames for a video review.Timescale: This parameter
            /// is a factor which is used to convert the timestamp on a frame into
            /// milliseconds. Timescale is provided in the output of the Content Moderator
            /// video media processor on the Azure Media Services platform.Timescale in the
            /// Video Moderation output is Ticks/Second.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='contentType'>
            /// The content type.
            /// </param>
            /// <param name='teamName'>
            /// Your team name.
            /// </param>
            /// <param name='reviewId'>
            /// Id of the review.
            /// </param>
            /// <param name='frameImageZip'>
            /// Zip file containing frame images.
            /// </param>
            /// <param name='frameMetadata'>
            /// Metadata of the frame.
            /// </param>
            /// <param name='timescale'>
            /// Timescale of the video .
            /// </param>
            public static void AddVideoFrameStream(this IReviews operations, string contentType, string teamName, string reviewId, Stream frameImageZip, string frameMetadata, int? timescale = default(int?))
            {
                operations.AddVideoFrameStreamAsync(contentType, teamName, reviewId, frameImageZip, frameMetadata, timescale).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Use this method to add frames for a video review.Timescale: This parameter
            /// is a factor which is used to convert the timestamp on a frame into
            /// milliseconds. Timescale is provided in the output of the Content Moderator
            /// video media processor on the Azure Media Services platform.Timescale in the
            /// Video Moderation output is Ticks/Second.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='contentType'>
            /// The content type.
            /// </param>
            /// <param name='teamName'>
            /// Your team name.
            /// </param>
            /// <param name='reviewId'>
            /// Id of the review.
            /// </param>
            /// <param name='frameImageZip'>
            /// Zip file containing frame images.
            /// </param>
            /// <param name='frameMetadata'>
            /// Metadata of the frame.
            /// </param>
            /// <param name='timescale'>
            /// Timescale of the video .
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task AddVideoFrameStreamAsync(this IReviews operations, string contentType, string teamName, string reviewId, Stream frameImageZip, string frameMetadata, int? timescale = default(int?), CancellationToken cancellationToken = default(CancellationToken))
            {
                (await operations.AddVideoFrameStreamWithHttpMessagesAsync(contentType, teamName, reviewId, frameImageZip, frameMetadata, timescale, null, cancellationToken).ConfigureAwait(false)).Dispose();
            }

    }
}
