// <auto-generated>
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.ContentModerator
{
    using Microsoft.Rest;
    using Models;
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.IO;
    using System.Linq;
    using System.Net;
    using System.Net.Http;
    using System.Net.Http.Headers;
    using System.Threading;
    using System.Threading.Tasks;

    /// <summary>
    /// Reviews operations.
    /// </summary>
    public partial class Reviews : IServiceOperations<ContentModeratorClient>, IReviews
    {
        /// <summary>
        /// Initializes a new instance of the Reviews class.
        /// </summary>
        /// <param name='client'>
        /// Reference to the service client.
        /// </param>
        /// <exception cref="System.ArgumentNullException">
        /// Thrown when a required parameter is null
        /// </exception>
        public Reviews(ContentModeratorClient client)
        {
            if (client == null)
            {
                throw new System.ArgumentNullException("client");
            }
            Client = client;
        }

        /// <summary>
        /// Gets a reference to the ContentModeratorClient
        /// </summary>
        public ContentModeratorClient Client { get; private set; }

        /// <summary>
        /// Returns review details for the review Id passed.
        /// </summary>
        /// <param name='teamName'>
        /// Your Team Name.
        /// </param>
        /// <param name='reviewId'>
        /// Id of the review.
        /// </param>
        /// <param name='customHeaders'>
        /// Headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        /// <exception cref="APIErrorException">
        /// Thrown when the operation returned an invalid status code
        /// </exception>
        /// <exception cref="SerializationException">
        /// Thrown when unable to deserialize the response
        /// </exception>
        /// <exception cref="ValidationException">
        /// Thrown when a required parameter is null
        /// </exception>
        /// <exception cref="System.ArgumentNullException">
        /// Thrown when a required parameter is null
        /// </exception>
        /// <return>
        /// A response object containing the response body and response headers.
        /// </return>
        public async Task<HttpOperationResponse<Review>> GetReviewWithHttpMessagesAsync(string teamName, string reviewId, Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken))
        {
            if (Client.Endpoint == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "this.Client.Endpoint");
            }
            if (teamName == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "teamName");
            }
            if (reviewId == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "reviewId");
            }
            // Tracing
            bool _shouldTrace = ServiceClientTracing.IsEnabled;
            string _invocationId = null;
            if (_shouldTrace)
            {
                _invocationId = ServiceClientTracing.NextInvocationId.ToString();
                Dictionary<string, object> tracingParameters = new Dictionary<string, object>();
                tracingParameters.Add("teamName", teamName);
                tracingParameters.Add("reviewId", reviewId);
                tracingParameters.Add("cancellationToken", cancellationToken);
                ServiceClientTracing.Enter(_invocationId, this, "GetReview", tracingParameters);
            }
            // Construct URL
            var _baseUrl = Client.BaseUri;
            var _url = _baseUrl + (_baseUrl.EndsWith("/") ? "" : "/") + "contentmoderator/review/v1.0/teams/{teamName}/reviews/{reviewId}";
            _url = _url.Replace("{Endpoint}", Client.Endpoint);
            _url = _url.Replace("{teamName}", System.Uri.EscapeDataString(teamName));
            _url = _url.Replace("{reviewId}", System.Uri.EscapeDataString(reviewId));
            // Create HTTP transport objects
            var _httpRequest = new HttpRequestMessage();
            HttpResponseMessage _httpResponse = null;
            _httpRequest.Method = new HttpMethod("GET");
            _httpRequest.RequestUri = new System.Uri(_url);
            // Set Headers


            if (customHeaders != null)
            {
                foreach(var _header in customHeaders)
                {
                    if (_httpRequest.Headers.Contains(_header.Key))
                    {
                        _httpRequest.Headers.Remove(_header.Key);
                    }
                    _httpRequest.Headers.TryAddWithoutValidation(_header.Key, _header.Value);
                }
            }

            // Serialize Request
            string _requestContent = null;
            // Set Credentials
            if (Client.Credentials != null)
            {
                cancellationToken.ThrowIfCancellationRequested();
                await Client.Credentials.ProcessHttpRequestAsync(_httpRequest, cancellationToken).ConfigureAwait(false);
            }
            // Send Request
            if (_shouldTrace)
            {
                ServiceClientTracing.SendRequest(_invocationId, _httpRequest);
            }
            cancellationToken.ThrowIfCancellationRequested();
            _httpResponse = await Client.HttpClient.SendAsync(_httpRequest, cancellationToken).ConfigureAwait(false);
            if (_shouldTrace)
            {
                ServiceClientTracing.ReceiveResponse(_invocationId, _httpResponse);
            }
            HttpStatusCode _statusCode = _httpResponse.StatusCode;
            cancellationToken.ThrowIfCancellationRequested();
            string _responseContent = null;
            if ((int)_statusCode != 200)
            {
                var ex = new APIErrorException(string.Format("Operation returned an invalid status code '{0}'", _statusCode));
                try
                {
                    _responseContent = await _httpResponse.Content.ReadAsStringAsync().ConfigureAwait(false);
                    APIError _errorBody =  Rest.Serialization.SafeJsonConvert.DeserializeObject<APIError>(_responseContent, Client.DeserializationSettings);
                    if (_errorBody != null)
                    {
                        ex.Body = _errorBody;
                    }
                }
                catch (JsonException)
                {
                    // Ignore the exception
                }
                ex.Request = new HttpRequestMessageWrapper(_httpRequest, _requestContent);
                ex.Response = new HttpResponseMessageWrapper(_httpResponse, _responseContent);
                if (_shouldTrace)
                {
                    ServiceClientTracing.Error(_invocationId, ex);
                }
                _httpRequest.Dispose();
                if (_httpResponse != null)
                {
                    _httpResponse.Dispose();
                }
                throw ex;
            }
            // Create Result
            var _result = new HttpOperationResponse<Review>();
            _result.Request = _httpRequest;
            _result.Response = _httpResponse;
            // Deserialize Response
            if ((int)_statusCode == 200)
            {
                _responseContent = await _httpResponse.Content.ReadAsStringAsync().ConfigureAwait(false);
                try
                {
                    _result.Body = Rest.Serialization.SafeJsonConvert.DeserializeObject<Review>(_responseContent, Client.DeserializationSettings);
                }
                catch (JsonException ex)
                {
                    _httpRequest.Dispose();
                    if (_httpResponse != null)
                    {
                        _httpResponse.Dispose();
                    }
                    throw new SerializationException("Unable to deserialize the response.", _responseContent, ex);
                }
            }
            if (_shouldTrace)
            {
                ServiceClientTracing.Exit(_invocationId, _result);
            }
            return _result;
        }

        /// <summary>
        /// Get the Job Details for a Job Id.
        /// </summary>
        /// <param name='teamName'>
        /// Your Team Name.
        /// </param>
        /// <param name='jobId'>
        /// Id of the job.
        /// </param>
        /// <param name='customHeaders'>
        /// Headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        /// <exception cref="APIErrorException">
        /// Thrown when the operation returned an invalid status code
        /// </exception>
        /// <exception cref="SerializationException">
        /// Thrown when unable to deserialize the response
        /// </exception>
        /// <exception cref="ValidationException">
        /// Thrown when a required parameter is null
        /// </exception>
        /// <exception cref="System.ArgumentNullException">
        /// Thrown when a required parameter is null
        /// </exception>
        /// <return>
        /// A response object containing the response body and response headers.
        /// </return>
        public async Task<HttpOperationResponse<Job>> GetJobDetailsWithHttpMessagesAsync(string teamName, string jobId, Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken))
        {
            if (Client.Endpoint == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "this.Client.Endpoint");
            }
            if (teamName == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "teamName");
            }
            if (jobId == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "jobId");
            }
            // Tracing
            bool _shouldTrace = ServiceClientTracing.IsEnabled;
            string _invocationId = null;
            if (_shouldTrace)
            {
                _invocationId = ServiceClientTracing.NextInvocationId.ToString();
                Dictionary<string, object> tracingParameters = new Dictionary<string, object>();
                tracingParameters.Add("teamName", teamName);
                tracingParameters.Add("jobId", jobId);
                tracingParameters.Add("cancellationToken", cancellationToken);
                ServiceClientTracing.Enter(_invocationId, this, "GetJobDetails", tracingParameters);
            }
            // Construct URL
            var _baseUrl = Client.BaseUri;
            var _url = _baseUrl + (_baseUrl.EndsWith("/") ? "" : "/") + "contentmoderator/review/v1.0/teams/{teamName}/jobs/{JobId}";
            _url = _url.Replace("{Endpoint}", Client.Endpoint);
            _url = _url.Replace("{teamName}", System.Uri.EscapeDataString(teamName));
            _url = _url.Replace("{JobId}", System.Uri.EscapeDataString(jobId));
            // Create HTTP transport objects
            var _httpRequest = new HttpRequestMessage();
            HttpResponseMessage _httpResponse = null;
            _httpRequest.Method = new HttpMethod("GET");
            _httpRequest.RequestUri = new System.Uri(_url);
            // Set Headers


            if (customHeaders != null)
            {
                foreach(var _header in customHeaders)
                {
                    if (_httpRequest.Headers.Contains(_header.Key))
                    {
                        _httpRequest.Headers.Remove(_header.Key);
                    }
                    _httpRequest.Headers.TryAddWithoutValidation(_header.Key, _header.Value);
                }
            }

            // Serialize Request
            string _requestContent = null;
            // Set Credentials
            if (Client.Credentials != null)
            {
                cancellationToken.ThrowIfCancellationRequested();
                await Client.Credentials.ProcessHttpRequestAsync(_httpRequest, cancellationToken).ConfigureAwait(false);
            }
            // Send Request
            if (_shouldTrace)
            {
                ServiceClientTracing.SendRequest(_invocationId, _httpRequest);
            }
            cancellationToken.ThrowIfCancellationRequested();
            _httpResponse = await Client.HttpClient.SendAsync(_httpRequest, cancellationToken).ConfigureAwait(false);
            if (_shouldTrace)
            {
                ServiceClientTracing.ReceiveResponse(_invocationId, _httpResponse);
            }
            HttpStatusCode _statusCode = _httpResponse.StatusCode;
            cancellationToken.ThrowIfCancellationRequested();
            string _responseContent = null;
            if ((int)_statusCode != 200)
            {
                var ex = new APIErrorException(string.Format("Operation returned an invalid status code '{0}'", _statusCode));
                try
                {
                    _responseContent = await _httpResponse.Content.ReadAsStringAsync().ConfigureAwait(false);
                    APIError _errorBody =  Rest.Serialization.SafeJsonConvert.DeserializeObject<APIError>(_responseContent, Client.DeserializationSettings);
                    if (_errorBody != null)
                    {
                        ex.Body = _errorBody;
                    }
                }
                catch (JsonException)
                {
                    // Ignore the exception
                }
                ex.Request = new HttpRequestMessageWrapper(_httpRequest, _requestContent);
                ex.Response = new HttpResponseMessageWrapper(_httpResponse, _responseContent);
                if (_shouldTrace)
                {
                    ServiceClientTracing.Error(_invocationId, ex);
                }
                _httpRequest.Dispose();
                if (_httpResponse != null)
                {
                    _httpResponse.Dispose();
                }
                throw ex;
            }
            // Create Result
            var _result = new HttpOperationResponse<Job>();
            _result.Request = _httpRequest;
            _result.Response = _httpResponse;
            // Deserialize Response
            if ((int)_statusCode == 200)
            {
                _responseContent = await _httpResponse.Content.ReadAsStringAsync().ConfigureAwait(false);
                try
                {
                    _result.Body = Rest.Serialization.SafeJsonConvert.DeserializeObject<Job>(_responseContent, Client.DeserializationSettings);
                }
                catch (JsonException ex)
                {
                    _httpRequest.Dispose();
                    if (_httpResponse != null)
                    {
                        _httpResponse.Dispose();
                    }
                    throw new SerializationException("Unable to deserialize the response.", _responseContent, ex);
                }
            }
            if (_shouldTrace)
            {
                ServiceClientTracing.Exit(_invocationId, _result);
            }
            return _result;
        }

        /// <summary>
        /// The reviews created would show up for Reviewers on your team. As Reviewers
        /// complete reviewing, results of the Review would be POSTED (i.e. HTTP POST)
        /// on the specified CallBackEndpoint.
        ///
        /// &lt;h3&gt;CallBack Schemas &lt;/h3&gt;
        /// &lt;h4&gt;Review Completion CallBack Sample&lt;/h4&gt;
        /// &lt;p&gt;
        /// {&lt;br/&gt;
        /// "ReviewId": "&lt;Review Id&gt;",&lt;br/&gt;
        /// "ModifiedOn": "2016-10-11T22:36:32.9934851Z",&lt;br/&gt;
        /// "ModifiedBy": "&lt;Name of the Reviewer&gt;",&lt;br/&gt;
        /// "CallBackType": "Review",&lt;br/&gt;
        /// "ContentId": "&lt;The ContentId that was specified input&gt;",&lt;br/&gt;
        /// "Metadata": {&lt;br/&gt;
        /// "adultscore": "0.xxx",&lt;br/&gt;
        /// "a": "False",&lt;br/&gt;
        /// "racyscore": "0.xxx",&lt;br/&gt;
        /// "r": "True"&lt;br/&gt;
        /// },&lt;br/&gt;
        /// "ReviewerResultTags": {&lt;br/&gt;
        /// "a": "False",&lt;br/&gt;
        /// "r": "True"&lt;br/&gt;
        /// }&lt;br/&gt;
        /// }&lt;br/&gt;
        ///
        /// &lt;/p&gt;.
        /// </summary>
        /// <param name='urlContentType'>
        /// The content type.
        /// </param>
        /// <param name='teamName'>
        /// Your team name.
        /// </param>
        /// <param name='createReviewBody'>
        /// Body for create reviews API
        /// </param>
        /// <param name='subTeam'>
        /// SubTeam of your team, you want to assign the created review to.
        /// </param>
        /// <param name='customHeaders'>
        /// Headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        /// <exception cref="APIErrorException">
        /// Thrown when the operation returned an invalid status code
        /// </exception>
        /// <exception cref="SerializationException">
        /// Thrown when unable to deserialize the response
        /// </exception>
        /// <exception cref="ValidationException">
        /// Thrown when a required parameter is null
        /// </exception>
        /// <exception cref="System.ArgumentNullException">
        /// Thrown when a required parameter is null
        /// </exception>
        /// <return>
        /// A response object containing the response body and response headers.
        /// </return>
        public async Task<HttpOperationResponse<IList<string>>> CreateReviewsWithHttpMessagesAsync(string urlContentType, string teamName, IList<CreateReviewBodyItem> createReviewBody, string subTeam = default(string), Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken))
        {
            if (Client.Endpoint == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "this.Client.Endpoint");
            }
            if (urlContentType == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "urlContentType");
            }
            if (teamName == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "teamName");
            }
            if (createReviewBody == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "createReviewBody");
            }
            if (createReviewBody != null)
            {
                foreach (var element in createReviewBody)
                {
                    if (element != null)
                    {
                        element.Validate();
                    }
                }
            }
            // Tracing
            bool _shouldTrace = ServiceClientTracing.IsEnabled;
            string _invocationId = null;
            if (_shouldTrace)
            {
                _invocationId = ServiceClientTracing.NextInvocationId.ToString();
                Dictionary<string, object> tracingParameters = new Dictionary<string, object>();
                tracingParameters.Add("urlContentType", urlContentType);
                tracingParameters.Add("teamName", teamName);
                tracingParameters.Add("subTeam", subTeam);
                tracingParameters.Add("createReviewBody", createReviewBody);
                tracingParameters.Add("cancellationToken", cancellationToken);
                ServiceClientTracing.Enter(_invocationId, this, "CreateReviews", tracingParameters);
            }
            // Construct URL
            var _baseUrl = Client.BaseUri;
            var _url = _baseUrl + (_baseUrl.EndsWith("/") ? "" : "/") + "contentmoderator/review/v1.0/teams/{teamName}/reviews";
            _url = _url.Replace("{Endpoint}", Client.Endpoint);
            _url = _url.Replace("{teamName}", System.Uri.EscapeDataString(teamName));
            List<string> _queryParameters = new List<string>();
            if (subTeam != null)
            {
                _queryParameters.Add(string.Format("subTeam={0}", System.Uri.EscapeDataString(subTeam)));
            }
            if (_queryParameters.Count > 0)
            {
                _url += "?" + string.Join("&", _queryParameters);
            }
            // Create HTTP transport objects
            var _httpRequest = new HttpRequestMessage();
            HttpResponseMessage _httpResponse = null;
            _httpRequest.Method = new HttpMethod("POST");
            _httpRequest.RequestUri = new System.Uri(_url);
            // Set Headers
            if (urlContentType != null)
            {
                if (_httpRequest.Headers.Contains("UrlContentType"))
                {
                    _httpRequest.Headers.Remove("UrlContentType");
                }
                _httpRequest.Headers.TryAddWithoutValidation("UrlContentType", urlContentType);
            }


            if (customHeaders != null)
            {
                foreach(var _header in customHeaders)
                {
                    if (_httpRequest.Headers.Contains(_header.Key))
                    {
                        _httpRequest.Headers.Remove(_header.Key);
                    }
                    _httpRequest.Headers.TryAddWithoutValidation(_header.Key, _header.Value);
                }
            }

            // Serialize Request
            string _requestContent = null;
            if(createReviewBody != null)
            {
                _requestContent = Rest.Serialization.SafeJsonConvert.SerializeObject(createReviewBody, Client.SerializationSettings);
                _httpRequest.Content = new StringContent(_requestContent, System.Text.Encoding.UTF8);
                _httpRequest.Content.Headers.ContentType =MediaTypeHeaderValue.Parse("application/json; charset=utf-8");
            }
            // Set Credentials
            if (Client.Credentials != null)
            {
                cancellationToken.ThrowIfCancellationRequested();
                await Client.Credentials.ProcessHttpRequestAsync(_httpRequest, cancellationToken).ConfigureAwait(false);
            }
            // Send Request
            if (_shouldTrace)
            {
                ServiceClientTracing.SendRequest(_invocationId, _httpRequest);
            }
            cancellationToken.ThrowIfCancellationRequested();
            _httpResponse = await Client.HttpClient.SendAsync(_httpRequest, cancellationToken).ConfigureAwait(false);
            if (_shouldTrace)
            {
                ServiceClientTracing.ReceiveResponse(_invocationId, _httpResponse);
            }
            HttpStatusCode _statusCode = _httpResponse.StatusCode;
            cancellationToken.ThrowIfCancellationRequested();
            string _responseContent = null;
            if ((int)_statusCode != 200)
            {
                var ex = new APIErrorException(string.Format("Operation returned an invalid status code '{0}'", _statusCode));
                try
                {
                    _responseContent = await _httpResponse.Content.ReadAsStringAsync().ConfigureAwait(false);
                    APIError _errorBody =  Rest.Serialization.SafeJsonConvert.DeserializeObject<APIError>(_responseContent, Client.DeserializationSettings);
                    if (_errorBody != null)
                    {
                        ex.Body = _errorBody;
                    }
                }
                catch (JsonException)
                {
                    // Ignore the exception
                }
                ex.Request = new HttpRequestMessageWrapper(_httpRequest, _requestContent);
                ex.Response = new HttpResponseMessageWrapper(_httpResponse, _responseContent);
                if (_shouldTrace)
                {
                    ServiceClientTracing.Error(_invocationId, ex);
                }
                _httpRequest.Dispose();
                if (_httpResponse != null)
                {
                    _httpResponse.Dispose();
                }
                throw ex;
            }
            // Create Result
            var _result = new HttpOperationResponse<IList<string>>();
            _result.Request = _httpRequest;
            _result.Response = _httpResponse;
            // Deserialize Response
            if ((int)_statusCode == 200)
            {
                _responseContent = await _httpResponse.Content.ReadAsStringAsync().ConfigureAwait(false);
                try
                {
                    _result.Body = Rest.Serialization.SafeJsonConvert.DeserializeObject<IList<string>>(_responseContent, Client.DeserializationSettings);
                }
                catch (JsonException ex)
                {
                    _httpRequest.Dispose();
                    if (_httpResponse != null)
                    {
                        _httpResponse.Dispose();
                    }
                    throw new SerializationException("Unable to deserialize the response.", _responseContent, ex);
                }
            }
            if (_shouldTrace)
            {
                ServiceClientTracing.Exit(_invocationId, _result);
            }
            return _result;
        }

        /// <summary>
        /// A job Id will be returned for the content posted on this endpoint.
        ///
        /// Once the content is evaluated against the Workflow provided the review will
        /// be created or ignored based on the workflow expression.
        ///
        /// &lt;h3&gt;CallBack Schemas &lt;/h3&gt;
        ///
        /// &lt;p&gt;
        /// &lt;h4&gt;Job Completion CallBack Sample&lt;/h4&gt;&lt;br/&gt;
        ///
        /// {&lt;br/&gt;
        /// "JobId": "&lt;Job Id&gt;,&lt;br/&gt;
        /// "ReviewId": "&lt;Review Id, if the Job resulted in a Review to be
        /// created&gt;",&lt;br/&gt;
        /// "WorkFlowId": "default",&lt;br/&gt;
        /// "Status": "&lt;This will be one of Complete, InProgress,
        /// Error&gt;",&lt;br/&gt;
        /// "ContentType": "Image",&lt;br/&gt;
        /// "ContentId": "&lt;This is the ContentId that was specified on
        /// input&gt;",&lt;br/&gt;
        /// "CallBackType": "Job",&lt;br/&gt;
        /// "Metadata": {&lt;br/&gt;
        /// "adultscore": "0.xxx",&lt;br/&gt;
        /// "a": "False",&lt;br/&gt;
        /// "racyscore": "0.xxx",&lt;br/&gt;
        /// "r": "True"&lt;br/&gt;
        /// }&lt;br/&gt;
        /// }&lt;br/&gt;
        ///
        /// &lt;/p&gt;
        /// &lt;p&gt;
        /// &lt;h4&gt;Review Completion CallBack Sample&lt;/h4&gt;&lt;br/&gt;
        ///
        /// {
        /// "ReviewId": "&lt;Review Id&gt;",&lt;br/&gt;
        /// "ModifiedOn": "2016-10-11T22:36:32.9934851Z",&lt;br/&gt;
        /// "ModifiedBy": "&lt;Name of the Reviewer&gt;",&lt;br/&gt;
        /// "CallBackType": "Review",&lt;br/&gt;
        /// "ContentId": "&lt;The ContentId that was specified input&gt;",&lt;br/&gt;
        /// "Metadata": {&lt;br/&gt;
        /// "adultscore": "0.xxx",
        /// "a": "False",&lt;br/&gt;
        /// "racyscore": "0.xxx",&lt;br/&gt;
        /// "r": "True"&lt;br/&gt;
        /// },&lt;br/&gt;
        /// "ReviewerResultTags": {&lt;br/&gt;
        /// "a": "False",&lt;br/&gt;
        /// "r": "True"&lt;br/&gt;
        /// }&lt;br/&gt;
        /// }&lt;br/&gt;
        ///
        /// &lt;/p&gt;.
        /// </summary>
        /// <param name='teamName'>
        /// Your team name.
        /// </param>
        /// <param name='contentType'>
        /// Image, Text or Video. Possible values include: 'Image', 'Text', 'Video'
        /// </param>
        /// <param name='contentId'>
        /// Id/Name to identify the content submitted.
        /// </param>
        /// <param name='workflowName'>
        /// Workflow Name that you want to invoke.
        /// </param>
        /// <param name='jobContentType'>
        /// The content type. Possible values include: 'application/json', 'image/jpeg'
        /// </param>
        /// <param name='content'>
        /// Content to evaluate.
        /// </param>
        /// <param name='callBackEndpoint'>
        /// Callback endpoint for posting the create job result.
        /// </param>
        /// <param name='customHeaders'>
        /// Headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        /// <exception cref="APIErrorException">
        /// Thrown when the operation returned an invalid status code
        /// </exception>
        /// <exception cref="SerializationException">
        /// Thrown when unable to deserialize the response
        /// </exception>
        /// <exception cref="ValidationException">
        /// Thrown when a required parameter is null
        /// </exception>
        /// <exception cref="System.ArgumentNullException">
        /// Thrown when a required parameter is null
        /// </exception>
        /// <return>
        /// A response object containing the response body and response headers.
        /// </return>
        public async Task<HttpOperationResponse<JobId>> CreateJobWithHttpMessagesAsync(string teamName, string contentType, string contentId, string workflowName, string jobContentType, Content content, string callBackEndpoint = default(string), Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken))
        {
            if (Client.Endpoint == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "this.Client.Endpoint");
            }
            if (teamName == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "teamName");
            }
            if (contentType == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "contentType");
            }
            if (contentId == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "contentId");
            }
            if (workflowName == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "workflowName");
            }
            if (jobContentType == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "jobContentType");
            }
            if (content == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "content");
            }
            if (content != null)
            {
                content.Validate();
            }
            // Tracing
            bool _shouldTrace = ServiceClientTracing.IsEnabled;
            string _invocationId = null;
            if (_shouldTrace)
            {
                _invocationId = ServiceClientTracing.NextInvocationId.ToString();
                Dictionary<string, object> tracingParameters = new Dictionary<string, object>();
                tracingParameters.Add("teamName", teamName);
                tracingParameters.Add("contentType", contentType);
                tracingParameters.Add("contentId", contentId);
                tracingParameters.Add("workflowName", workflowName);
                tracingParameters.Add("callBackEndpoint", callBackEndpoint);
                tracingParameters.Add("jobContentType", jobContentType);
                tracingParameters.Add("content", content);
                tracingParameters.Add("cancellationToken", cancellationToken);
                ServiceClientTracing.Enter(_invocationId, this, "CreateJob", tracingParameters);
            }
            // Construct URL
            var _baseUrl = Client.BaseUri;
            var _url = _baseUrl + (_baseUrl.EndsWith("/") ? "" : "/") + "contentmoderator/review/v1.0/teams/{teamName}/jobs";
            _url = _url.Replace("{Endpoint}", Client.Endpoint);
            _url = _url.Replace("{teamName}", System.Uri.EscapeDataString(teamName));
            List<string> _queryParameters = new List<string>();
            if (contentType != null)
            {
                _queryParameters.Add(string.Format("ContentType={0}", System.Uri.EscapeDataString(Rest.Serialization.SafeJsonConvert.SerializeObject(contentType, Client.SerializationSettings).Trim('"'))));
            }
            if (contentId != null)
            {
                _queryParameters.Add(string.Format("ContentId={0}", System.Uri.EscapeDataString(contentId)));
            }
            if (workflowName != null)
            {
                _queryParameters.Add(string.Format("WorkflowName={0}", System.Uri.EscapeDataString(workflowName)));
            }
            if (callBackEndpoint != null)
            {
                _queryParameters.Add(string.Format("CallBackEndpoint={0}", System.Uri.EscapeDataString(callBackEndpoint)));
            }
            if (_queryParameters.Count > 0)
            {
                _url += "?" + string.Join("&", _queryParameters);
            }
            // Create HTTP transport objects
            var _httpRequest = new HttpRequestMessage();
            HttpResponseMessage _httpResponse = null;
            _httpRequest.Method = new HttpMethod("POST");
            _httpRequest.RequestUri = new System.Uri(_url);
            // Set Headers


            if (customHeaders != null)
            {
                foreach(var _header in customHeaders)
                {
                    if (_httpRequest.Headers.Contains(_header.Key))
                    {
                        _httpRequest.Headers.Remove(_header.Key);
                    }
                    _httpRequest.Headers.TryAddWithoutValidation(_header.Key, _header.Value);
                }
            }

            // Serialize Request
            string _requestContent = null;
            if(content != null)
            {
                _requestContent = Rest.Serialization.SafeJsonConvert.SerializeObject(content, Client.SerializationSettings);
                _httpRequest.Content = new StringContent(_requestContent, System.Text.Encoding.UTF8);
                _httpRequest.Content.Headers.ContentType =MediaTypeHeaderValue.Parse("application/json; charset=utf-8");
            }
            // Set Credentials
            if (Client.Credentials != null)
            {
                cancellationToken.ThrowIfCancellationRequested();
                await Client.Credentials.ProcessHttpRequestAsync(_httpRequest, cancellationToken).ConfigureAwait(false);
            }
            // Send Request
            if (_shouldTrace)
            {
                ServiceClientTracing.SendRequest(_invocationId, _httpRequest);
            }
            cancellationToken.ThrowIfCancellationRequested();
            _httpResponse = await Client.HttpClient.SendAsync(_httpRequest, cancellationToken).ConfigureAwait(false);
            if (_shouldTrace)
            {
                ServiceClientTracing.ReceiveResponse(_invocationId, _httpResponse);
            }
            HttpStatusCode _statusCode = _httpResponse.StatusCode;
            cancellationToken.ThrowIfCancellationRequested();
            string _responseContent = null;
            if ((int)_statusCode != 200)
            {
                var ex = new APIErrorException(string.Format("Operation returned an invalid status code '{0}'", _statusCode));
                try
                {
                    _responseContent = await _httpResponse.Content.ReadAsStringAsync().ConfigureAwait(false);
                    APIError _errorBody =  Rest.Serialization.SafeJsonConvert.DeserializeObject<APIError>(_responseContent, Client.DeserializationSettings);
                    if (_errorBody != null)
                    {
                        ex.Body = _errorBody;
                    }
                }
                catch (JsonException)
                {
                    // Ignore the exception
                }
                ex.Request = new HttpRequestMessageWrapper(_httpRequest, _requestContent);
                ex.Response = new HttpResponseMessageWrapper(_httpResponse, _responseContent);
                if (_shouldTrace)
                {
                    ServiceClientTracing.Error(_invocationId, ex);
                }
                _httpRequest.Dispose();
                if (_httpResponse != null)
                {
                    _httpResponse.Dispose();
                }
                throw ex;
            }
            // Create Result
            var _result = new HttpOperationResponse<JobId>();
            _result.Request = _httpRequest;
            _result.Response = _httpResponse;
            // Deserialize Response
            if ((int)_statusCode == 200)
            {
                _responseContent = await _httpResponse.Content.ReadAsStringAsync().ConfigureAwait(false);
                try
                {
                    _result.Body = Rest.Serialization.SafeJsonConvert.DeserializeObject<JobId>(_responseContent, Client.DeserializationSettings);
                }
                catch (JsonException ex)
                {
                    _httpRequest.Dispose();
                    if (_httpResponse != null)
                    {
                        _httpResponse.Dispose();
                    }
                    throw new SerializationException("Unable to deserialize the response.", _responseContent, ex);
                }
            }
            if (_shouldTrace)
            {
                ServiceClientTracing.Exit(_invocationId, _result);
            }
            return _result;
        }

        /// <summary>
        /// The reviews created would show up for Reviewers on your team. As Reviewers
        /// complete reviewing, results of the Review would be POSTED (i.e. HTTP POST)
        /// on the specified CallBackEndpoint.
        ///
        /// &lt;h3&gt;CallBack Schemas &lt;/h3&gt;
        /// &lt;h4&gt;Review Completion CallBack Sample&lt;/h4&gt;
        /// &lt;p&gt;
        /// {&lt;br/&gt;
        /// "ReviewId": "&lt;Review Id&gt;",&lt;br/&gt;
        /// "ModifiedOn": "2016-10-11T22:36:32.9934851Z",&lt;br/&gt;
        /// "ModifiedBy": "&lt;Name of the Reviewer&gt;",&lt;br/&gt;
        /// "CallBackType": "Review",&lt;br/&gt;
        /// "ContentId": "&lt;The ContentId that was specified input&gt;",&lt;br/&gt;
        /// "Metadata": {&lt;br/&gt;
        /// "adultscore": "0.xxx",&lt;br/&gt;
        /// "a": "False",&lt;br/&gt;
        /// "racyscore": "0.xxx",&lt;br/&gt;
        /// "r": "True"&lt;br/&gt;
        /// },&lt;br/&gt;
        /// "ReviewerResultTags": {&lt;br/&gt;
        /// "a": "False",&lt;br/&gt;
        /// "r": "True"&lt;br/&gt;
        /// }&lt;br/&gt;
        /// }&lt;br/&gt;
        ///
        /// &lt;/p&gt;.
        /// </summary>
        /// <param name='teamName'>
        /// Your team name.
        /// </param>
        /// <param name='reviewId'>
        /// Id of the review.
        /// </param>
        /// <param name='timescale'>
        /// Timescale of the video you are adding frames to.
        /// </param>
        /// <param name='customHeaders'>
        /// Headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        /// <exception cref="APIErrorException">
        /// Thrown when the operation returned an invalid status code
        /// </exception>
        /// <exception cref="ValidationException">
        /// Thrown when a required parameter is null
        /// </exception>
        /// <exception cref="System.ArgumentNullException">
        /// Thrown when a required parameter is null
        /// </exception>
        /// <return>
        /// A response object containing the response body and response headers.
        /// </return>
        public async Task<HttpOperationResponse> AddVideoFrameWithHttpMessagesAsync(string teamName, string reviewId, int? timescale = default(int?), Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken))
        {
            if (Client.Endpoint == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "this.Client.Endpoint");
            }
            if (teamName == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "teamName");
            }
            if (reviewId == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "reviewId");
            }
            // Tracing
            bool _shouldTrace = ServiceClientTracing.IsEnabled;
            string _invocationId = null;
            if (_shouldTrace)
            {
                _invocationId = ServiceClientTracing.NextInvocationId.ToString();
                Dictionary<string, object> tracingParameters = new Dictionary<string, object>();
                tracingParameters.Add("teamName", teamName);
                tracingParameters.Add("reviewId", reviewId);
                tracingParameters.Add("timescale", timescale);
                tracingParameters.Add("cancellationToken", cancellationToken);
                ServiceClientTracing.Enter(_invocationId, this, "AddVideoFrame", tracingParameters);
            }
            // Construct URL
            var _baseUrl = Client.BaseUri;
            var _url = _baseUrl + (_baseUrl.EndsWith("/") ? "" : "/") + "contentmoderator/review/v1.0/teams/{teamName}/reviews/{reviewId}/frames";
            _url = _url.Replace("{Endpoint}", Client.Endpoint);
            _url = _url.Replace("{teamName}", System.Uri.EscapeDataString(teamName));
            _url = _url.Replace("{reviewId}", System.Uri.EscapeDataString(reviewId));
            List<string> _queryParameters = new List<string>();
            if (timescale != null)
            {
                _queryParameters.Add(string.Format("timescale={0}", System.Uri.EscapeDataString(Rest.Serialization.SafeJsonConvert.SerializeObject(timescale, Client.SerializationSettings).Trim('"'))));
            }
            if (_queryParameters.Count > 0)
            {
                _url += "?" + string.Join("&", _queryParameters);
            }
            // Create HTTP transport objects
            var _httpRequest = new HttpRequestMessage();
            HttpResponseMessage _httpResponse = null;
            _httpRequest.Method = new HttpMethod("POST");
            _httpRequest.RequestUri = new System.Uri(_url);
            // Set Headers


            if (customHeaders != null)
            {
                foreach(var _header in customHeaders)
                {
                    if (_httpRequest.Headers.Contains(_header.Key))
                    {
                        _httpRequest.Headers.Remove(_header.Key);
                    }
                    _httpRequest.Headers.TryAddWithoutValidation(_header.Key, _header.Value);
                }
            }

            // Serialize Request
            string _requestContent = null;
            // Set Credentials
            if (Client.Credentials != null)
            {
                cancellationToken.ThrowIfCancellationRequested();
                await Client.Credentials.ProcessHttpRequestAsync(_httpRequest, cancellationToken).ConfigureAwait(false);
            }
            // Send Request
            if (_shouldTrace)
            {
                ServiceClientTracing.SendRequest(_invocationId, _httpRequest);
            }
            cancellationToken.ThrowIfCancellationRequested();
            _httpResponse = await Client.HttpClient.SendAsync(_httpRequest, cancellationToken).ConfigureAwait(false);
            if (_shouldTrace)
            {
                ServiceClientTracing.ReceiveResponse(_invocationId, _httpResponse);
            }
            HttpStatusCode _statusCode = _httpResponse.StatusCode;
            cancellationToken.ThrowIfCancellationRequested();
            string _responseContent = null;
            if ((int)_statusCode != 200)
            {
                var ex = new APIErrorException(string.Format("Operation returned an invalid status code '{0}'", _statusCode));
                try
                {
                    _responseContent = await _httpResponse.Content.ReadAsStringAsync().ConfigureAwait(false);
                    APIError _errorBody =  Rest.Serialization.SafeJsonConvert.DeserializeObject<APIError>(_responseContent, Client.DeserializationSettings);
                    if (_errorBody != null)
                    {
                        ex.Body = _errorBody;
                    }
                }
                catch (JsonException)
                {
                    // Ignore the exception
                }
                ex.Request = new HttpRequestMessageWrapper(_httpRequest, _requestContent);
                ex.Response = new HttpResponseMessageWrapper(_httpResponse, _responseContent);
                if (_shouldTrace)
                {
                    ServiceClientTracing.Error(_invocationId, ex);
                }
                _httpRequest.Dispose();
                if (_httpResponse != null)
                {
                    _httpResponse.Dispose();
                }
                throw ex;
            }
            // Create Result
            var _result = new HttpOperationResponse();
            _result.Request = _httpRequest;
            _result.Response = _httpResponse;
            if (_shouldTrace)
            {
                ServiceClientTracing.Exit(_invocationId, _result);
            }
            return _result;
        }

        /// <summary>
        /// The reviews created would show up for Reviewers on your team. As Reviewers
        /// complete reviewing, results of the Review would be POSTED (i.e. HTTP POST)
        /// on the specified CallBackEndpoint.
        ///
        /// &lt;h3&gt;CallBack Schemas &lt;/h3&gt;
        /// &lt;h4&gt;Review Completion CallBack Sample&lt;/h4&gt;
        /// &lt;p&gt;
        /// {&lt;br/&gt;
        /// "ReviewId": "&lt;Review Id&gt;",&lt;br/&gt;
        /// "ModifiedOn": "2016-10-11T22:36:32.9934851Z",&lt;br/&gt;
        /// "ModifiedBy": "&lt;Name of the Reviewer&gt;",&lt;br/&gt;
        /// "CallBackType": "Review",&lt;br/&gt;
        /// "ContentId": "&lt;The ContentId that was specified input&gt;",&lt;br/&gt;
        /// "Metadata": {&lt;br/&gt;
        /// "adultscore": "0.xxx",&lt;br/&gt;
        /// "a": "False",&lt;br/&gt;
        /// "racyscore": "0.xxx",&lt;br/&gt;
        /// "r": "True"&lt;br/&gt;
        /// },&lt;br/&gt;
        /// "ReviewerResultTags": {&lt;br/&gt;
        /// "a": "False",&lt;br/&gt;
        /// "r": "True"&lt;br/&gt;
        /// }&lt;br/&gt;
        /// }&lt;br/&gt;
        ///
        /// &lt;/p&gt;.
        /// </summary>
        /// <param name='teamName'>
        /// Your team name.
        /// </param>
        /// <param name='reviewId'>
        /// Id of the review.
        /// </param>
        /// <param name='startSeed'>
        /// Time stamp of the frame from where you want to start fetching the frames.
        /// </param>
        /// <param name='noOfRecords'>
        /// Number of frames to fetch.
        /// </param>
        /// <param name='filter'>
        /// Get frames filtered by tags.
        /// </param>
        /// <param name='customHeaders'>
        /// Headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        /// <exception cref="APIErrorException">
        /// Thrown when the operation returned an invalid status code
        /// </exception>
        /// <exception cref="SerializationException">
        /// Thrown when unable to deserialize the response
        /// </exception>
        /// <exception cref="ValidationException">
        /// Thrown when a required parameter is null
        /// </exception>
        /// <exception cref="System.ArgumentNullException">
        /// Thrown when a required parameter is null
        /// </exception>
        /// <return>
        /// A response object containing the response body and response headers.
        /// </return>
        public async Task<HttpOperationResponse<Frames>> GetVideoFramesWithHttpMessagesAsync(string teamName, string reviewId, int? startSeed = default(int?), int? noOfRecords = default(int?), string filter = default(string), Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken))
        {
            if (Client.Endpoint == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "this.Client.Endpoint");
            }
            if (teamName == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "teamName");
            }
            if (reviewId == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "reviewId");
            }
            // Tracing
            bool _shouldTrace = ServiceClientTracing.IsEnabled;
            string _invocationId = null;
            if (_shouldTrace)
            {
                _invocationId = ServiceClientTracing.NextInvocationId.ToString();
                Dictionary<string, object> tracingParameters = new Dictionary<string, object>();
                tracingParameters.Add("teamName", teamName);
                tracingParameters.Add("reviewId", reviewId);
                tracingParameters.Add("startSeed", startSeed);
                tracingParameters.Add("noOfRecords", noOfRecords);
                tracingParameters.Add("filter", filter);
                tracingParameters.Add("cancellationToken", cancellationToken);
                ServiceClientTracing.Enter(_invocationId, this, "GetVideoFrames", tracingParameters);
            }
            // Construct URL
            var _baseUrl = Client.BaseUri;
            var _url = _baseUrl + (_baseUrl.EndsWith("/") ? "" : "/") + "contentmoderator/review/v1.0/teams/{teamName}/reviews/{reviewId}/frames";
            _url = _url.Replace("{Endpoint}", Client.Endpoint);
            _url = _url.Replace("{teamName}", System.Uri.EscapeDataString(teamName));
            _url = _url.Replace("{reviewId}", System.Uri.EscapeDataString(reviewId));
            List<string> _queryParameters = new List<string>();
            if (startSeed != null)
            {
                _queryParameters.Add(string.Format("startSeed={0}", System.Uri.EscapeDataString(Rest.Serialization.SafeJsonConvert.SerializeObject(startSeed, Client.SerializationSettings).Trim('"'))));
            }
            if (noOfRecords != null)
            {
                _queryParameters.Add(string.Format("noOfRecords={0}", System.Uri.EscapeDataString(Rest.Serialization.SafeJsonConvert.SerializeObject(noOfRecords, Client.SerializationSettings).Trim('"'))));
            }
            if (filter != null)
            {
                _queryParameters.Add(string.Format("filter={0}", System.Uri.EscapeDataString(filter)));
            }
            if (_queryParameters.Count > 0)
            {
                _url += "?" + string.Join("&", _queryParameters);
            }
            // Create HTTP transport objects
            var _httpRequest = new HttpRequestMessage();
            HttpResponseMessage _httpResponse = null;
            _httpRequest.Method = new HttpMethod("GET");
            _httpRequest.RequestUri = new System.Uri(_url);
            // Set Headers


            if (customHeaders != null)
            {
                foreach(var _header in customHeaders)
                {
                    if (_httpRequest.Headers.Contains(_header.Key))
                    {
                        _httpRequest.Headers.Remove(_header.Key);
                    }
                    _httpRequest.Headers.TryAddWithoutValidation(_header.Key, _header.Value);
                }
            }

            // Serialize Request
            string _requestContent = null;
            // Set Credentials
            if (Client.Credentials != null)
            {
                cancellationToken.ThrowIfCancellationRequested();
                await Client.Credentials.ProcessHttpRequestAsync(_httpRequest, cancellationToken).ConfigureAwait(false);
            }
            // Send Request
            if (_shouldTrace)
            {
                ServiceClientTracing.SendRequest(_invocationId, _httpRequest);
            }
            cancellationToken.ThrowIfCancellationRequested();
            _httpResponse = await Client.HttpClient.SendAsync(_httpRequest, cancellationToken).ConfigureAwait(false);
            if (_shouldTrace)
            {
                ServiceClientTracing.ReceiveResponse(_invocationId, _httpResponse);
            }
            HttpStatusCode _statusCode = _httpResponse.StatusCode;
            cancellationToken.ThrowIfCancellationRequested();
            string _responseContent = null;
            if ((int)_statusCode != 200)
            {
                var ex = new APIErrorException(string.Format("Operation returned an invalid status code '{0}'", _statusCode));
                try
                {
                    _responseContent = await _httpResponse.Content.ReadAsStringAsync().ConfigureAwait(false);
                    APIError _errorBody =  Rest.Serialization.SafeJsonConvert.DeserializeObject<APIError>(_responseContent, Client.DeserializationSettings);
                    if (_errorBody != null)
                    {
                        ex.Body = _errorBody;
                    }
                }
                catch (JsonException)
                {
                    // Ignore the exception
                }
                ex.Request = new HttpRequestMessageWrapper(_httpRequest, _requestContent);
                ex.Response = new HttpResponseMessageWrapper(_httpResponse, _responseContent);
                if (_shouldTrace)
                {
                    ServiceClientTracing.Error(_invocationId, ex);
                }
                _httpRequest.Dispose();
                if (_httpResponse != null)
                {
                    _httpResponse.Dispose();
                }
                throw ex;
            }
            // Create Result
            var _result = new HttpOperationResponse<Frames>();
            _result.Request = _httpRequest;
            _result.Response = _httpResponse;
            // Deserialize Response
            if ((int)_statusCode == 200)
            {
                _responseContent = await _httpResponse.Content.ReadAsStringAsync().ConfigureAwait(false);
                try
                {
                    _result.Body = Rest.Serialization.SafeJsonConvert.DeserializeObject<Frames>(_responseContent, Client.DeserializationSettings);
                }
                catch (JsonException ex)
                {
                    _httpRequest.Dispose();
                    if (_httpResponse != null)
                    {
                        _httpResponse.Dispose();
                    }
                    throw new SerializationException("Unable to deserialize the response.", _responseContent, ex);
                }
            }
            if (_shouldTrace)
            {
                ServiceClientTracing.Exit(_invocationId, _result);
            }
            return _result;
        }

        /// <summary>
        /// Publish video review to make it available for review.
        /// </summary>
        /// <param name='teamName'>
        /// Your team name.
        /// </param>
        /// <param name='reviewId'>
        /// Id of the review.
        /// </param>
        /// <param name='customHeaders'>
        /// Headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        /// <exception cref="APIErrorException">
        /// Thrown when the operation returned an invalid status code
        /// </exception>
        /// <exception cref="ValidationException">
        /// Thrown when a required parameter is null
        /// </exception>
        /// <exception cref="System.ArgumentNullException">
        /// Thrown when a required parameter is null
        /// </exception>
        /// <return>
        /// A response object containing the response body and response headers.
        /// </return>
        public async Task<HttpOperationResponse> PublishVideoReviewWithHttpMessagesAsync(string teamName, string reviewId, Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken))
        {
            if (Client.Endpoint == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "this.Client.Endpoint");
            }
            if (teamName == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "teamName");
            }
            if (reviewId == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "reviewId");
            }
            // Tracing
            bool _shouldTrace = ServiceClientTracing.IsEnabled;
            string _invocationId = null;
            if (_shouldTrace)
            {
                _invocationId = ServiceClientTracing.NextInvocationId.ToString();
                Dictionary<string, object> tracingParameters = new Dictionary<string, object>();
                tracingParameters.Add("teamName", teamName);
                tracingParameters.Add("reviewId", reviewId);
                tracingParameters.Add("cancellationToken", cancellationToken);
                ServiceClientTracing.Enter(_invocationId, this, "PublishVideoReview", tracingParameters);
            }
            // Construct URL
            var _baseUrl = Client.BaseUri;
            var _url = _baseUrl + (_baseUrl.EndsWith("/") ? "" : "/") + "contentmoderator/review/v1.0/teams/{teamName}/reviews/{reviewId}/publish";
            _url = _url.Replace("{Endpoint}", Client.Endpoint);
            _url = _url.Replace("{teamName}", System.Uri.EscapeDataString(teamName));
            _url = _url.Replace("{reviewId}", System.Uri.EscapeDataString(reviewId));
            // Create HTTP transport objects
            var _httpRequest = new HttpRequestMessage();
            HttpResponseMessage _httpResponse = null;
            _httpRequest.Method = new HttpMethod("POST");
            _httpRequest.RequestUri = new System.Uri(_url);
            // Set Headers


            if (customHeaders != null)
            {
                foreach(var _header in customHeaders)
                {
                    if (_httpRequest.Headers.Contains(_header.Key))
                    {
                        _httpRequest.Headers.Remove(_header.Key);
                    }
                    _httpRequest.Headers.TryAddWithoutValidation(_header.Key, _header.Value);
                }
            }

            // Serialize Request
            string _requestContent = null;
            // Set Credentials
            if (Client.Credentials != null)
            {
                cancellationToken.ThrowIfCancellationRequested();
                await Client.Credentials.ProcessHttpRequestAsync(_httpRequest, cancellationToken).ConfigureAwait(false);
            }
            // Send Request
            if (_shouldTrace)
            {
                ServiceClientTracing.SendRequest(_invocationId, _httpRequest);
            }
            cancellationToken.ThrowIfCancellationRequested();
            _httpResponse = await Client.HttpClient.SendAsync(_httpRequest, cancellationToken).ConfigureAwait(false);
            if (_shouldTrace)
            {
                ServiceClientTracing.ReceiveResponse(_invocationId, _httpResponse);
            }
            HttpStatusCode _statusCode = _httpResponse.StatusCode;
            cancellationToken.ThrowIfCancellationRequested();
            string _responseContent = null;
            if ((int)_statusCode != 204)
            {
                var ex = new APIErrorException(string.Format("Operation returned an invalid status code '{0}'", _statusCode));
                try
                {
                    _responseContent = await _httpResponse.Content.ReadAsStringAsync().ConfigureAwait(false);
                    APIError _errorBody =  Rest.Serialization.SafeJsonConvert.DeserializeObject<APIError>(_responseContent, Client.DeserializationSettings);
                    if (_errorBody != null)
                    {
                        ex.Body = _errorBody;
                    }
                }
                catch (JsonException)
                {
                    // Ignore the exception
                }
                ex.Request = new HttpRequestMessageWrapper(_httpRequest, _requestContent);
                ex.Response = new HttpResponseMessageWrapper(_httpResponse, _responseContent);
                if (_shouldTrace)
                {
                    ServiceClientTracing.Error(_invocationId, ex);
                }
                _httpRequest.Dispose();
                if (_httpResponse != null)
                {
                    _httpResponse.Dispose();
                }
                throw ex;
            }
            // Create Result
            var _result = new HttpOperationResponse();
            _result.Request = _httpRequest;
            _result.Response = _httpResponse;
            if (_shouldTrace)
            {
                ServiceClientTracing.Exit(_invocationId, _result);
            }
            return _result;
        }

        /// <summary>
        /// This API adds a transcript screen text result file for a video review.
        /// Transcript screen text result file is a result of Screen Text API . In
        /// order to generate transcript screen text result file , a transcript file
        /// has to be screened for profanity using Screen Text API.
        /// </summary>
        /// <param name='contentType'>
        /// The content type.
        /// </param>
        /// <param name='teamName'>
        /// Your team name.
        /// </param>
        /// <param name='reviewId'>
        /// Id of the review.
        /// </param>
        /// <param name='transcriptModerationBody'>
        /// Body for add video transcript moderation result API
        /// </param>
        /// <param name='customHeaders'>
        /// Headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        /// <exception cref="APIErrorException">
        /// Thrown when the operation returned an invalid status code
        /// </exception>
        /// <exception cref="ValidationException">
        /// Thrown when a required parameter is null
        /// </exception>
        /// <exception cref="System.ArgumentNullException">
        /// Thrown when a required parameter is null
        /// </exception>
        /// <return>
        /// A response object containing the response body and response headers.
        /// </return>
        public async Task<HttpOperationResponse> AddVideoTranscriptModerationResultWithHttpMessagesAsync(string contentType, string teamName, string reviewId, IList<TranscriptModerationBodyItem> transcriptModerationBody, Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken))
        {
            if (Client.Endpoint == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "this.Client.Endpoint");
            }
            if (contentType == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "contentType");
            }
            if (teamName == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "teamName");
            }
            if (reviewId == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "reviewId");
            }
            if (transcriptModerationBody == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "transcriptModerationBody");
            }
            if (transcriptModerationBody != null)
            {
                foreach (var element in transcriptModerationBody)
                {
                    if (element != null)
                    {
                        element.Validate();
                    }
                }
            }
            // Tracing
            bool _shouldTrace = ServiceClientTracing.IsEnabled;
            string _invocationId = null;
            if (_shouldTrace)
            {
                _invocationId = ServiceClientTracing.NextInvocationId.ToString();
                Dictionary<string, object> tracingParameters = new Dictionary<string, object>();
                tracingParameters.Add("contentType", contentType);
                tracingParameters.Add("teamName", teamName);
                tracingParameters.Add("reviewId", reviewId);
                tracingParameters.Add("transcriptModerationBody", transcriptModerationBody);
                tracingParameters.Add("cancellationToken", cancellationToken);
                ServiceClientTracing.Enter(_invocationId, this, "AddVideoTranscriptModerationResult", tracingParameters);
            }
            // Construct URL
            var _baseUrl = Client.BaseUri;
            var _url = _baseUrl + (_baseUrl.EndsWith("/") ? "" : "/") + "contentmoderator/review/v1.0/teams/{teamName}/reviews/{reviewId}/transcriptmoderationresult";
            _url = _url.Replace("{Endpoint}", Client.Endpoint);
            _url = _url.Replace("{teamName}", System.Uri.EscapeDataString(teamName));
            _url = _url.Replace("{reviewId}", System.Uri.EscapeDataString(reviewId));
            // Create HTTP transport objects
            var _httpRequest = new HttpRequestMessage();
            HttpResponseMessage _httpResponse = null;
            _httpRequest.Method = new HttpMethod("PUT");
            _httpRequest.RequestUri = new System.Uri(_url);
            // Set Headers


            if (customHeaders != null)
            {
                foreach(var _header in customHeaders)
                {
                    if (_httpRequest.Headers.Contains(_header.Key))
                    {
                        _httpRequest.Headers.Remove(_header.Key);
                    }
                    _httpRequest.Headers.TryAddWithoutValidation(_header.Key, _header.Value);
                }
            }

            // Serialize Request
            string _requestContent = null;
            if(transcriptModerationBody != null)
            {
                _requestContent = Rest.Serialization.SafeJsonConvert.SerializeObject(transcriptModerationBody, Client.SerializationSettings);
                _httpRequest.Content = new StringContent(_requestContent, System.Text.Encoding.UTF8);
                _httpRequest.Content.Headers.ContentType =MediaTypeHeaderValue.Parse("application/json; charset=utf-8");
            }
            // Set Credentials
            if (Client.Credentials != null)
            {
                cancellationToken.ThrowIfCancellationRequested();
                await Client.Credentials.ProcessHttpRequestAsync(_httpRequest, cancellationToken).ConfigureAwait(false);
            }
            // Send Request
            if (_shouldTrace)
            {
                ServiceClientTracing.SendRequest(_invocationId, _httpRequest);
            }
            cancellationToken.ThrowIfCancellationRequested();
            _httpResponse = await Client.HttpClient.SendAsync(_httpRequest, cancellationToken).ConfigureAwait(false);
            if (_shouldTrace)
            {
                ServiceClientTracing.ReceiveResponse(_invocationId, _httpResponse);
            }
            HttpStatusCode _statusCode = _httpResponse.StatusCode;
            cancellationToken.ThrowIfCancellationRequested();
            string _responseContent = null;
            if ((int)_statusCode != 204)
            {
                var ex = new APIErrorException(string.Format("Operation returned an invalid status code '{0}'", _statusCode));
                try
                {
                    _responseContent = await _httpResponse.Content.ReadAsStringAsync().ConfigureAwait(false);
                    APIError _errorBody =  Rest.Serialization.SafeJsonConvert.DeserializeObject<APIError>(_responseContent, Client.DeserializationSettings);
                    if (_errorBody != null)
                    {
                        ex.Body = _errorBody;
                    }
                }
                catch (JsonException)
                {
                    // Ignore the exception
                }
                ex.Request = new HttpRequestMessageWrapper(_httpRequest, _requestContent);
                ex.Response = new HttpResponseMessageWrapper(_httpResponse, _responseContent);
                if (_shouldTrace)
                {
                    ServiceClientTracing.Error(_invocationId, ex);
                }
                _httpRequest.Dispose();
                if (_httpResponse != null)
                {
                    _httpResponse.Dispose();
                }
                throw ex;
            }
            // Create Result
            var _result = new HttpOperationResponse();
            _result.Request = _httpRequest;
            _result.Response = _httpResponse;
            if (_shouldTrace)
            {
                ServiceClientTracing.Exit(_invocationId, _result);
            }
            return _result;
        }

        /// <summary>
        /// This API adds a transcript file (text version of all the words spoken in a
        /// video) to a video review. The file should be a valid WebVTT format.
        /// </summary>
        /// <param name='teamName'>
        /// Your team name.
        /// </param>
        /// <param name='reviewId'>
        /// Id of the review.
        /// </param>
        /// <param name='vTTfile'>
        /// Transcript file of the video.
        /// </param>
        /// <param name='customHeaders'>
        /// Headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        /// <exception cref="APIErrorException">
        /// Thrown when the operation returned an invalid status code
        /// </exception>
        /// <exception cref="ValidationException">
        /// Thrown when a required parameter is null
        /// </exception>
        /// <exception cref="System.ArgumentNullException">
        /// Thrown when a required parameter is null
        /// </exception>
        /// <return>
        /// A response object containing the response body and response headers.
        /// </return>
        public async Task<HttpOperationResponse> AddVideoTranscriptWithHttpMessagesAsync(string teamName, string reviewId, Stream vTTfile, Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken))
        {
            if (Client.Endpoint == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "this.Client.Endpoint");
            }
            if (teamName == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "teamName");
            }
            if (reviewId == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "reviewId");
            }
            if (vTTfile == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "vTTfile");
            }
            string contentType = "text/plain";
            // Tracing
            bool _shouldTrace = ServiceClientTracing.IsEnabled;
            string _invocationId = null;
            if (_shouldTrace)
            {
                _invocationId = ServiceClientTracing.NextInvocationId.ToString();
                Dictionary<string, object> tracingParameters = new Dictionary<string, object>();
                tracingParameters.Add("teamName", teamName);
                tracingParameters.Add("reviewId", reviewId);
                tracingParameters.Add("contentType", contentType);
                tracingParameters.Add("vTTfile", vTTfile);
                tracingParameters.Add("cancellationToken", cancellationToken);
                ServiceClientTracing.Enter(_invocationId, this, "AddVideoTranscript", tracingParameters);
            }
            // Construct URL
            var _baseUrl = Client.BaseUri;
            var _url = _baseUrl + (_baseUrl.EndsWith("/") ? "" : "/") + "contentmoderator/review/v1.0/teams/{teamName}/reviews/{reviewId}/transcript";
            _url = _url.Replace("{Endpoint}", Client.Endpoint);
            _url = _url.Replace("{teamName}", System.Uri.EscapeDataString(teamName));
            _url = _url.Replace("{reviewId}", System.Uri.EscapeDataString(reviewId));
            // Create HTTP transport objects
            var _httpRequest = new HttpRequestMessage();
            HttpResponseMessage _httpResponse = null;
            _httpRequest.Method = new HttpMethod("PUT");
            _httpRequest.RequestUri = new System.Uri(_url);
            // Set Headers


            if (customHeaders != null)
            {
                foreach(var _header in customHeaders)
                {
                    if (_httpRequest.Headers.Contains(_header.Key))
                    {
                        _httpRequest.Headers.Remove(_header.Key);
                    }
                    _httpRequest.Headers.TryAddWithoutValidation(_header.Key, _header.Value);
                }
            }

            // Serialize Request
            string _requestContent = null;
            if(vTTfile == null)
            {
              throw new System.ArgumentNullException("vTTfile");
            }
            if (vTTfile != null && vTTfile != Stream.Null)
            {
                _httpRequest.Content = new StreamContent(vTTfile);
                _httpRequest.Content.Headers.ContentType =MediaTypeHeaderValue.Parse("text/plain");
            }
            // Set Credentials
            if (Client.Credentials != null)
            {
                cancellationToken.ThrowIfCancellationRequested();
                await Client.Credentials.ProcessHttpRequestAsync(_httpRequest, cancellationToken).ConfigureAwait(false);
            }
            // Send Request
            if (_shouldTrace)
            {
                ServiceClientTracing.SendRequest(_invocationId, _httpRequest);
            }
            cancellationToken.ThrowIfCancellationRequested();
            _httpResponse = await Client.HttpClient.SendAsync(_httpRequest, cancellationToken).ConfigureAwait(false);
            if (_shouldTrace)
            {
                ServiceClientTracing.ReceiveResponse(_invocationId, _httpResponse);
            }
            HttpStatusCode _statusCode = _httpResponse.StatusCode;
            cancellationToken.ThrowIfCancellationRequested();
            string _responseContent = null;
            if ((int)_statusCode != 204)
            {
                var ex = new APIErrorException(string.Format("Operation returned an invalid status code '{0}'", _statusCode));
                try
                {
                    _responseContent = await _httpResponse.Content.ReadAsStringAsync().ConfigureAwait(false);
                    APIError _errorBody =  Rest.Serialization.SafeJsonConvert.DeserializeObject<APIError>(_responseContent, Client.DeserializationSettings);
                    if (_errorBody != null)
                    {
                        ex.Body = _errorBody;
                    }
                }
                catch (JsonException)
                {
                    // Ignore the exception
                }
                ex.Request = new HttpRequestMessageWrapper(_httpRequest, _requestContent);
                ex.Response = new HttpResponseMessageWrapper(_httpResponse, _responseContent);
                if (_shouldTrace)
                {
                    ServiceClientTracing.Error(_invocationId, ex);
                }
                _httpRequest.Dispose();
                if (_httpResponse != null)
                {
                    _httpResponse.Dispose();
                }
                throw ex;
            }
            // Create Result
            var _result = new HttpOperationResponse();
            _result.Request = _httpRequest;
            _result.Response = _httpResponse;
            if (_shouldTrace)
            {
                ServiceClientTracing.Exit(_invocationId, _result);
            }
            return _result;
        }

        /// <summary>
        /// The reviews created would show up for Reviewers on your team. As Reviewers
        /// complete reviewing, results of the Review would be POSTED (i.e. HTTP POST)
        /// on the specified CallBackEndpoint.
        ///
        /// &lt;h3&gt;CallBack Schemas &lt;/h3&gt;
        /// &lt;h4&gt;Review Completion CallBack Sample&lt;/h4&gt;
        /// &lt;p&gt;
        /// {&lt;br/&gt;
        /// "ReviewId": "&lt;Review Id&gt;",&lt;br/&gt;
        /// "ModifiedOn": "2016-10-11T22:36:32.9934851Z",&lt;br/&gt;
        /// "ModifiedBy": "&lt;Name of the Reviewer&gt;",&lt;br/&gt;
        /// "CallBackType": "Review",&lt;br/&gt;
        /// "ContentId": "&lt;The ContentId that was specified input&gt;",&lt;br/&gt;
        /// "Metadata": {&lt;br/&gt;
        /// "adultscore": "0.xxx",&lt;br/&gt;
        /// "a": "False",&lt;br/&gt;
        /// "racyscore": "0.xxx",&lt;br/&gt;
        /// "r": "True"&lt;br/&gt;
        /// },&lt;br/&gt;
        /// "ReviewerResultTags": {&lt;br/&gt;
        /// "a": "False",&lt;br/&gt;
        /// "r": "True"&lt;br/&gt;
        /// }&lt;br/&gt;
        /// }&lt;br/&gt;
        ///
        /// &lt;/p&gt;.
        /// </summary>
        /// <param name='contentType'>
        /// The content type.
        /// </param>
        /// <param name='teamName'>
        /// Your team name.
        /// </param>
        /// <param name='createVideoReviewsBody'>
        /// Body for create reviews API
        /// </param>
        /// <param name='subTeam'>
        /// SubTeam of your team, you want to assign the created review to.
        /// </param>
        /// <param name='customHeaders'>
        /// Headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        /// <exception cref="APIErrorException">
        /// Thrown when the operation returned an invalid status code
        /// </exception>
        /// <exception cref="SerializationException">
        /// Thrown when unable to deserialize the response
        /// </exception>
        /// <exception cref="ValidationException">
        /// Thrown when a required parameter is null
        /// </exception>
        /// <exception cref="System.ArgumentNullException">
        /// Thrown when a required parameter is null
        /// </exception>
        /// <return>
        /// A response object containing the response body and response headers.
        /// </return>
        public async Task<HttpOperationResponse<IList<string>>> CreateVideoReviewsWithHttpMessagesAsync(string contentType, string teamName, IList<CreateVideoReviewsBodyItem> createVideoReviewsBody, string subTeam = default(string), Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken))
        {
            if (Client.Endpoint == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "this.Client.Endpoint");
            }
            if (contentType == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "contentType");
            }
            if (teamName == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "teamName");
            }
            if (createVideoReviewsBody == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "createVideoReviewsBody");
            }
            if (createVideoReviewsBody != null)
            {
                foreach (var element in createVideoReviewsBody)
                {
                    if (element != null)
                    {
                        element.Validate();
                    }
                }
            }
            // Tracing
            bool _shouldTrace = ServiceClientTracing.IsEnabled;
            string _invocationId = null;
            if (_shouldTrace)
            {
                _invocationId = ServiceClientTracing.NextInvocationId.ToString();
                Dictionary<string, object> tracingParameters = new Dictionary<string, object>();
                tracingParameters.Add("contentType", contentType);
                tracingParameters.Add("teamName", teamName);
                tracingParameters.Add("subTeam", subTeam);
                tracingParameters.Add("createVideoReviewsBody", createVideoReviewsBody);
                tracingParameters.Add("cancellationToken", cancellationToken);
                ServiceClientTracing.Enter(_invocationId, this, "CreateVideoReviews", tracingParameters);
            }
            // Construct URL
            var _baseUrl = Client.BaseUri;
            var _url = _baseUrl + (_baseUrl.EndsWith("/") ? "" : "/") + "contentmoderator/review/v1.0/teams/{teamName}/reviews";
            _url = _url.Replace("{Endpoint}", Client.Endpoint);
            _url = _url.Replace("{teamName}", System.Uri.EscapeDataString(teamName));
            List<string> _queryParameters = new List<string>();
            if (subTeam != null)
            {
                _queryParameters.Add(string.Format("subTeam={0}", System.Uri.EscapeDataString(subTeam)));
            }
            if (_queryParameters.Count > 0)
            {
                _url += "?" + string.Join("&", _queryParameters);
            }
            // Create HTTP transport objects
            var _httpRequest = new HttpRequestMessage();
            HttpResponseMessage _httpResponse = null;
            _httpRequest.Method = new HttpMethod("POST");
            _httpRequest.RequestUri = new System.Uri(_url);
            // Set Headers


            if (customHeaders != null)
            {
                foreach(var _header in customHeaders)
                {
                    if (_httpRequest.Headers.Contains(_header.Key))
                    {
                        _httpRequest.Headers.Remove(_header.Key);
                    }
                    _httpRequest.Headers.TryAddWithoutValidation(_header.Key, _header.Value);
                }
            }

            // Serialize Request
            string _requestContent = null;
            if(createVideoReviewsBody != null)
            {
                _requestContent = Rest.Serialization.SafeJsonConvert.SerializeObject(createVideoReviewsBody, Client.SerializationSettings);
                _httpRequest.Content = new StringContent(_requestContent, System.Text.Encoding.UTF8);
                _httpRequest.Content.Headers.ContentType =MediaTypeHeaderValue.Parse("application/json; charset=utf-8");
            }
            // Set Credentials
            if (Client.Credentials != null)
            {
                cancellationToken.ThrowIfCancellationRequested();
                await Client.Credentials.ProcessHttpRequestAsync(_httpRequest, cancellationToken).ConfigureAwait(false);
            }
            // Send Request
            if (_shouldTrace)
            {
                ServiceClientTracing.SendRequest(_invocationId, _httpRequest);
            }
            cancellationToken.ThrowIfCancellationRequested();
            _httpResponse = await Client.HttpClient.SendAsync(_httpRequest, cancellationToken).ConfigureAwait(false);
            if (_shouldTrace)
            {
                ServiceClientTracing.ReceiveResponse(_invocationId, _httpResponse);
            }
            HttpStatusCode _statusCode = _httpResponse.StatusCode;
            cancellationToken.ThrowIfCancellationRequested();
            string _responseContent = null;
            if ((int)_statusCode != 200)
            {
                var ex = new APIErrorException(string.Format("Operation returned an invalid status code '{0}'", _statusCode));
                try
                {
                    _responseContent = await _httpResponse.Content.ReadAsStringAsync().ConfigureAwait(false);
                    APIError _errorBody =  Rest.Serialization.SafeJsonConvert.DeserializeObject<APIError>(_responseContent, Client.DeserializationSettings);
                    if (_errorBody != null)
                    {
                        ex.Body = _errorBody;
                    }
                }
                catch (JsonException)
                {
                    // Ignore the exception
                }
                ex.Request = new HttpRequestMessageWrapper(_httpRequest, _requestContent);
                ex.Response = new HttpResponseMessageWrapper(_httpResponse, _responseContent);
                if (_shouldTrace)
                {
                    ServiceClientTracing.Error(_invocationId, ex);
                }
                _httpRequest.Dispose();
                if (_httpResponse != null)
                {
                    _httpResponse.Dispose();
                }
                throw ex;
            }
            // Create Result
            var _result = new HttpOperationResponse<IList<string>>();
            _result.Request = _httpRequest;
            _result.Response = _httpResponse;
            // Deserialize Response
            if ((int)_statusCode == 200)
            {
                _responseContent = await _httpResponse.Content.ReadAsStringAsync().ConfigureAwait(false);
                try
                {
                    _result.Body = Rest.Serialization.SafeJsonConvert.DeserializeObject<IList<string>>(_responseContent, Client.DeserializationSettings);
                }
                catch (JsonException ex)
                {
                    _httpRequest.Dispose();
                    if (_httpResponse != null)
                    {
                        _httpResponse.Dispose();
                    }
                    throw new SerializationException("Unable to deserialize the response.", _responseContent, ex);
                }
            }
            if (_shouldTrace)
            {
                ServiceClientTracing.Exit(_invocationId, _result);
            }
            return _result;
        }

        /// <summary>
        /// Use this method to add frames for a video review.Timescale: This parameter
        /// is a factor which is used to convert the timestamp on a frame into
        /// milliseconds. Timescale is provided in the output of the Content Moderator
        /// video media processor on the Azure Media Services platform.Timescale in the
        /// Video Moderation output is Ticks/Second.
        /// </summary>
        /// <param name='contentType'>
        /// The content type.
        /// </param>
        /// <param name='teamName'>
        /// Your team name.
        /// </param>
        /// <param name='reviewId'>
        /// Id of the review.
        /// </param>
        /// <param name='videoFrameBody'>
        /// Body for add video frames API
        /// </param>
        /// <param name='timescale'>
        /// Timescale of the video.
        /// </param>
        /// <param name='customHeaders'>
        /// Headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        /// <exception cref="APIErrorException">
        /// Thrown when the operation returned an invalid status code
        /// </exception>
        /// <exception cref="ValidationException">
        /// Thrown when a required parameter is null
        /// </exception>
        /// <exception cref="System.ArgumentNullException">
        /// Thrown when a required parameter is null
        /// </exception>
        /// <return>
        /// A response object containing the response body and response headers.
        /// </return>
        public async Task<HttpOperationResponse> AddVideoFrameUrlWithHttpMessagesAsync(string contentType, string teamName, string reviewId, IList<VideoFrameBodyItem> videoFrameBody, int? timescale = default(int?), Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken))
        {
            if (Client.Endpoint == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "this.Client.Endpoint");
            }
            if (contentType == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "contentType");
            }
            if (teamName == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "teamName");
            }
            if (reviewId == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "reviewId");
            }
            if (videoFrameBody == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "videoFrameBody");
            }
            if (videoFrameBody != null)
            {
                foreach (var element in videoFrameBody)
                {
                    if (element != null)
                    {
                        element.Validate();
                    }
                }
            }
            // Tracing
            bool _shouldTrace = ServiceClientTracing.IsEnabled;
            string _invocationId = null;
            if (_shouldTrace)
            {
                _invocationId = ServiceClientTracing.NextInvocationId.ToString();
                Dictionary<string, object> tracingParameters = new Dictionary<string, object>();
                tracingParameters.Add("contentType", contentType);
                tracingParameters.Add("teamName", teamName);
                tracingParameters.Add("reviewId", reviewId);
                tracingParameters.Add("timescale", timescale);
                tracingParameters.Add("videoFrameBody", videoFrameBody);
                tracingParameters.Add("cancellationToken", cancellationToken);
                ServiceClientTracing.Enter(_invocationId, this, "AddVideoFrameUrl", tracingParameters);
            }
            // Construct URL
            var _baseUrl = Client.BaseUri;
            var _url = _baseUrl + (_baseUrl.EndsWith("/") ? "" : "/") + "contentmoderator/review/v1.0/teams/{teamName}/reviews/{reviewId}/frames";
            _url = _url.Replace("{Endpoint}", Client.Endpoint);
            _url = _url.Replace("{teamName}", System.Uri.EscapeDataString(teamName));
            _url = _url.Replace("{reviewId}", System.Uri.EscapeDataString(reviewId));
            List<string> _queryParameters = new List<string>();
            if (timescale != null)
            {
                _queryParameters.Add(string.Format("timescale={0}", System.Uri.EscapeDataString(Rest.Serialization.SafeJsonConvert.SerializeObject(timescale, Client.SerializationSettings).Trim('"'))));
            }
            if (_queryParameters.Count > 0)
            {
                _url += "?" + string.Join("&", _queryParameters);
            }
            // Create HTTP transport objects
            var _httpRequest = new HttpRequestMessage();
            HttpResponseMessage _httpResponse = null;
            _httpRequest.Method = new HttpMethod("POST");
            _httpRequest.RequestUri = new System.Uri(_url);
            // Set Headers


            if (customHeaders != null)
            {
                foreach(var _header in customHeaders)
                {
                    if (_httpRequest.Headers.Contains(_header.Key))
                    {
                        _httpRequest.Headers.Remove(_header.Key);
                    }
                    _httpRequest.Headers.TryAddWithoutValidation(_header.Key, _header.Value);
                }
            }

            // Serialize Request
            string _requestContent = null;
            if(videoFrameBody != null)
            {
                _requestContent = Rest.Serialization.SafeJsonConvert.SerializeObject(videoFrameBody, Client.SerializationSettings);
                _httpRequest.Content = new StringContent(_requestContent, System.Text.Encoding.UTF8);
                _httpRequest.Content.Headers.ContentType =MediaTypeHeaderValue.Parse("application/json; charset=utf-8");
            }
            // Set Credentials
            if (Client.Credentials != null)
            {
                cancellationToken.ThrowIfCancellationRequested();
                await Client.Credentials.ProcessHttpRequestAsync(_httpRequest, cancellationToken).ConfigureAwait(false);
            }
            // Send Request
            if (_shouldTrace)
            {
                ServiceClientTracing.SendRequest(_invocationId, _httpRequest);
            }
            cancellationToken.ThrowIfCancellationRequested();
            _httpResponse = await Client.HttpClient.SendAsync(_httpRequest, cancellationToken).ConfigureAwait(false);
            if (_shouldTrace)
            {
                ServiceClientTracing.ReceiveResponse(_invocationId, _httpResponse);
            }
            HttpStatusCode _statusCode = _httpResponse.StatusCode;
            cancellationToken.ThrowIfCancellationRequested();
            string _responseContent = null;
            if ((int)_statusCode != 204)
            {
                var ex = new APIErrorException(string.Format("Operation returned an invalid status code '{0}'", _statusCode));
                try
                {
                    _responseContent = await _httpResponse.Content.ReadAsStringAsync().ConfigureAwait(false);
                    APIError _errorBody =  Rest.Serialization.SafeJsonConvert.DeserializeObject<APIError>(_responseContent, Client.DeserializationSettings);
                    if (_errorBody != null)
                    {
                        ex.Body = _errorBody;
                    }
                }
                catch (JsonException)
                {
                    // Ignore the exception
                }
                ex.Request = new HttpRequestMessageWrapper(_httpRequest, _requestContent);
                ex.Response = new HttpResponseMessageWrapper(_httpResponse, _responseContent);
                if (_shouldTrace)
                {
                    ServiceClientTracing.Error(_invocationId, ex);
                }
                _httpRequest.Dispose();
                if (_httpResponse != null)
                {
                    _httpResponse.Dispose();
                }
                throw ex;
            }
            // Create Result
            var _result = new HttpOperationResponse();
            _result.Request = _httpRequest;
            _result.Response = _httpResponse;
            if (_shouldTrace)
            {
                ServiceClientTracing.Exit(_invocationId, _result);
            }
            return _result;
        }

        /// <summary>
        /// Use this method to add frames for a video review.Timescale: This parameter
        /// is a factor which is used to convert the timestamp on a frame into
        /// milliseconds. Timescale is provided in the output of the Content Moderator
        /// video media processor on the Azure Media Services platform.Timescale in the
        /// Video Moderation output is Ticks/Second.
        /// </summary>
        /// <param name='contentType'>
        /// The content type.
        /// </param>
        /// <param name='teamName'>
        /// Your team name.
        /// </param>
        /// <param name='reviewId'>
        /// Id of the review.
        /// </param>
        /// <param name='frameImageZip'>
        /// Zip file containing frame images.
        /// </param>
        /// <param name='frameMetadata'>
        /// Metadata of the frame.
        /// </param>
        /// <param name='timescale'>
        /// Timescale of the video .
        /// </param>
        /// <param name='customHeaders'>
        /// Headers that will be added to request.
        /// </param>
        /// <param name='cancellationToken'>
        /// The cancellation token.
        /// </param>
        /// <exception cref="APIErrorException">
        /// Thrown when the operation returned an invalid status code
        /// </exception>
        /// <exception cref="ValidationException">
        /// Thrown when a required parameter is null
        /// </exception>
        /// <exception cref="System.ArgumentNullException">
        /// Thrown when a required parameter is null
        /// </exception>
        /// <return>
        /// A response object containing the response body and response headers.
        /// </return>
        public async Task<HttpOperationResponse> AddVideoFrameStreamWithHttpMessagesAsync(string contentType, string teamName, string reviewId, Stream frameImageZip, string frameMetadata, int? timescale = default(int?), Dictionary<string, List<string>> customHeaders = null, CancellationToken cancellationToken = default(CancellationToken))
        {
            if (Client.Endpoint == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "this.Client.Endpoint");
            }
            if (contentType == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "contentType");
            }
            if (teamName == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "teamName");
            }
            if (reviewId == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "reviewId");
            }
            if (frameImageZip == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "frameImageZip");
            }
            if (frameMetadata == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "frameMetadata");
            }
            // Tracing
            bool _shouldTrace = ServiceClientTracing.IsEnabled;
            string _invocationId = null;
            if (_shouldTrace)
            {
                _invocationId = ServiceClientTracing.NextInvocationId.ToString();
                Dictionary<string, object> tracingParameters = new Dictionary<string, object>();
                tracingParameters.Add("contentType", contentType);
                tracingParameters.Add("teamName", teamName);
                tracingParameters.Add("reviewId", reviewId);
                tracingParameters.Add("timescale", timescale);
                tracingParameters.Add("frameImageZip", frameImageZip);
                tracingParameters.Add("frameMetadata", frameMetadata);
                tracingParameters.Add("cancellationToken", cancellationToken);
                ServiceClientTracing.Enter(_invocationId, this, "AddVideoFrameStream", tracingParameters);
            }
            // Construct URL
            var _baseUrl = Client.BaseUri;
            var _url = _baseUrl + (_baseUrl.EndsWith("/") ? "" : "/") + "contentmoderator/review/v1.0/teams/{teamName}/reviews/{reviewId}/frames";
            _url = _url.Replace("{Endpoint}", Client.Endpoint);
            _url = _url.Replace("{teamName}", System.Uri.EscapeDataString(teamName));
            _url = _url.Replace("{reviewId}", System.Uri.EscapeDataString(reviewId));
            List<string> _queryParameters = new List<string>();
            if (timescale != null)
            {
                _queryParameters.Add(string.Format("timescale={0}", System.Uri.EscapeDataString(Rest.Serialization.SafeJsonConvert.SerializeObject(timescale, Client.SerializationSettings).Trim('"'))));
            }
            if (_queryParameters.Count > 0)
            {
                _url += "?" + string.Join("&", _queryParameters);
            }
            // Create HTTP transport objects
            var _httpRequest = new HttpRequestMessage();
            HttpResponseMessage _httpResponse = null;
            _httpRequest.Method = new HttpMethod("POST");
            _httpRequest.RequestUri = new System.Uri(_url);
            // Set Headers


            if (customHeaders != null)
            {
                foreach(var _header in customHeaders)
                {
                    if (_httpRequest.Headers.Contains(_header.Key))
                    {
                        _httpRequest.Headers.Remove(_header.Key);
                    }
                    _httpRequest.Headers.TryAddWithoutValidation(_header.Key, _header.Value);
                }
            }

            // Serialize Request
            string _requestContent = null;
            MultipartFormDataContent _multiPartContent = new MultipartFormDataContent();
            if (frameImageZip != null)
            {
                StreamContent _frameImageZip = new StreamContent(frameImageZip);
                _frameImageZip.Headers.ContentType = new MediaTypeHeaderValue("application/octet-stream");
                ContentDispositionHeaderValue _contentDispositionHeaderValue = new ContentDispositionHeaderValue("form-data");
                _contentDispositionHeaderValue.Name = "frameImageZip";
                // get filename from stream if it's a file otherwise, just use  'unknown'
                var _fileStream = frameImageZip as FileStream;
                var _fileName = (_fileStream != null ? _fileStream.Name : null) ?? "unknown";
                if(System.Linq.Enumerable.Any(_fileName, c => c > 127) )
                {
                    // non ASCII chars detected, need UTF encoding:
                    _contentDispositionHeaderValue.FileNameStar = _fileName;
                }
                else
                {
                    // ASCII only
                    _contentDispositionHeaderValue.FileName = _fileName;
                }
                _frameImageZip.Headers.ContentDisposition = _contentDispositionHeaderValue;
                _multiPartContent.Add(_frameImageZip, "frameImageZip");
            }
            if (frameMetadata != null)
            {
                StringContent _frameMetadata = new StringContent(frameMetadata, System.Text.Encoding.UTF8);
                _multiPartContent.Add(_frameMetadata, "frameMetadata");
            }
            _httpRequest.Content = _multiPartContent;
            // Set Credentials
            if (Client.Credentials != null)
            {
                cancellationToken.ThrowIfCancellationRequested();
                await Client.Credentials.ProcessHttpRequestAsync(_httpRequest, cancellationToken).ConfigureAwait(false);
            }
            // Send Request
            if (_shouldTrace)
            {
                ServiceClientTracing.SendRequest(_invocationId, _httpRequest);
            }
            cancellationToken.ThrowIfCancellationRequested();
            _httpResponse = await Client.HttpClient.SendAsync(_httpRequest, cancellationToken).ConfigureAwait(false);
            if (_shouldTrace)
            {
                ServiceClientTracing.ReceiveResponse(_invocationId, _httpResponse);
            }
            HttpStatusCode _statusCode = _httpResponse.StatusCode;
            cancellationToken.ThrowIfCancellationRequested();
            string _responseContent = null;
            if ((int)_statusCode != 204)
            {
                var ex = new APIErrorException(string.Format("Operation returned an invalid status code '{0}'", _statusCode));
                try
                {
                    _responseContent = await _httpResponse.Content.ReadAsStringAsync().ConfigureAwait(false);
                    APIError _errorBody =  Rest.Serialization.SafeJsonConvert.DeserializeObject<APIError>(_responseContent, Client.DeserializationSettings);
                    if (_errorBody != null)
                    {
                        ex.Body = _errorBody;
                    }
                }
                catch (JsonException)
                {
                    // Ignore the exception
                }
                ex.Request = new HttpRequestMessageWrapper(_httpRequest, _requestContent);
                ex.Response = new HttpResponseMessageWrapper(_httpResponse, _responseContent);
                if (_shouldTrace)
                {
                    ServiceClientTracing.Error(_invocationId, ex);
                }
                _httpRequest.Dispose();
                if (_httpResponse != null)
                {
                    _httpResponse.Dispose();
                }
                throw ex;
            }
            // Create Result
            var _result = new HttpOperationResponse();
            _result.Request = _httpRequest;
            _result.Response = _httpResponse;
            if (_shouldTrace)
            {
                ServiceClientTracing.Exit(_invocationId, _result);
            }
            return _result;
        }

    }
}
