// <auto-generated>
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.ContentModerator
{
    using Models;
    using System.Collections;
    using System.Collections.Generic;
    using System.Threading;
    using System.Threading.Tasks;

    /// <summary>
    /// Extension methods for ListManagementTermLists.
    /// </summary>
    public static partial class ListManagementTermListsExtensions
    {
            /// <summary>
            /// Returns list Id details of the term list with list Id equal to list Id
            /// passed.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='listId'>
            /// List Id of the image list.
            /// </param>
            public static TermList GetDetails(this IListManagementTermLists operations, string listId)
            {
                return operations.GetDetailsAsync(listId).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Returns list Id details of the term list with list Id equal to list Id
            /// passed.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='listId'>
            /// List Id of the image list.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<TermList> GetDetailsAsync(this IListManagementTermLists operations, string listId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetDetailsWithHttpMessagesAsync(listId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Deletes term list with the list Id equal to list Id passed.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='listId'>
            /// List Id of the image list.
            /// </param>
            public static string Delete(this IListManagementTermLists operations, string listId)
            {
                return operations.DeleteAsync(listId).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Deletes term list with the list Id equal to list Id passed.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='listId'>
            /// List Id of the image list.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<string> DeleteAsync(this IListManagementTermLists operations, string listId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.DeleteWithHttpMessagesAsync(listId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Updates an Term List.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='listId'>
            /// List Id of the image list.
            /// </param>
            /// <param name='contentType'>
            /// The content type.
            /// </param>
            /// <param name='body'>
            /// Schema of the body.
            /// </param>
            public static TermList Update(this IListManagementTermLists operations, string listId, string contentType, Body body)
            {
                return operations.UpdateAsync(listId, contentType, body).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Updates an Term List.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='listId'>
            /// List Id of the image list.
            /// </param>
            /// <param name='contentType'>
            /// The content type.
            /// </param>
            /// <param name='body'>
            /// Schema of the body.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<TermList> UpdateAsync(this IListManagementTermLists operations, string listId, string contentType, Body body, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.UpdateWithHttpMessagesAsync(listId, contentType, body, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Creates a Term List
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='contentType'>
            /// The content type.
            /// </param>
            /// <param name='body'>
            /// Schema of the body.
            /// </param>
            public static TermList Create(this IListManagementTermLists operations, string contentType, Body body)
            {
                return operations.CreateAsync(contentType, body).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Creates a Term List
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='contentType'>
            /// The content type.
            /// </param>
            /// <param name='body'>
            /// Schema of the body.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<TermList> CreateAsync(this IListManagementTermLists operations, string contentType, Body body, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.CreateWithHttpMessagesAsync(contentType, body, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// gets all the Term Lists
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            public static IList<TermList> GetAllTermLists(this IListManagementTermLists operations)
            {
                return operations.GetAllTermListsAsync().GetAwaiter().GetResult();
            }

            /// <summary>
            /// gets all the Term Lists
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<IList<TermList>> GetAllTermListsAsync(this IListManagementTermLists operations, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetAllTermListsWithHttpMessagesAsync(null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Refreshes the index of the list with list Id equal to list ID passed.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='listId'>
            /// List Id of the image list.
            /// </param>
            /// <param name='language'>
            /// Language of the terms.
            /// </param>
            public static RefreshIndex RefreshIndexMethod(this IListManagementTermLists operations, string listId, string language)
            {
                return operations.RefreshIndexMethodAsync(listId, language).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Refreshes the index of the list with list Id equal to list ID passed.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='listId'>
            /// List Id of the image list.
            /// </param>
            /// <param name='language'>
            /// Language of the terms.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<RefreshIndex> RefreshIndexMethodAsync(this IListManagementTermLists operations, string listId, string language, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.RefreshIndexMethodWithHttpMessagesAsync(listId, language, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

    }
}
