// <auto-generated>
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.ContentModerator
{
    using Models;
    using System.IO;
    using System.Threading;
    using System.Threading.Tasks;

    /// <summary>
    /// Extension methods for ListManagementImage.
    /// </summary>
    public static partial class ListManagementImageExtensions
    {
            /// <summary>
            /// Add an image to the list with list Id equal to list Id passed.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='listId'>
            /// List Id of the image list.
            /// </param>
            /// <param name='tag'>
            /// Tag for the image.
            /// </param>
            /// <param name='label'>
            /// The image label.
            /// </param>
            public static Image AddImage(this IListManagementImage operations, string listId, int? tag = default(int?), string label = default(string))
            {
                return operations.AddImageAsync(listId, tag, label).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Add an image to the list with list Id equal to list Id passed.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='listId'>
            /// List Id of the image list.
            /// </param>
            /// <param name='tag'>
            /// Tag for the image.
            /// </param>
            /// <param name='label'>
            /// The image label.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<Image> AddImageAsync(this IListManagementImage operations, string listId, int? tag = default(int?), string label = default(string), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.AddImageWithHttpMessagesAsync(listId, tag, label, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Deletes all images from the list with list Id equal to list Id passed.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='listId'>
            /// List Id of the image list.
            /// </param>
            public static string DeleteAllImages(this IListManagementImage operations, string listId)
            {
                return operations.DeleteAllImagesAsync(listId).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Deletes all images from the list with list Id equal to list Id passed.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='listId'>
            /// List Id of the image list.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<string> DeleteAllImagesAsync(this IListManagementImage operations, string listId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.DeleteAllImagesWithHttpMessagesAsync(listId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Gets all image Ids from the list with list Id equal to list Id passed.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='listId'>
            /// List Id of the image list.
            /// </param>
            public static ImageIds GetAllImageIds(this IListManagementImage operations, string listId)
            {
                return operations.GetAllImageIdsAsync(listId).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Gets all image Ids from the list with list Id equal to list Id passed.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='listId'>
            /// List Id of the image list.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<ImageIds> GetAllImageIdsAsync(this IListManagementImage operations, string listId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.GetAllImageIdsWithHttpMessagesAsync(listId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Deletes an image from the list with list Id and image Id passed.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='listId'>
            /// List Id of the image list.
            /// </param>
            /// <param name='imageId'>
            /// Id of the image.
            /// </param>
            public static string DeleteImage(this IListManagementImage operations, string listId, string imageId)
            {
                return operations.DeleteImageAsync(listId, imageId).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Deletes an image from the list with list Id and image Id passed.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='listId'>
            /// List Id of the image list.
            /// </param>
            /// <param name='imageId'>
            /// Id of the image.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<string> DeleteImageAsync(this IListManagementImage operations, string listId, string imageId, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.DeleteImageWithHttpMessagesAsync(listId, imageId, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Add an image to the list with list Id equal to list Id passed.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='listId'>
            /// List Id of the image list.
            /// </param>
            /// <param name='contentType'>
            /// The content type.
            /// </param>
            /// <param name='imageUrl'>
            /// The image url.
            /// </param>
            /// <param name='tag'>
            /// Tag for the image.
            /// </param>
            /// <param name='label'>
            /// The image label.
            /// </param>
            public static Image AddImageUrlInput(this IListManagementImage operations, string listId, string contentType, BodyModel imageUrl, int? tag = default(int?), string label = default(string))
            {
                return operations.AddImageUrlInputAsync(listId, contentType, imageUrl, tag, label).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Add an image to the list with list Id equal to list Id passed.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='listId'>
            /// List Id of the image list.
            /// </param>
            /// <param name='contentType'>
            /// The content type.
            /// </param>
            /// <param name='imageUrl'>
            /// The image url.
            /// </param>
            /// <param name='tag'>
            /// Tag for the image.
            /// </param>
            /// <param name='label'>
            /// The image label.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<Image> AddImageUrlInputAsync(this IListManagementImage operations, string listId, string contentType, BodyModel imageUrl, int? tag = default(int?), string label = default(string), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.AddImageUrlInputWithHttpMessagesAsync(listId, contentType, imageUrl, tag, label, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Add an image to the list with list Id equal to list Id passed.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='listId'>
            /// List Id of the image list.
            /// </param>
            /// <param name='imageStream'>
            /// The image file.
            /// </param>
            /// <param name='tag'>
            /// Tag for the image.
            /// </param>
            /// <param name='label'>
            /// The image label.
            /// </param>
            public static Image AddImageFileInput(this IListManagementImage operations, string listId, Stream imageStream, int? tag = default(int?), string label = default(string))
            {
                return operations.AddImageFileInputAsync(listId, imageStream, tag, label).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Add an image to the list with list Id equal to list Id passed.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='listId'>
            /// List Id of the image list.
            /// </param>
            /// <param name='imageStream'>
            /// The image file.
            /// </param>
            /// <param name='tag'>
            /// Tag for the image.
            /// </param>
            /// <param name='label'>
            /// The image label.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<Image> AddImageFileInputAsync(this IListManagementImage operations, string listId, Stream imageStream, int? tag = default(int?), string label = default(string), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.AddImageFileInputWithHttpMessagesAsync(listId, imageStream, tag, label, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

    }
}
