// <auto-generated>
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.ContentModerator
{
    using Models;
    using System.IO;
    using System.Threading;
    using System.Threading.Tasks;

    /// <summary>
    /// Extension methods for ImageModeration.
    /// </summary>
    public static partial class ImageModerationExtensions
    {
            /// <summary>
            /// Returns the list of faces found.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='cacheImage'>
            /// Whether to retain the submitted image for future use; defaults to false if
            /// omitted.
            /// </param>
            public static FoundFaces FindFaces(this IImageModeration operations, bool? cacheImage = default(bool?))
            {
                return operations.FindFacesAsync(cacheImage).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Returns the list of faces found.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='cacheImage'>
            /// Whether to retain the submitted image for future use; defaults to false if
            /// omitted.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<FoundFaces> FindFacesAsync(this IImageModeration operations, bool? cacheImage = default(bool?), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.FindFacesWithHttpMessagesAsync(cacheImage, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Returns any text found in the image for the language specified. If no
            /// language is specified in input then the detection defaults to English.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='language'>
            /// Language of the terms.
            /// </param>
            /// <param name='cacheImage'>
            /// Whether to retain the submitted image for future use; defaults to false if
            /// omitted.
            /// </param>
            /// <param name='enhanced'>
            /// When set to True, the image goes through additional processing to come with
            /// additional candidates.
            ///
            /// image/tiff is not supported when enhanced is set to true
            ///
            /// Note: This impacts the response time.
            /// </param>
            public static OCR OCRMethod(this IImageModeration operations, string language, bool? cacheImage = default(bool?), bool? enhanced = false)
            {
                return operations.OCRMethodAsync(language, cacheImage, enhanced).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Returns any text found in the image for the language specified. If no
            /// language is specified in input then the detection defaults to English.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='language'>
            /// Language of the terms.
            /// </param>
            /// <param name='cacheImage'>
            /// Whether to retain the submitted image for future use; defaults to false if
            /// omitted.
            /// </param>
            /// <param name='enhanced'>
            /// When set to True, the image goes through additional processing to come with
            /// additional candidates.
            ///
            /// image/tiff is not supported when enhanced is set to true
            ///
            /// Note: This impacts the response time.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<OCR> OCRMethodAsync(this IImageModeration operations, string language, bool? cacheImage = default(bool?), bool? enhanced = false, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.OCRMethodWithHttpMessagesAsync(language, cacheImage, enhanced, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Returns probabilities of the image containing racy or adult content.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='cacheImage'>
            /// Whether to retain the submitted image for future use; defaults to false if
            /// omitted.
            /// </param>
            public static Evaluate EvaluateMethod(this IImageModeration operations, bool? cacheImage = default(bool?))
            {
                return operations.EvaluateMethodAsync(cacheImage).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Returns probabilities of the image containing racy or adult content.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='cacheImage'>
            /// Whether to retain the submitted image for future use; defaults to false if
            /// omitted.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<Evaluate> EvaluateMethodAsync(this IImageModeration operations, bool? cacheImage = default(bool?), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.EvaluateMethodWithHttpMessagesAsync(cacheImage, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Fuzzily match an image against one of your custom Image Lists. You can
            /// create and manage your custom image lists using &lt;a
            /// href="/docs/services/578ff44d2703741568569ab9/operations/578ff7b12703741568569abe"&gt;this&lt;/a&gt;
            /// API.
            ///
            /// Returns ID and tags of matching image.&lt;br/&gt;
            /// &lt;br/&gt;
            /// Note: Refresh Index must be run on the corresponding Image List before
            /// additions and removals are reflected in the response.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='listId'>
            /// The list Id.
            /// </param>
            /// <param name='cacheImage'>
            /// Whether to retain the submitted image for future use; defaults to false if
            /// omitted.
            /// </param>
            public static MatchResponse MatchMethod(this IImageModeration operations, string listId = default(string), bool? cacheImage = default(bool?))
            {
                return operations.MatchMethodAsync(listId, cacheImage).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Fuzzily match an image against one of your custom Image Lists. You can
            /// create and manage your custom image lists using &lt;a
            /// href="/docs/services/578ff44d2703741568569ab9/operations/578ff7b12703741568569abe"&gt;this&lt;/a&gt;
            /// API.
            ///
            /// Returns ID and tags of matching image.&lt;br/&gt;
            /// &lt;br/&gt;
            /// Note: Refresh Index must be run on the corresponding Image List before
            /// additions and removals are reflected in the response.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='listId'>
            /// The list Id.
            /// </param>
            /// <param name='cacheImage'>
            /// Whether to retain the submitted image for future use; defaults to false if
            /// omitted.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<MatchResponse> MatchMethodAsync(this IImageModeration operations, string listId = default(string), bool? cacheImage = default(bool?), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.MatchMethodWithHttpMessagesAsync(listId, cacheImage, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Returns the list of faces found.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='imageStream'>
            /// The image file.
            /// </param>
            /// <param name='cacheImage'>
            /// Whether to retain the submitted image for future use; defaults to false if
            /// omitted.
            /// </param>
            public static FoundFaces FindFacesFileInput(this IImageModeration operations, Stream imageStream, bool? cacheImage = default(bool?))
            {
                return operations.FindFacesFileInputAsync(imageStream, cacheImage).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Returns the list of faces found.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='imageStream'>
            /// The image file.
            /// </param>
            /// <param name='cacheImage'>
            /// Whether to retain the submitted image for future use; defaults to false if
            /// omitted.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<FoundFaces> FindFacesFileInputAsync(this IImageModeration operations, Stream imageStream, bool? cacheImage = default(bool?), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.FindFacesFileInputWithHttpMessagesAsync(imageStream, cacheImage, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Returns the list of faces found.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='contentType'>
            /// The content type.
            /// </param>
            /// <param name='imageUrl'>
            /// The image url.
            /// </param>
            /// <param name='cacheImage'>
            /// Whether to retain the submitted image for future use; defaults to false if
            /// omitted.
            /// </param>
            public static FoundFaces FindFacesUrlInput(this IImageModeration operations, string contentType, BodyModel imageUrl, bool? cacheImage = default(bool?))
            {
                return operations.FindFacesUrlInputAsync(contentType, imageUrl, cacheImage).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Returns the list of faces found.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='contentType'>
            /// The content type.
            /// </param>
            /// <param name='imageUrl'>
            /// The image url.
            /// </param>
            /// <param name='cacheImage'>
            /// Whether to retain the submitted image for future use; defaults to false if
            /// omitted.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<FoundFaces> FindFacesUrlInputAsync(this IImageModeration operations, string contentType, BodyModel imageUrl, bool? cacheImage = default(bool?), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.FindFacesUrlInputWithHttpMessagesAsync(contentType, imageUrl, cacheImage, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Returns any text found in the image for the language specified. If no
            /// language is specified in input then the detection defaults to English.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='language'>
            /// Language of the terms.
            /// </param>
            /// <param name='contentType'>
            /// The content type.
            /// </param>
            /// <param name='imageUrl'>
            /// The image url.
            /// </param>
            /// <param name='cacheImage'>
            /// Whether to retain the submitted image for future use; defaults to false if
            /// omitted.
            /// </param>
            /// <param name='enhanced'>
            /// When set to True, the image goes through additional processing to come with
            /// additional candidates.
            ///
            /// image/tiff is not supported when enhanced is set to true
            ///
            /// Note: This impacts the response time.
            /// </param>
            public static OCR OCRUrlInput(this IImageModeration operations, string language, string contentType, BodyModel imageUrl, bool? cacheImage = default(bool?), bool? enhanced = false)
            {
                return operations.OCRUrlInputAsync(language, contentType, imageUrl, cacheImage, enhanced).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Returns any text found in the image for the language specified. If no
            /// language is specified in input then the detection defaults to English.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='language'>
            /// Language of the terms.
            /// </param>
            /// <param name='contentType'>
            /// The content type.
            /// </param>
            /// <param name='imageUrl'>
            /// The image url.
            /// </param>
            /// <param name='cacheImage'>
            /// Whether to retain the submitted image for future use; defaults to false if
            /// omitted.
            /// </param>
            /// <param name='enhanced'>
            /// When set to True, the image goes through additional processing to come with
            /// additional candidates.
            ///
            /// image/tiff is not supported when enhanced is set to true
            ///
            /// Note: This impacts the response time.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<OCR> OCRUrlInputAsync(this IImageModeration operations, string language, string contentType, BodyModel imageUrl, bool? cacheImage = default(bool?), bool? enhanced = false, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.OCRUrlInputWithHttpMessagesAsync(language, contentType, imageUrl, cacheImage, enhanced, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Returns any text found in the image for the language specified. If no
            /// language is specified in input then the detection defaults to English.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='language'>
            /// Language of the terms.
            /// </param>
            /// <param name='imageStream'>
            /// The image file.
            /// </param>
            /// <param name='cacheImage'>
            /// Whether to retain the submitted image for future use; defaults to false if
            /// omitted.
            /// </param>
            /// <param name='enhanced'>
            /// When set to True, the image goes through additional processing to come with
            /// additional candidates.
            ///
            /// image/tiff is not supported when enhanced is set to true
            ///
            /// Note: This impacts the response time.
            /// </param>
            public static OCR OCRFileInput(this IImageModeration operations, string language, Stream imageStream, bool? cacheImage = default(bool?), bool? enhanced = false)
            {
                return operations.OCRFileInputAsync(language, imageStream, cacheImage, enhanced).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Returns any text found in the image for the language specified. If no
            /// language is specified in input then the detection defaults to English.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='language'>
            /// Language of the terms.
            /// </param>
            /// <param name='imageStream'>
            /// The image file.
            /// </param>
            /// <param name='cacheImage'>
            /// Whether to retain the submitted image for future use; defaults to false if
            /// omitted.
            /// </param>
            /// <param name='enhanced'>
            /// When set to True, the image goes through additional processing to come with
            /// additional candidates.
            ///
            /// image/tiff is not supported when enhanced is set to true
            ///
            /// Note: This impacts the response time.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<OCR> OCRFileInputAsync(this IImageModeration operations, string language, Stream imageStream, bool? cacheImage = default(bool?), bool? enhanced = false, CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.OCRFileInputWithHttpMessagesAsync(language, imageStream, cacheImage, enhanced, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Returns probabilities of the image containing racy or adult content.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='imageStream'>
            /// The image file.
            /// </param>
            /// <param name='cacheImage'>
            /// Whether to retain the submitted image for future use; defaults to false if
            /// omitted.
            /// </param>
            public static Evaluate EvaluateFileInput(this IImageModeration operations, Stream imageStream, bool? cacheImage = default(bool?))
            {
                return operations.EvaluateFileInputAsync(imageStream, cacheImage).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Returns probabilities of the image containing racy or adult content.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='imageStream'>
            /// The image file.
            /// </param>
            /// <param name='cacheImage'>
            /// Whether to retain the submitted image for future use; defaults to false if
            /// omitted.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<Evaluate> EvaluateFileInputAsync(this IImageModeration operations, Stream imageStream, bool? cacheImage = default(bool?), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.EvaluateFileInputWithHttpMessagesAsync(imageStream, cacheImage, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Returns probabilities of the image containing racy or adult content.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='contentType'>
            /// The content type.
            /// </param>
            /// <param name='imageUrl'>
            /// The image url.
            /// </param>
            /// <param name='cacheImage'>
            /// Whether to retain the submitted image for future use; defaults to false if
            /// omitted.
            /// </param>
            public static Evaluate EvaluateUrlInput(this IImageModeration operations, string contentType, BodyModel imageUrl, bool? cacheImage = default(bool?))
            {
                return operations.EvaluateUrlInputAsync(contentType, imageUrl, cacheImage).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Returns probabilities of the image containing racy or adult content.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='contentType'>
            /// The content type.
            /// </param>
            /// <param name='imageUrl'>
            /// The image url.
            /// </param>
            /// <param name='cacheImage'>
            /// Whether to retain the submitted image for future use; defaults to false if
            /// omitted.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<Evaluate> EvaluateUrlInputAsync(this IImageModeration operations, string contentType, BodyModel imageUrl, bool? cacheImage = default(bool?), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.EvaluateUrlInputWithHttpMessagesAsync(contentType, imageUrl, cacheImage, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Fuzzily match an image against one of your custom Image Lists. You can
            /// create and manage your custom image lists using &lt;a
            /// href="/docs/services/578ff44d2703741568569ab9/operations/578ff7b12703741568569abe"&gt;this&lt;/a&gt;
            /// API.
            ///
            /// Returns ID and tags of matching image.&lt;br/&gt;
            /// &lt;br/&gt;
            /// Note: Refresh Index must be run on the corresponding Image List before
            /// additions and removals are reflected in the response.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='contentType'>
            /// The content type.
            /// </param>
            /// <param name='imageUrl'>
            /// The image url.
            /// </param>
            /// <param name='listId'>
            /// The list Id.
            /// </param>
            /// <param name='cacheImage'>
            /// Whether to retain the submitted image for future use; defaults to false if
            /// omitted.
            /// </param>
            public static MatchResponse MatchUrlInput(this IImageModeration operations, string contentType, BodyModel imageUrl, string listId = default(string), bool? cacheImage = default(bool?))
            {
                return operations.MatchUrlInputAsync(contentType, imageUrl, listId, cacheImage).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Fuzzily match an image against one of your custom Image Lists. You can
            /// create and manage your custom image lists using &lt;a
            /// href="/docs/services/578ff44d2703741568569ab9/operations/578ff7b12703741568569abe"&gt;this&lt;/a&gt;
            /// API.
            ///
            /// Returns ID and tags of matching image.&lt;br/&gt;
            /// &lt;br/&gt;
            /// Note: Refresh Index must be run on the corresponding Image List before
            /// additions and removals are reflected in the response.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='contentType'>
            /// The content type.
            /// </param>
            /// <param name='imageUrl'>
            /// The image url.
            /// </param>
            /// <param name='listId'>
            /// The list Id.
            /// </param>
            /// <param name='cacheImage'>
            /// Whether to retain the submitted image for future use; defaults to false if
            /// omitted.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<MatchResponse> MatchUrlInputAsync(this IImageModeration operations, string contentType, BodyModel imageUrl, string listId = default(string), bool? cacheImage = default(bool?), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.MatchUrlInputWithHttpMessagesAsync(contentType, imageUrl, listId, cacheImage, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

            /// <summary>
            /// Fuzzily match an image against one of your custom Image Lists. You can
            /// create and manage your custom image lists using &lt;a
            /// href="/docs/services/578ff44d2703741568569ab9/operations/578ff7b12703741568569abe"&gt;this&lt;/a&gt;
            /// API.
            ///
            /// Returns ID and tags of matching image.&lt;br/&gt;
            /// &lt;br/&gt;
            /// Note: Refresh Index must be run on the corresponding Image List before
            /// additions and removals are reflected in the response.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='imageStream'>
            /// The image file.
            /// </param>
            /// <param name='listId'>
            /// The list Id.
            /// </param>
            /// <param name='cacheImage'>
            /// Whether to retain the submitted image for future use; defaults to false if
            /// omitted.
            /// </param>
            public static MatchResponse MatchFileInput(this IImageModeration operations, Stream imageStream, string listId = default(string), bool? cacheImage = default(bool?))
            {
                return operations.MatchFileInputAsync(imageStream, listId, cacheImage).GetAwaiter().GetResult();
            }

            /// <summary>
            /// Fuzzily match an image against one of your custom Image Lists. You can
            /// create and manage your custom image lists using &lt;a
            /// href="/docs/services/578ff44d2703741568569ab9/operations/578ff7b12703741568569abe"&gt;this&lt;/a&gt;
            /// API.
            ///
            /// Returns ID and tags of matching image.&lt;br/&gt;
            /// &lt;br/&gt;
            /// Note: Refresh Index must be run on the corresponding Image List before
            /// additions and removals are reflected in the response.
            /// </summary>
            /// <param name='operations'>
            /// The operations group for this extension method.
            /// </param>
            /// <param name='imageStream'>
            /// The image file.
            /// </param>
            /// <param name='listId'>
            /// The list Id.
            /// </param>
            /// <param name='cacheImage'>
            /// Whether to retain the submitted image for future use; defaults to false if
            /// omitted.
            /// </param>
            /// <param name='cancellationToken'>
            /// The cancellation token.
            /// </param>
            public static async Task<MatchResponse> MatchFileInputAsync(this IImageModeration operations, Stream imageStream, string listId = default(string), bool? cacheImage = default(bool?), CancellationToken cancellationToken = default(CancellationToken))
            {
                using (var _result = await operations.MatchFileInputWithHttpMessagesAsync(imageStream, listId, cacheImage, null, cancellationToken).ConfigureAwait(false))
                {
                    return _result.Body;
                }
            }

    }
}
