// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Vision.ComputerVision.Models
{
    using Microsoft.Rest;
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    /// <summary>
    /// Text extracted from a page in the input document.
    /// </summary>
    public partial class ReadResult
    {
        /// <summary>
        /// Initializes a new instance of the ReadResult class.
        /// </summary>
        public ReadResult()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the ReadResult class.
        /// </summary>
        /// <param name="page">The 1-based page number of the recognition
        /// result.</param>
        /// <param name="angle">The orientation of the image in degrees in the
        /// clockwise direction. Range between [-180, 180).</param>
        /// <param name="width">The width of the image in pixels or the PDF in
        /// inches.</param>
        /// <param name="height">The height of the image in pixels or the PDF
        /// in inches.</param>
        /// <param name="unit">The unit used in the Width, Height and
        /// BoundingBox. For images, the unit is 'pixel'. For PDF, the unit is
        /// 'inch'. Possible values include: 'pixel', 'inch'</param>
        /// <param name="lines">A list of recognized text lines.</param>
        /// <param name="language">The BCP-47 language code of the recognized
        /// text page.</param>
        public ReadResult(int page, double angle, double width, double height, TextRecognitionResultDimensionUnit unit, IList<Line> lines, string language = default(string))
        {
            Page = page;
            Language = language;
            Angle = angle;
            Width = width;
            Height = height;
            Unit = unit;
            Lines = lines;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets the 1-based page number of the recognition result.
        /// </summary>
        [JsonProperty(PropertyName = "page")]
        public int Page { get; set; }

        /// <summary>
        /// Gets or sets the BCP-47 language code of the recognized text page.
        /// </summary>
        [JsonProperty(PropertyName = "language")]
        public string Language { get; set; }

        /// <summary>
        /// Gets or sets the orientation of the image in degrees in the
        /// clockwise direction. Range between [-180, 180).
        /// </summary>
        [JsonProperty(PropertyName = "angle")]
        public double Angle { get; set; }

        /// <summary>
        /// Gets or sets the width of the image in pixels or the PDF in inches.
        /// </summary>
        [JsonProperty(PropertyName = "width")]
        public double Width { get; set; }

        /// <summary>
        /// Gets or sets the height of the image in pixels or the PDF in
        /// inches.
        /// </summary>
        [JsonProperty(PropertyName = "height")]
        public double Height { get; set; }

        /// <summary>
        /// Gets or sets the unit used in the Width, Height and BoundingBox.
        /// For images, the unit is 'pixel'. For PDF, the unit is 'inch'.
        /// Possible values include: 'pixel', 'inch'
        /// </summary>
        [JsonProperty(PropertyName = "unit")]
        public TextRecognitionResultDimensionUnit Unit { get; set; }

        /// <summary>
        /// Gets or sets a list of recognized text lines.
        /// </summary>
        [JsonProperty(PropertyName = "lines")]
        public IList<Line> Lines { get; set; }

        /// <summary>
        /// Validate the object.
        /// </summary>
        /// <exception cref="ValidationException">
        /// Thrown if validation fails
        /// </exception>
        public virtual void Validate()
        {
            if (Lines == null)
            {
                throw new ValidationException(ValidationRules.CannotBeNull, "Lines");
            }
            if (Lines != null)
            {
                foreach (var element in Lines)
                {
                    if (element != null)
                    {
                        element.Validate();
                    }
                }
            }
        }
    }
}
