// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Vision.ComputerVision.Models
{
    using Newtonsoft.Json;
    using System.Linq;

    /// <summary>
    /// OCR result of the read operation.
    /// </summary>
    public partial class ReadOperationResult
    {
        /// <summary>
        /// Initializes a new instance of the ReadOperationResult class.
        /// </summary>
        public ReadOperationResult()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the ReadOperationResult class.
        /// </summary>
        /// <param name="status">Status of the read operation. Possible values
        /// include: 'notStarted', 'running', 'failed', 'succeeded'</param>
        /// <param name="createdDateTime">Get UTC date time the batch operation
        /// was submitted.</param>
        /// <param name="lastUpdatedDateTime">Get last updated UTC date time of
        /// this batch operation.</param>
        /// <param name="analyzeResult">Analyze batch operation result.</param>
        public ReadOperationResult(OperationStatusCodes status = default(OperationStatusCodes), string createdDateTime = default(string), string lastUpdatedDateTime = default(string), AnalyzeResults analyzeResult = default(AnalyzeResults))
        {
            Status = status;
            CreatedDateTime = createdDateTime;
            LastUpdatedDateTime = lastUpdatedDateTime;
            AnalyzeResult = analyzeResult;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets status of the read operation. Possible values include:
        /// 'notStarted', 'running', 'failed', 'succeeded'
        /// </summary>
        [JsonProperty(PropertyName = "status")]
        public OperationStatusCodes Status { get; set; }

        /// <summary>
        /// Gets or sets get UTC date time the batch operation was submitted.
        /// </summary>
        [JsonProperty(PropertyName = "createdDateTime")]
        public string CreatedDateTime { get; set; }

        /// <summary>
        /// Gets or sets get last updated UTC date time of this batch
        /// operation.
        /// </summary>
        [JsonProperty(PropertyName = "lastUpdatedDateTime")]
        public string LastUpdatedDateTime { get; set; }

        /// <summary>
        /// Gets or sets analyze batch operation result.
        /// </summary>
        [JsonProperty(PropertyName = "analyzeResult")]
        public AnalyzeResults AnalyzeResult { get; set; }

        /// <summary>
        /// Validate the object.
        /// </summary>
        /// <exception cref="Rest.ValidationException">
        /// Thrown if validation fails
        /// </exception>
        public virtual void Validate()
        {
            if (AnalyzeResult != null)
            {
                AnalyzeResult.Validate();
            }
        }
    }
}
