// <auto-generated>
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for
// license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
// </auto-generated>

namespace Microsoft.Azure.CognitiveServices.Vision.ComputerVision.Models
{
    using Newtonsoft.Json;
    using System.Collections;
    using System.Collections.Generic;
    using System.Linq;

    public partial class OcrResult
    {
        /// <summary>
        /// Initializes a new instance of the OcrResult class.
        /// </summary>
        public OcrResult()
        {
            CustomInit();
        }

        /// <summary>
        /// Initializes a new instance of the OcrResult class.
        /// </summary>
        /// <param name="language">The BCP-47 language code of the text in the
        /// image.</param>
        /// <param name="textAngle">The angle, in radians, of the detected text
        /// with respect to the closest horizontal or vertical direction. After
        /// rotating the input image clockwise by this angle, the recognized
        /// text lines become horizontal or vertical. In combination with the
        /// orientation property it can be used to overlay recognition results
        /// correctly on the original image, by rotating either the original
        /// image or recognition results by a suitable angle around the center
        /// of the original image. If the angle cannot be confidently detected,
        /// this property is not present. If the image contains text at
        /// different angles, only part of the text will be recognized
        /// correctly.</param>
        /// <param name="orientation">Orientation of the text recognized in the
        /// image, if requested. The value (up, down, left, or right) refers to
        /// the direction that the top of the recognized text is facing, after
        /// the image has been rotated around its center according to the
        /// detected text angle (see textAngle property).
        /// If detection of the orientation was not requested, or no text is
        /// detected, the value is 'NotDetected'.</param>
        /// <param name="regions">An array of objects, where each object
        /// represents a region of recognized text.</param>
        public OcrResult(string language = default(string), double textAngle = default(double), string orientation = default(string), IList<OcrRegion> regions = default(IList<OcrRegion>), string modelVersion = default(string))
        {
            Language = language;
            TextAngle = textAngle;
            Orientation = orientation;
            Regions = regions;
            ModelVersion = modelVersion;
            CustomInit();
        }

        /// <summary>
        /// An initialization method that performs custom operations like setting defaults
        /// </summary>
        partial void CustomInit();

        /// <summary>
        /// Gets or sets the BCP-47 language code of the text in the image.
        /// </summary>
        [JsonProperty(PropertyName = "language")]
        public string Language { get; set; }

        /// <summary>
        /// Gets or sets the angle, in radians, of the detected text with
        /// respect to the closest horizontal or vertical direction. After
        /// rotating the input image clockwise by this angle, the recognized
        /// text lines become horizontal or vertical. In combination with the
        /// orientation property it can be used to overlay recognition results
        /// correctly on the original image, by rotating either the original
        /// image or recognition results by a suitable angle around the center
        /// of the original image. If the angle cannot be confidently detected,
        /// this property is not present. If the image contains text at
        /// different angles, only part of the text will be recognized
        /// correctly.
        /// </summary>
        [JsonProperty(PropertyName = "textAngle")]
        public double TextAngle { get; set; }

        /// <summary>
        /// Gets or sets orientation of the text recognized in the image, if
        /// requested. The value (up, down, left, or right) refers to the
        /// direction that the top of the recognized text is facing, after the
        /// image has been rotated around its center according to the detected
        /// text angle (see textAngle property).
        /// If detection of the orientation was not requested, or no text is
        /// detected, the value is 'NotDetected'.
        /// </summary>
        [JsonProperty(PropertyName = "orientation")]
        public string Orientation { get; set; }

        /// <summary>
        /// Gets or sets an array of objects, where each object represents a
        /// region of recognized text.
        /// </summary>
        [JsonProperty(PropertyName = "regions")]
        public IList<OcrRegion> Regions { get; set; }

        /// <summary>
        /// </summary>
        [JsonProperty(PropertyName = "modelVersion")]
        public string ModelVersion { get; set; }

    }
}
